/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde;

import com.amazonaws.athena.connector.lambda.serde.BaseDeserializer;
import com.amazonaws.athena.connector.lambda.serde.TypedDeserializer;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public class DelegatingDeserializer<T>
extends BaseDeserializer<T> {
    private final Map<String, TypedDeserializer<T>> delegateSerDeMap;

    public DelegatingDeserializer(Class<T> clazz, Set<TypedDeserializer<T>> serDes) {
        super(clazz);
        ImmutableMap.Builder delegateSerDeMapBuilder = ImmutableMap.builder();
        for (TypedDeserializer<T> serDe : serDes) {
            delegateSerDeMapBuilder.put((Object)serDe.getSubType().getSimpleName(), serDe);
        }
        this.delegateSerDeMap = delegateSerDeMapBuilder.build();
    }

    @Override
    public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return this.doDeserialize(jp, ctxt);
    }

    @Override
    public T doDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
        String type = this.getType(jparser);
        TypedDeserializer<T> delegateSerDe = this.delegateSerDeMap.get(type);
        if (delegateSerDe != null) {
            return delegateSerDe.doTypedDeserialize(jparser, ctxt);
        }
        throw new IllegalStateException("No SerDe configured for " + type);
    }

    public Map<String, TypedDeserializer<T>> getDelegateSerDeMap() {
        return this.delegateSerDeMap;
    }
}

