/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde;

import com.amazonaws.athena.connector.lambda.request.FederationResponse;
import com.amazonaws.athena.connector.lambda.request.PingResponse;
import com.amazonaws.athena.connector.lambda.serde.TypedDeserializer;
import com.amazonaws.athena.connector.lambda.serde.TypedSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;

public final class PingResponseSerDe {
    private static final String CATALOG_NAME_FIELD = "catalogName";
    private static final String QUERY_ID_FIELD = "queryId";
    private static final String SOURCE_TYPE_FIELD = "sourceType";
    private static final String CAPABILITIES_FIELD = "capabilities";
    private static final String SERDE_VERSION_FIELD = "serDeVersion";

    private PingResponseSerDe() {
    }

    public static final class Deserializer
    extends TypedDeserializer<FederationResponse> {
        public Deserializer() {
            super(FederationResponse.class, PingResponse.class);
        }

        @Override
        public FederationResponse deserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
            this.validateObjectStart(jparser.getCurrentToken());
            return (FederationResponse)this.doDeserialize(jparser, ctxt);
        }

        @Override
        protected FederationResponse doTypedDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
            int serDeVersion;
            String catalogName = this.getNextStringField(jparser, PingResponseSerDe.CATALOG_NAME_FIELD);
            String queryId = this.getNextStringField(jparser, PingResponseSerDe.QUERY_ID_FIELD);
            String sourceType = this.getNextStringField(jparser, PingResponseSerDe.SOURCE_TYPE_FIELD);
            int capabilities = this.getNextIntField(jparser, PingResponseSerDe.CAPABILITIES_FIELD);
            try {
                serDeVersion = this.getNextIntField(jparser, PingResponseSerDe.SERDE_VERSION_FIELD);
            }
            catch (IllegalStateException e) {
                serDeVersion = 1;
            }
            return new PingResponse(catalogName, queryId, sourceType, capabilities, serDeVersion);
        }
    }

    public static final class Serializer
    extends TypedSerializer<FederationResponse> {
        public Serializer() {
            super(FederationResponse.class, PingResponse.class);
        }

        @Override
        protected void doTypedSerialize(FederationResponse federationResponse, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            PingResponse pingResponse = (PingResponse)federationResponse;
            jgen.writeStringField(PingResponseSerDe.CATALOG_NAME_FIELD, pingResponse.getCatalogName());
            jgen.writeStringField(PingResponseSerDe.QUERY_ID_FIELD, pingResponse.getQueryId());
            jgen.writeStringField(PingResponseSerDe.SOURCE_TYPE_FIELD, pingResponse.getSourceType());
            jgen.writeNumberField(PingResponseSerDe.CAPABILITIES_FIELD, pingResponse.getCapabilities());
            jgen.writeNumberField(PingResponseSerDe.SERDE_VERSION_FIELD, pingResponse.getSerDeVersion());
        }
    }
}

