/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde;

import com.amazonaws.athena.connector.lambda.serde.BaseSerializer;
import com.amazonaws.athena.connector.lambda.serde.VersionedSerDe;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Objects;

public abstract class TypedSerializer<T>
extends BaseSerializer<T>
implements VersionedSerDe.Serializer<T> {
    private Class<? extends T> subType;

    protected TypedSerializer(Class<T> superType, Class<? extends T> subType) {
        super(superType);
        this.subType = Objects.requireNonNull(subType, "subType is null");
    }

    public Class<? extends T> getSubType() {
        return this.subType;
    }

    @Override
    public void doSerialize(T value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        this.writeType(jgen, this.subType);
        this.doTypedSerialize(value, jgen, provider);
    }

    protected abstract void doTypedSerialize(T var1, JsonGenerator var2, SerializerProvider var3) throws IOException;
}

