/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde;

import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.serde.ObjectMapperFactory;
import com.amazonaws.athena.connector.lambda.serde.v2.ObjectMapperFactoryV2;
import com.amazonaws.athena.connector.lambda.serde.v3.ObjectMapperFactoryV3;
import com.amazonaws.athena.connector.lambda.serde.v4.ObjectMapperFactoryV4;
import com.fasterxml.jackson.databind.ObjectMapper;

public class VersionedObjectMapperFactory {
    private VersionedObjectMapperFactory() {
    }

    public static ObjectMapper create(BlockAllocator allocator) {
        return VersionedObjectMapperFactory.create(allocator, 4);
    }

    public static ObjectMapper create(BlockAllocator allocator, int version) {
        switch (version) {
            case 1: {
                return ObjectMapperFactory.create(allocator);
            }
            case 2: {
                return ObjectMapperFactoryV2.create(allocator);
            }
            case 3: {
                return ObjectMapperFactoryV3.create(allocator);
            }
            case 4: {
                return ObjectMapperFactoryV4.create(allocator);
            }
        }
        throw new IllegalArgumentException("No serde version " + version);
    }
}

