/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v2;

import com.amazonaws.athena.connector.lambda.domain.TableName;
import com.amazonaws.athena.connector.lambda.metadata.GetTableRequest;
import com.amazonaws.athena.connector.lambda.metadata.MetadataRequest;
import com.amazonaws.athena.connector.lambda.request.FederationRequest;
import com.amazonaws.athena.connector.lambda.security.FederatedIdentity;
import com.amazonaws.athena.connector.lambda.serde.FederatedIdentitySerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.MetadataRequestDeserializer;
import com.amazonaws.athena.connector.lambda.serde.v2.MetadataRequestSerializer;
import com.amazonaws.athena.connector.lambda.serde.v2.TableNameSerDe;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Objects;

public final class GetTableRequestSerDe {
    private static final String TABLE_NAME_FIELD = "tableName";

    private GetTableRequestSerDe() {
    }

    public static final class Deserializer
    extends MetadataRequestDeserializer {
        private final FederatedIdentitySerDe.Deserializer identityDeserializer;
        private final TableNameSerDe.Deserializer tableNameDeserializer;

        public Deserializer(FederatedIdentitySerDe.Deserializer identityDeserializer, TableNameSerDe.Deserializer tableNameDeserializer) {
            super(GetTableRequest.class, identityDeserializer);
            this.identityDeserializer = Objects.requireNonNull(identityDeserializer, "identityDeserializer is null");
            this.tableNameDeserializer = Objects.requireNonNull(tableNameDeserializer, "tableNameDeserializer is null");
        }

        @Override
        protected MetadataRequest doRequestDeserialize(JsonParser jparser, DeserializationContext ctxt, FederatedIdentity identity, String queryId, String catalogName) throws IOException {
            this.assertFieldName(jparser, GetTableRequestSerDe.TABLE_NAME_FIELD);
            TableName tableName = (TableName)this.tableNameDeserializer.deserialize(jparser, ctxt);
            return new GetTableRequest(identity, queryId, catalogName, tableName);
        }
    }

    public static final class Serializer
    extends MetadataRequestSerializer {
        private final FederatedIdentitySerDe.Serializer identitySerializer;
        private final TableNameSerDe.Serializer tableNameSerializer;

        public Serializer(FederatedIdentitySerDe.Serializer identitySerializer, TableNameSerDe.Serializer tableNameSerializer) {
            super(GetTableRequest.class, identitySerializer);
            this.identitySerializer = Objects.requireNonNull(identitySerializer, "identitySerializer is null");
            this.tableNameSerializer = Objects.requireNonNull(tableNameSerializer, "tableNameSerializer is null");
        }

        @Override
        protected void doRequestSerialize(FederationRequest federationRequest, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            GetTableRequest getTableRequest = (GetTableRequest)federationRequest;
            jgen.writeFieldName(GetTableRequestSerDe.TABLE_NAME_FIELD);
            this.tableNameSerializer.serialize(getTableRequest.getTableName(), jgen, provider);
        }
    }
}

