/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v2;

import com.amazonaws.athena.connector.lambda.domain.TableName;
import com.amazonaws.athena.connector.lambda.metadata.ListTablesResponse;
import com.amazonaws.athena.connector.lambda.request.FederationResponse;
import com.amazonaws.athena.connector.lambda.serde.TypedDeserializer;
import com.amazonaws.athena.connector.lambda.serde.TypedSerializer;
import com.amazonaws.athena.connector.lambda.serde.v2.TableNameSerDe;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;

public final class ListTablesResponseSerDe {
    private static final String TABLES_FIELD = "tables";
    private static final String CATALOG_NAME_FIELD = "catalogName";
    private static final String NEXT_TOKEN_FIELD = "nextToken";

    private ListTablesResponseSerDe() {
    }

    public static final class Deserializer
    extends TypedDeserializer<FederationResponse> {
        private final TableNameSerDe.Deserializer tableNameDeserializer;

        public Deserializer(TableNameSerDe.Deserializer tableNameDeserializer) {
            super(FederationResponse.class, ListTablesResponse.class);
            this.tableNameDeserializer = Objects.requireNonNull(tableNameDeserializer, "tableNameDeserializer is null");
        }

        @Override
        protected FederationResponse doTypedDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
            this.assertFieldName(jparser, ListTablesResponseSerDe.TABLES_FIELD);
            ImmutableList.Builder tablesList = ImmutableList.builder();
            this.validateArrayStart(jparser);
            while (jparser.nextToken() != JsonToken.END_ARRAY) {
                this.validateObjectStart(jparser.getCurrentToken());
                tablesList.add((Object)this.tableNameDeserializer.doDeserialize(jparser, ctxt));
                this.validateObjectEnd(jparser);
            }
            String catalogName = this.getNextStringField(jparser, ListTablesResponseSerDe.CATALOG_NAME_FIELD);
            String nextToken = null;
            if (!JsonToken.END_OBJECT.equals((Object)jparser.nextToken()) && jparser.getCurrentName().equals(ListTablesResponseSerDe.NEXT_TOKEN_FIELD)) {
                jparser.nextToken();
                nextToken = jparser.getValueAsString();
            }
            return new ListTablesResponse(catalogName, (Collection<TableName>)tablesList.build(), nextToken);
        }
    }

    public static final class Serializer
    extends TypedSerializer<FederationResponse> {
        private final TableNameSerDe.Serializer tableNameSerializer;

        public Serializer(TableNameSerDe.Serializer tableNameSerializer) {
            super(FederationResponse.class, ListTablesResponse.class);
            this.tableNameSerializer = Objects.requireNonNull(tableNameSerializer, "tableNameSerializer is null");
        }

        @Override
        protected void doTypedSerialize(FederationResponse federationResponse, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            ListTablesResponse listTablesResponse = (ListTablesResponse)federationResponse;
            jgen.writeArrayFieldStart(ListTablesResponseSerDe.TABLES_FIELD);
            for (TableName tableName : listTablesResponse.getTables()) {
                this.tableNameSerializer.serialize(tableName, jgen, provider);
            }
            jgen.writeEndArray();
            jgen.writeStringField(ListTablesResponseSerDe.CATALOG_NAME_FIELD, listTablesResponse.getCatalogName());
            jgen.writeStringField(ListTablesResponseSerDe.NEXT_TOKEN_FIELD, listTablesResponse.getNextToken());
        }
    }
}

