/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v2;

import com.amazonaws.athena.connector.lambda.metadata.MetadataRequest;
import com.amazonaws.athena.connector.lambda.request.FederationRequest;
import com.amazonaws.athena.connector.lambda.serde.FederatedIdentitySerDe;
import com.amazonaws.athena.connector.lambda.serde.TypedSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Objects;

public abstract class MetadataRequestSerializer
extends TypedSerializer<FederationRequest> {
    static final String IDENTITY_FIELD = "identity";
    static final String QUERY_ID_FIELD = "queryId";
    static final String CATALOG_NAME_FIELD = "catalogName";
    private final FederatedIdentitySerDe.Serializer identitySerializer;

    protected MetadataRequestSerializer(Class<? extends FederationRequest> subType, FederatedIdentitySerDe.Serializer identitySerializer) {
        super(FederationRequest.class, subType);
        this.identitySerializer = Objects.requireNonNull(identitySerializer, "identitySerializer is null");
    }

    @Override
    protected void doTypedSerialize(FederationRequest federationRequest, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        MetadataRequest metadataRequest = (MetadataRequest)federationRequest;
        jgen.writeFieldName(IDENTITY_FIELD);
        this.identitySerializer.serialize(metadataRequest.getIdentity(), jgen, provider);
        jgen.writeStringField(QUERY_ID_FIELD, metadataRequest.getQueryId());
        jgen.writeStringField(CATALOG_NAME_FIELD, metadataRequest.getCatalogName());
        this.doRequestSerialize(metadataRequest, jgen, provider);
    }

    protected abstract void doRequestSerialize(FederationRequest var1, JsonGenerator var2, SerializerProvider var3) throws IOException;
}

