/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v2;

import com.amazonaws.athena.connector.lambda.data.Block;
import com.amazonaws.athena.connector.lambda.records.ReadRecordsResponse;
import com.amazonaws.athena.connector.lambda.request.FederationResponse;
import com.amazonaws.athena.connector.lambda.serde.TypedDeserializer;
import com.amazonaws.athena.connector.lambda.serde.TypedSerializer;
import com.amazonaws.athena.connector.lambda.serde.VersionedSerDe;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Objects;

public final class ReadRecordsResponseSerDe {
    private static final String CATALOG_NAME_FIELD = "catalogName";
    private static final String RECORDS_FIELD = "records";

    private ReadRecordsResponseSerDe() {
    }

    public static final class Deserializer
    extends TypedDeserializer<FederationResponse> {
        private final VersionedSerDe.Deserializer<Block> blockDeserializer;

        public Deserializer(VersionedSerDe.Deserializer<Block> blockDeserializer) {
            super(FederationResponse.class, ReadRecordsResponse.class);
            this.blockDeserializer = Objects.requireNonNull(blockDeserializer, "blockDeserializer is null");
        }

        @Override
        protected FederationResponse doTypedDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
            String catalogName = this.getNextStringField(jparser, ReadRecordsResponseSerDe.CATALOG_NAME_FIELD);
            this.assertFieldName(jparser, ReadRecordsResponseSerDe.RECORDS_FIELD);
            Block records = this.blockDeserializer.deserialize(jparser, ctxt);
            return new ReadRecordsResponse(catalogName, records);
        }
    }

    public static final class Serializer
    extends TypedSerializer<FederationResponse> {
        private final VersionedSerDe.Serializer<Block> blockSerializer;

        public Serializer(VersionedSerDe.Serializer<Block> blockSerializer) {
            super(FederationResponse.class, ReadRecordsResponse.class);
            this.blockSerializer = Objects.requireNonNull(blockSerializer, "blockSerializer is null");
        }

        @Override
        protected void doTypedSerialize(FederationResponse federationResponse, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            ReadRecordsResponse readRecordsResponse = (ReadRecordsResponse)federationResponse;
            jgen.writeStringField(ReadRecordsResponseSerDe.CATALOG_NAME_FIELD, readRecordsResponse.getCatalogName());
            jgen.writeFieldName(ReadRecordsResponseSerDe.RECORDS_FIELD);
            this.blockSerializer.serialize(readRecordsResponse.getRecords(), jgen, provider);
        }
    }
}

