/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v2;

import com.amazonaws.athena.connector.lambda.domain.spill.SpillLocation;
import com.amazonaws.athena.connector.lambda.records.RemoteReadRecordsResponse;
import com.amazonaws.athena.connector.lambda.request.FederationResponse;
import com.amazonaws.athena.connector.lambda.security.EncryptionKey;
import com.amazonaws.athena.connector.lambda.serde.TypedDeserializer;
import com.amazonaws.athena.connector.lambda.serde.TypedSerializer;
import com.amazonaws.athena.connector.lambda.serde.VersionedSerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.EncryptionKeySerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.SpillLocationSerDe;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.arrow.vector.types.pojo.Schema;

public final class RemoteReadRecordsResponseSerDe {
    private static final String CATALOG_NAME_FIELD = "catalogName";
    private static final String SCHEMA_FIELD = "schema";
    private static final String REMOTE_BLOCKS_FIELD = "remoteBlocks";
    private static final String ENCRYPTION_KEY_FIELD = "encryptionKey";

    private RemoteReadRecordsResponseSerDe() {
    }

    public static final class Deserializer
    extends TypedDeserializer<FederationResponse> {
        private final VersionedSerDe.Deserializer<Schema> schemaDeserializer;
        private final SpillLocationSerDe.Deserializer spillLocationDeserializer;
        private final EncryptionKeySerDe.Deserializer encryptionKeyDeserializer;

        public Deserializer(VersionedSerDe.Deserializer<Schema> schemaDeserializer, SpillLocationSerDe.Deserializer spillLocationDeserializer, EncryptionKeySerDe.Deserializer encryptionKeyDeserializer) {
            super(FederationResponse.class, RemoteReadRecordsResponse.class);
            this.schemaDeserializer = Objects.requireNonNull(schemaDeserializer, "schemaDeserializer is null");
            this.spillLocationDeserializer = Objects.requireNonNull(spillLocationDeserializer, "spillLocationDeserializer is null");
            this.encryptionKeyDeserializer = Objects.requireNonNull(encryptionKeyDeserializer, "encryptionKeyDeserializer is null");
        }

        @Override
        protected FederationResponse doTypedDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
            String catalogName = this.getNextStringField(jparser, RemoteReadRecordsResponseSerDe.CATALOG_NAME_FIELD);
            this.assertFieldName(jparser, RemoteReadRecordsResponseSerDe.SCHEMA_FIELD);
            Schema schema = this.schemaDeserializer.deserialize(jparser, ctxt);
            this.assertFieldName(jparser, RemoteReadRecordsResponseSerDe.REMOTE_BLOCKS_FIELD);
            this.validateArrayStart(jparser);
            ImmutableList.Builder remoteBlocksList = ImmutableList.builder();
            while (jparser.nextToken() != JsonToken.END_ARRAY) {
                this.validateObjectStart(jparser.getCurrentToken());
                remoteBlocksList.add((Object)((SpillLocation)this.spillLocationDeserializer.doDeserialize(jparser, ctxt)));
                this.validateObjectEnd(jparser);
            }
            this.assertFieldName(jparser, RemoteReadRecordsResponseSerDe.ENCRYPTION_KEY_FIELD);
            EncryptionKey encryptionKey = (EncryptionKey)this.encryptionKeyDeserializer.deserialize(jparser, ctxt);
            return new RemoteReadRecordsResponse(catalogName, schema, (List<SpillLocation>)remoteBlocksList.build(), encryptionKey);
        }
    }

    public static final class Serializer
    extends TypedSerializer<FederationResponse> {
        private final VersionedSerDe.Serializer<Schema> schemaSerializer;
        private final SpillLocationSerDe.Serializer spillLocationSerializer;
        private final EncryptionKeySerDe.Serializer encryptionKeySerializer;

        public Serializer(VersionedSerDe.Serializer<Schema> schemaSerializer, SpillLocationSerDe.Serializer spillLocationSerializer, EncryptionKeySerDe.Serializer encryptionKeySerializer) {
            super(FederationResponse.class, RemoteReadRecordsResponse.class);
            this.schemaSerializer = Objects.requireNonNull(schemaSerializer, "schemaSerializer is null");
            this.spillLocationSerializer = Objects.requireNonNull(spillLocationSerializer, "spillLocationSerializer is null");
            this.encryptionKeySerializer = Objects.requireNonNull(encryptionKeySerializer, "encryptionKeySerializer is null");
        }

        @Override
        protected void doTypedSerialize(FederationResponse federationResponse, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            RemoteReadRecordsResponse remoteReadRecordsResponse = (RemoteReadRecordsResponse)federationResponse;
            jgen.writeStringField(RemoteReadRecordsResponseSerDe.CATALOG_NAME_FIELD, remoteReadRecordsResponse.getCatalogName());
            jgen.writeFieldName(RemoteReadRecordsResponseSerDe.SCHEMA_FIELD);
            this.schemaSerializer.serialize(remoteReadRecordsResponse.getSchema(), jgen, provider);
            jgen.writeArrayFieldStart(RemoteReadRecordsResponseSerDe.REMOTE_BLOCKS_FIELD);
            for (SpillLocation spillLocation : remoteReadRecordsResponse.getRemoteBlocks()) {
                this.spillLocationSerializer.serialize(spillLocation, jgen, provider);
            }
            jgen.writeEndArray();
            jgen.writeFieldName(RemoteReadRecordsResponseSerDe.ENCRYPTION_KEY_FIELD);
            this.encryptionKeySerializer.serialize(remoteReadRecordsResponse.getEncryptionKey(), jgen, provider);
        }
    }
}

