/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v4;

import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.serde.BaseDeserializer;
import com.amazonaws.athena.connector.lambda.serde.BaseSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.ipc.ReadChannel;
import org.apache.arrow.vector.ipc.WriteChannel;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.ipc.message.MessageSerializer;

public final class ArrowRecordBatchSerDeV4 {
    private ArrowRecordBatchSerDeV4() {
    }

    static final class Deserializer
    extends BaseDeserializer<ArrowRecordBatch> {
        private final BlockAllocator blockAllocator;

        Deserializer(BlockAllocator allocator) {
            super(ArrowRecordBatch.class);
            this.blockAllocator = Objects.requireNonNull(allocator, "allocator is null");
        }

        @Override
        public ArrowRecordBatch doDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
            if (jparser.nextToken() != JsonToken.VALUE_EMBEDDED_OBJECT) {
                throw new IllegalStateException("Expecting " + JsonToken.VALUE_STRING + " but found " + jparser.getCurrentLocation());
            }
            byte[] bytes = jparser.getBinaryValue();
            AtomicReference batch = new AtomicReference();
            try {
                return this.blockAllocator.registerBatch(root -> {
                    batch.set((ArrowRecordBatch)MessageSerializer.deserializeMessageBatch((ReadChannel)new ReadChannel(Channels.newChannel(new ByteArrayInputStream(bytes))), (BufferAllocator)root));
                    return (ArrowRecordBatch)batch.get();
                });
            }
            catch (Exception ex) {
                if (batch.get() != null) {
                    ((ArrowRecordBatch)batch.get()).close();
                }
                throw ex;
            }
        }
    }

    static final class Serializer
    extends BaseSerializer<ArrowRecordBatch> {
        Serializer() {
            super(ArrowRecordBatch.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doSerialize(ArrowRecordBatch arrowRecordBatch, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                MessageSerializer.serialize((WriteChannel)new WriteChannel(Channels.newChannel(out)), (ArrowRecordBatch)arrowRecordBatch);
                jgen.writeBinary(out.toByteArray());
            }
            finally {
                arrowRecordBatch.close();
            }
        }
    }
}

