/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class PaginatedRequestIterator<T>
implements Iterator<T> {
    final Function<String, T> fetchPage;
    final Function<T, String> getToken;
    boolean notStarted = true;
    String nextPageToken = null;

    public static <X> Stream<X> stream(Function<String, X> fetchPage, Function<X, String> getToken) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new PaginatedRequestIterator<X>(fetchPage, getToken), 1040), false);
    }

    public PaginatedRequestIterator(Function<String, T> fetchPage, Function<T, String> getToken) {
        this.fetchPage = fetchPage;
        this.getToken = getToken;
    }

    @Override
    public boolean hasNext() {
        return this.notStarted || this.nextPageToken != null;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more pages left");
        }
        T current = this.fetchPage.apply(this.nextPageToken);
        this.notStarted = false;
        this.nextPageToken = this.getToken.apply(current);
        return current;
    }
}

