/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.amplify.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * <p>
 * Request structure for start a deployment.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/StartDeployment" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class StartDeploymentRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * Unique Id for an Amplify App.
     * </p>
     */
    private String appId;
    /**
     * <p>
     * Name for the branch, for the Job.
     * </p>
     */
    private String branchName;
    /**
     * <p>
     * The job id for this deployment, generated by create deployment request.
     * </p>
     */
    private String jobId;
    /**
     * <p>
     * The sourceUrl for this deployment, used when calling start deployment without create deployment. SourceUrl can be
     * any HTTP GET url that is public accessible and downloads a single zip.
     * </p>
     */
    private String sourceUrl;

    /**
     * <p>
     * Unique Id for an Amplify App.
     * </p>
     * 
     * @param appId
     *        Unique Id for an Amplify App.
     */

    public void setAppId(String appId) {
        this.appId = appId;
    }

    /**
     * <p>
     * Unique Id for an Amplify App.
     * </p>
     * 
     * @return Unique Id for an Amplify App.
     */

    public String getAppId() {
        return this.appId;
    }

    /**
     * <p>
     * Unique Id for an Amplify App.
     * </p>
     * 
     * @param appId
     *        Unique Id for an Amplify App.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartDeploymentRequest withAppId(String appId) {
        setAppId(appId);
        return this;
    }

    /**
     * <p>
     * Name for the branch, for the Job.
     * </p>
     * 
     * @param branchName
     *        Name for the branch, for the Job.
     */

    public void setBranchName(String branchName) {
        this.branchName = branchName;
    }

    /**
     * <p>
     * Name for the branch, for the Job.
     * </p>
     * 
     * @return Name for the branch, for the Job.
     */

    public String getBranchName() {
        return this.branchName;
    }

    /**
     * <p>
     * Name for the branch, for the Job.
     * </p>
     * 
     * @param branchName
     *        Name for the branch, for the Job.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartDeploymentRequest withBranchName(String branchName) {
        setBranchName(branchName);
        return this;
    }

    /**
     * <p>
     * The job id for this deployment, generated by create deployment request.
     * </p>
     * 
     * @param jobId
     *        The job id for this deployment, generated by create deployment request.
     */

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    /**
     * <p>
     * The job id for this deployment, generated by create deployment request.
     * </p>
     * 
     * @return The job id for this deployment, generated by create deployment request.
     */

    public String getJobId() {
        return this.jobId;
    }

    /**
     * <p>
     * The job id for this deployment, generated by create deployment request.
     * </p>
     * 
     * @param jobId
     *        The job id for this deployment, generated by create deployment request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartDeploymentRequest withJobId(String jobId) {
        setJobId(jobId);
        return this;
    }

    /**
     * <p>
     * The sourceUrl for this deployment, used when calling start deployment without create deployment. SourceUrl can be
     * any HTTP GET url that is public accessible and downloads a single zip.
     * </p>
     * 
     * @param sourceUrl
     *        The sourceUrl for this deployment, used when calling start deployment without create deployment. SourceUrl
     *        can be any HTTP GET url that is public accessible and downloads a single zip.
     */

    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    /**
     * <p>
     * The sourceUrl for this deployment, used when calling start deployment without create deployment. SourceUrl can be
     * any HTTP GET url that is public accessible and downloads a single zip.
     * </p>
     * 
     * @return The sourceUrl for this deployment, used when calling start deployment without create deployment.
     *         SourceUrl can be any HTTP GET url that is public accessible and downloads a single zip.
     */

    public String getSourceUrl() {
        return this.sourceUrl;
    }

    /**
     * <p>
     * The sourceUrl for this deployment, used when calling start deployment without create deployment. SourceUrl can be
     * any HTTP GET url that is public accessible and downloads a single zip.
     * </p>
     * 
     * @param sourceUrl
     *        The sourceUrl for this deployment, used when calling start deployment without create deployment. SourceUrl
     *        can be any HTTP GET url that is public accessible and downloads a single zip.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartDeploymentRequest withSourceUrl(String sourceUrl) {
        setSourceUrl(sourceUrl);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAppId() != null)
            sb.append("AppId: ").append(getAppId()).append(",");
        if (getBranchName() != null)
            sb.append("BranchName: ").append(getBranchName()).append(",");
        if (getJobId() != null)
            sb.append("JobId: ").append(getJobId()).append(",");
        if (getSourceUrl() != null)
            sb.append("SourceUrl: ").append(getSourceUrl());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof StartDeploymentRequest == false)
            return false;
        StartDeploymentRequest other = (StartDeploymentRequest) obj;
        if (other.getAppId() == null ^ this.getAppId() == null)
            return false;
        if (other.getAppId() != null && other.getAppId().equals(this.getAppId()) == false)
            return false;
        if (other.getBranchName() == null ^ this.getBranchName() == null)
            return false;
        if (other.getBranchName() != null && other.getBranchName().equals(this.getBranchName()) == false)
            return false;
        if (other.getJobId() == null ^ this.getJobId() == null)
            return false;
        if (other.getJobId() != null && other.getJobId().equals(this.getJobId()) == false)
            return false;
        if (other.getSourceUrl() == null ^ this.getSourceUrl() == null)
            return false;
        if (other.getSourceUrl() != null && other.getSourceUrl().equals(this.getSourceUrl()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAppId() == null) ? 0 : getAppId().hashCode());
        hashCode = prime * hashCode + ((getBranchName() == null) ? 0 : getBranchName().hashCode());
        hashCode = prime * hashCode + ((getJobId() == null) ? 0 : getJobId().hashCode());
        hashCode = prime * hashCode + ((getSourceUrl() == null) ? 0 : getSourceUrl().hashCode());
        return hashCode;
    }

    @Override
    public StartDeploymentRequest clone() {
        return (StartDeploymentRequest) super.clone();
    }

}
