/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigatewayv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.apigatewayv2.model.DomainNameConfiguration;
import com.amazonaws.services.apigatewayv2.model.transform.DomainNameMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DomainName
implements Serializable,
Cloneable,
StructuredPojo {
    private String apiMappingSelectionExpression;
    private String domainName;
    private List<DomainNameConfiguration> domainNameConfigurations;
    private Map<String, String> tags;

    public void setApiMappingSelectionExpression(String apiMappingSelectionExpression) {
        this.apiMappingSelectionExpression = apiMappingSelectionExpression;
    }

    public String getApiMappingSelectionExpression() {
        return this.apiMappingSelectionExpression;
    }

    public DomainName withApiMappingSelectionExpression(String apiMappingSelectionExpression) {
        this.setApiMappingSelectionExpression(apiMappingSelectionExpression);
        return this;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public DomainName withDomainName(String domainName) {
        this.setDomainName(domainName);
        return this;
    }

    public List<DomainNameConfiguration> getDomainNameConfigurations() {
        return this.domainNameConfigurations;
    }

    public void setDomainNameConfigurations(Collection<DomainNameConfiguration> domainNameConfigurations) {
        if (domainNameConfigurations == null) {
            this.domainNameConfigurations = null;
            return;
        }
        this.domainNameConfigurations = new ArrayList<DomainNameConfiguration>(domainNameConfigurations);
    }

    public DomainName withDomainNameConfigurations(DomainNameConfiguration ... domainNameConfigurations) {
        if (this.domainNameConfigurations == null) {
            this.setDomainNameConfigurations(new ArrayList<DomainNameConfiguration>(domainNameConfigurations.length));
        }
        for (DomainNameConfiguration ele : domainNameConfigurations) {
            this.domainNameConfigurations.add(ele);
        }
        return this;
    }

    public DomainName withDomainNameConfigurations(Collection<DomainNameConfiguration> domainNameConfigurations) {
        this.setDomainNameConfigurations(domainNameConfigurations);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public DomainName withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public DomainName addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public DomainName clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApiMappingSelectionExpression() != null) {
            sb.append("ApiMappingSelectionExpression: ").append(this.getApiMappingSelectionExpression()).append(",");
        }
        if (this.getDomainName() != null) {
            sb.append("DomainName: ").append(this.getDomainName()).append(",");
        }
        if (this.getDomainNameConfigurations() != null) {
            sb.append("DomainNameConfigurations: ").append(this.getDomainNameConfigurations()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainName)) {
            return false;
        }
        DomainName other = (DomainName)obj;
        if (other.getApiMappingSelectionExpression() == null ^ this.getApiMappingSelectionExpression() == null) {
            return false;
        }
        if (other.getApiMappingSelectionExpression() != null && !other.getApiMappingSelectionExpression().equals(this.getApiMappingSelectionExpression())) {
            return false;
        }
        if (other.getDomainName() == null ^ this.getDomainName() == null) {
            return false;
        }
        if (other.getDomainName() != null && !other.getDomainName().equals(this.getDomainName())) {
            return false;
        }
        if (other.getDomainNameConfigurations() == null ^ this.getDomainNameConfigurations() == null) {
            return false;
        }
        if (other.getDomainNameConfigurations() != null && !other.getDomainNameConfigurations().equals(this.getDomainNameConfigurations())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApiMappingSelectionExpression() == null ? 0 : this.getApiMappingSelectionExpression().hashCode());
        hashCode = 31 * hashCode + (this.getDomainName() == null ? 0 : this.getDomainName().hashCode());
        hashCode = 31 * hashCode + (this.getDomainNameConfigurations() == null ? 0 : this.getDomainNameConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public DomainName clone() {
        try {
            return (DomainName)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DomainNameMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

