/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigatewayv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.apigatewayv2.model.AccessLogSettings;
import com.amazonaws.services.apigatewayv2.model.RouteSettings;
import com.amazonaws.services.apigatewayv2.model.transform.StageMarshaller;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Stage
implements Serializable,
Cloneable,
StructuredPojo {
    private AccessLogSettings accessLogSettings;
    private String clientCertificateId;
    private Date createdDate;
    private RouteSettings defaultRouteSettings;
    private String deploymentId;
    private String description;
    private Date lastUpdatedDate;
    private Map<String, RouteSettings> routeSettings;
    private String stageName;
    private Map<String, String> stageVariables;
    private Map<String, String> tags;

    public void setAccessLogSettings(AccessLogSettings accessLogSettings) {
        this.accessLogSettings = accessLogSettings;
    }

    public AccessLogSettings getAccessLogSettings() {
        return this.accessLogSettings;
    }

    public Stage withAccessLogSettings(AccessLogSettings accessLogSettings) {
        this.setAccessLogSettings(accessLogSettings);
        return this;
    }

    public void setClientCertificateId(String clientCertificateId) {
        this.clientCertificateId = clientCertificateId;
    }

    public String getClientCertificateId() {
        return this.clientCertificateId;
    }

    public Stage withClientCertificateId(String clientCertificateId) {
        this.setClientCertificateId(clientCertificateId);
        return this;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public Stage withCreatedDate(Date createdDate) {
        this.setCreatedDate(createdDate);
        return this;
    }

    public void setDefaultRouteSettings(RouteSettings defaultRouteSettings) {
        this.defaultRouteSettings = defaultRouteSettings;
    }

    public RouteSettings getDefaultRouteSettings() {
        return this.defaultRouteSettings;
    }

    public Stage withDefaultRouteSettings(RouteSettings defaultRouteSettings) {
        this.setDefaultRouteSettings(defaultRouteSettings);
        return this;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public Stage withDeploymentId(String deploymentId) {
        this.setDeploymentId(deploymentId);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Stage withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setLastUpdatedDate(Date lastUpdatedDate) {
        this.lastUpdatedDate = lastUpdatedDate;
    }

    public Date getLastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public Stage withLastUpdatedDate(Date lastUpdatedDate) {
        this.setLastUpdatedDate(lastUpdatedDate);
        return this;
    }

    public Map<String, RouteSettings> getRouteSettings() {
        return this.routeSettings;
    }

    public void setRouteSettings(Map<String, RouteSettings> routeSettings) {
        this.routeSettings = routeSettings;
    }

    public Stage withRouteSettings(Map<String, RouteSettings> routeSettings) {
        this.setRouteSettings(routeSettings);
        return this;
    }

    public Stage addRouteSettingsEntry(String key, RouteSettings value) {
        if (null == this.routeSettings) {
            this.routeSettings = new HashMap<String, RouteSettings>();
        }
        if (this.routeSettings.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.routeSettings.put(key, value);
        return this;
    }

    public Stage clearRouteSettingsEntries() {
        this.routeSettings = null;
        return this;
    }

    public void setStageName(String stageName) {
        this.stageName = stageName;
    }

    public String getStageName() {
        return this.stageName;
    }

    public Stage withStageName(String stageName) {
        this.setStageName(stageName);
        return this;
    }

    public Map<String, String> getStageVariables() {
        return this.stageVariables;
    }

    public void setStageVariables(Map<String, String> stageVariables) {
        this.stageVariables = stageVariables;
    }

    public Stage withStageVariables(Map<String, String> stageVariables) {
        this.setStageVariables(stageVariables);
        return this;
    }

    public Stage addStageVariablesEntry(String key, String value) {
        if (null == this.stageVariables) {
            this.stageVariables = new HashMap<String, String>();
        }
        if (this.stageVariables.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.stageVariables.put(key, value);
        return this;
    }

    public Stage clearStageVariablesEntries() {
        this.stageVariables = null;
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public Stage withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public Stage addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public Stage clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccessLogSettings() != null) {
            sb.append("AccessLogSettings: ").append(this.getAccessLogSettings()).append(",");
        }
        if (this.getClientCertificateId() != null) {
            sb.append("ClientCertificateId: ").append(this.getClientCertificateId()).append(",");
        }
        if (this.getCreatedDate() != null) {
            sb.append("CreatedDate: ").append(this.getCreatedDate()).append(",");
        }
        if (this.getDefaultRouteSettings() != null) {
            sb.append("DefaultRouteSettings: ").append(this.getDefaultRouteSettings()).append(",");
        }
        if (this.getDeploymentId() != null) {
            sb.append("DeploymentId: ").append(this.getDeploymentId()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getLastUpdatedDate() != null) {
            sb.append("LastUpdatedDate: ").append(this.getLastUpdatedDate()).append(",");
        }
        if (this.getRouteSettings() != null) {
            sb.append("RouteSettings: ").append(this.getRouteSettings()).append(",");
        }
        if (this.getStageName() != null) {
            sb.append("StageName: ").append(this.getStageName()).append(",");
        }
        if (this.getStageVariables() != null) {
            sb.append("StageVariables: ").append(this.getStageVariables()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Stage)) {
            return false;
        }
        Stage other = (Stage)obj;
        if (other.getAccessLogSettings() == null ^ this.getAccessLogSettings() == null) {
            return false;
        }
        if (other.getAccessLogSettings() != null && !other.getAccessLogSettings().equals(this.getAccessLogSettings())) {
            return false;
        }
        if (other.getClientCertificateId() == null ^ this.getClientCertificateId() == null) {
            return false;
        }
        if (other.getClientCertificateId() != null && !other.getClientCertificateId().equals(this.getClientCertificateId())) {
            return false;
        }
        if (other.getCreatedDate() == null ^ this.getCreatedDate() == null) {
            return false;
        }
        if (other.getCreatedDate() != null && !other.getCreatedDate().equals(this.getCreatedDate())) {
            return false;
        }
        if (other.getDefaultRouteSettings() == null ^ this.getDefaultRouteSettings() == null) {
            return false;
        }
        if (other.getDefaultRouteSettings() != null && !other.getDefaultRouteSettings().equals(this.getDefaultRouteSettings())) {
            return false;
        }
        if (other.getDeploymentId() == null ^ this.getDeploymentId() == null) {
            return false;
        }
        if (other.getDeploymentId() != null && !other.getDeploymentId().equals(this.getDeploymentId())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getLastUpdatedDate() == null ^ this.getLastUpdatedDate() == null) {
            return false;
        }
        if (other.getLastUpdatedDate() != null && !other.getLastUpdatedDate().equals(this.getLastUpdatedDate())) {
            return false;
        }
        if (other.getRouteSettings() == null ^ this.getRouteSettings() == null) {
            return false;
        }
        if (other.getRouteSettings() != null && !other.getRouteSettings().equals(this.getRouteSettings())) {
            return false;
        }
        if (other.getStageName() == null ^ this.getStageName() == null) {
            return false;
        }
        if (other.getStageName() != null && !other.getStageName().equals(this.getStageName())) {
            return false;
        }
        if (other.getStageVariables() == null ^ this.getStageVariables() == null) {
            return false;
        }
        if (other.getStageVariables() != null && !other.getStageVariables().equals(this.getStageVariables())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccessLogSettings() == null ? 0 : this.getAccessLogSettings().hashCode());
        hashCode = 31 * hashCode + (this.getClientCertificateId() == null ? 0 : this.getClientCertificateId().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedDate() == null ? 0 : this.getCreatedDate().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultRouteSettings() == null ? 0 : this.getDefaultRouteSettings().hashCode());
        hashCode = 31 * hashCode + (this.getDeploymentId() == null ? 0 : this.getDeploymentId().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdatedDate() == null ? 0 : this.getLastUpdatedDate().hashCode());
        hashCode = 31 * hashCode + (this.getRouteSettings() == null ? 0 : this.getRouteSettings().hashCode());
        hashCode = 31 * hashCode + (this.getStageName() == null ? 0 : this.getStageName().hashCode());
        hashCode = 31 * hashCode + (this.getStageVariables() == null ? 0 : this.getStageVariables().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public Stage clone() {
        try {
            return (Stage)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

