/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.appfabric.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/DeleteIngestionDestination"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DeleteIngestionDestinationRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the request.
     * </p>
     */
    private String appBundleIdentifier;
    /**
     * <p>
     * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the ingestion to use for the request.
     * </p>
     */
    private String ingestionIdentifier;
    /**
     * <p>
     * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the ingestion destination to use for the
     * request.
     * </p>
     */
    private String ingestionDestinationIdentifier;

    /**
     * <p>
     * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the request.
     * </p>
     * 
     * @param appBundleIdentifier
     *        The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the
     *        request.
     */

    public void setAppBundleIdentifier(String appBundleIdentifier) {
        this.appBundleIdentifier = appBundleIdentifier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the request.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the
     *         request.
     */

    public String getAppBundleIdentifier() {
        return this.appBundleIdentifier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the request.
     * </p>
     * 
     * @param appBundleIdentifier
     *        The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the
     *        request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DeleteIngestionDestinationRequest withAppBundleIdentifier(String appBundleIdentifier) {
        setAppBundleIdentifier(appBundleIdentifier);
        return this;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the ingestion to use for the request.
     * </p>
     * 
     * @param ingestionIdentifier
     *        The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the ingestion to use for the
     *        request.
     */

    public void setIngestionIdentifier(String ingestionIdentifier) {
        this.ingestionIdentifier = ingestionIdentifier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the ingestion to use for the request.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the ingestion to use for the
     *         request.
     */

    public String getIngestionIdentifier() {
        return this.ingestionIdentifier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the ingestion to use for the request.
     * </p>
     * 
     * @param ingestionIdentifier
     *        The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the ingestion to use for the
     *        request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DeleteIngestionDestinationRequest withIngestionIdentifier(String ingestionIdentifier) {
        setIngestionIdentifier(ingestionIdentifier);
        return this;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the ingestion destination to use for the
     * request.
     * </p>
     * 
     * @param ingestionDestinationIdentifier
     *        The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the ingestion destination to use
     *        for the request.
     */

    public void setIngestionDestinationIdentifier(String ingestionDestinationIdentifier) {
        this.ingestionDestinationIdentifier = ingestionDestinationIdentifier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the ingestion destination to use for the
     * request.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the ingestion destination to use
     *         for the request.
     */

    public String getIngestionDestinationIdentifier() {
        return this.ingestionDestinationIdentifier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the ingestion destination to use for the
     * request.
     * </p>
     * 
     * @param ingestionDestinationIdentifier
     *        The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the ingestion destination to use
     *        for the request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DeleteIngestionDestinationRequest withIngestionDestinationIdentifier(String ingestionDestinationIdentifier) {
        setIngestionDestinationIdentifier(ingestionDestinationIdentifier);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAppBundleIdentifier() != null)
            sb.append("AppBundleIdentifier: ").append(getAppBundleIdentifier()).append(",");
        if (getIngestionIdentifier() != null)
            sb.append("IngestionIdentifier: ").append(getIngestionIdentifier()).append(",");
        if (getIngestionDestinationIdentifier() != null)
            sb.append("IngestionDestinationIdentifier: ").append(getIngestionDestinationIdentifier());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DeleteIngestionDestinationRequest == false)
            return false;
        DeleteIngestionDestinationRequest other = (DeleteIngestionDestinationRequest) obj;
        if (other.getAppBundleIdentifier() == null ^ this.getAppBundleIdentifier() == null)
            return false;
        if (other.getAppBundleIdentifier() != null && other.getAppBundleIdentifier().equals(this.getAppBundleIdentifier()) == false)
            return false;
        if (other.getIngestionIdentifier() == null ^ this.getIngestionIdentifier() == null)
            return false;
        if (other.getIngestionIdentifier() != null && other.getIngestionIdentifier().equals(this.getIngestionIdentifier()) == false)
            return false;
        if (other.getIngestionDestinationIdentifier() == null ^ this.getIngestionDestinationIdentifier() == null)
            return false;
        if (other.getIngestionDestinationIdentifier() != null
                && other.getIngestionDestinationIdentifier().equals(this.getIngestionDestinationIdentifier()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAppBundleIdentifier() == null) ? 0 : getAppBundleIdentifier().hashCode());
        hashCode = prime * hashCode + ((getIngestionIdentifier() == null) ? 0 : getIngestionIdentifier().hashCode());
        hashCode = prime * hashCode + ((getIngestionDestinationIdentifier() == null) ? 0 : getIngestionDestinationIdentifier().hashCode());
        return hashCode;
    }

    @Override
    public DeleteIngestionDestinationRequest clone() {
        return (DeleteIngestionDestinationRequest) super.clone();
    }

}
