/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.appflow.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The connector-specific profile properties required when using Salesforce.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/SalesforceConnectorProfileProperties"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class SalesforceConnectorProfileProperties implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The location of the Salesforce resource.
     * </p>
     */
    private String instanceUrl;
    /**
     * <p>
     * Indicates whether the connector profile applies to a sandbox or production environment.
     * </p>
     */
    private Boolean isSandboxEnvironment;
    /**
     * <p>
     * If the connection mode for the connector profile is private, this parameter sets whether Amazon AppFlow uses the
     * private network to send metadata and authorization calls to Salesforce. Amazon AppFlow sends private calls
     * through Amazon Web Services PrivateLink. These calls travel through Amazon Web Services infrastructure without
     * being exposed to the public internet.
     * </p>
     * <p>
     * Set either of the following values:
     * </p>
     * <dl>
     * <dt>true</dt>
     * <dd>
     * <p>
     * Amazon AppFlow sends all calls to Salesforce over the private network.
     * </p>
     * <p>
     * These private calls are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Calls to get metadata about your Salesforce records. This metadata describes your Salesforce objects and their
     * fields.
     * </p>
     * </li>
     * <li>
     * <p>
     * Calls to get or refresh access tokens that allow Amazon AppFlow to access your Salesforce records.
     * </p>
     * </li>
     * <li>
     * <p>
     * Calls to transfer your Salesforce records as part of a flow run.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>false</dt>
     * <dd>
     * <p>
     * The default value. Amazon AppFlow sends some calls to Salesforce privately and other calls over the public
     * internet.
     * </p>
     * <p>
     * The public calls are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Calls to get metadata about your Salesforce records.
     * </p>
     * </li>
     * <li>
     * <p>
     * Calls to get or refresh access tokens.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The private calls are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Calls to transfer your Salesforce records as part of a flow run.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * </dl>
     */
    private Boolean usePrivateLinkForMetadataAndAuthorization;

    /**
     * <p>
     * The location of the Salesforce resource.
     * </p>
     * 
     * @param instanceUrl
     *        The location of the Salesforce resource.
     */

    public void setInstanceUrl(String instanceUrl) {
        this.instanceUrl = instanceUrl;
    }

    /**
     * <p>
     * The location of the Salesforce resource.
     * </p>
     * 
     * @return The location of the Salesforce resource.
     */

    public String getInstanceUrl() {
        return this.instanceUrl;
    }

    /**
     * <p>
     * The location of the Salesforce resource.
     * </p>
     * 
     * @param instanceUrl
     *        The location of the Salesforce resource.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SalesforceConnectorProfileProperties withInstanceUrl(String instanceUrl) {
        setInstanceUrl(instanceUrl);
        return this;
    }

    /**
     * <p>
     * Indicates whether the connector profile applies to a sandbox or production environment.
     * </p>
     * 
     * @param isSandboxEnvironment
     *        Indicates whether the connector profile applies to a sandbox or production environment.
     */

    public void setIsSandboxEnvironment(Boolean isSandboxEnvironment) {
        this.isSandboxEnvironment = isSandboxEnvironment;
    }

    /**
     * <p>
     * Indicates whether the connector profile applies to a sandbox or production environment.
     * </p>
     * 
     * @return Indicates whether the connector profile applies to a sandbox or production environment.
     */

    public Boolean getIsSandboxEnvironment() {
        return this.isSandboxEnvironment;
    }

    /**
     * <p>
     * Indicates whether the connector profile applies to a sandbox or production environment.
     * </p>
     * 
     * @param isSandboxEnvironment
     *        Indicates whether the connector profile applies to a sandbox or production environment.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SalesforceConnectorProfileProperties withIsSandboxEnvironment(Boolean isSandboxEnvironment) {
        setIsSandboxEnvironment(isSandboxEnvironment);
        return this;
    }

    /**
     * <p>
     * Indicates whether the connector profile applies to a sandbox or production environment.
     * </p>
     * 
     * @return Indicates whether the connector profile applies to a sandbox or production environment.
     */

    public Boolean isSandboxEnvironment() {
        return this.isSandboxEnvironment;
    }

    /**
     * <p>
     * If the connection mode for the connector profile is private, this parameter sets whether Amazon AppFlow uses the
     * private network to send metadata and authorization calls to Salesforce. Amazon AppFlow sends private calls
     * through Amazon Web Services PrivateLink. These calls travel through Amazon Web Services infrastructure without
     * being exposed to the public internet.
     * </p>
     * <p>
     * Set either of the following values:
     * </p>
     * <dl>
     * <dt>true</dt>
     * <dd>
     * <p>
     * Amazon AppFlow sends all calls to Salesforce over the private network.
     * </p>
     * <p>
     * These private calls are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Calls to get metadata about your Salesforce records. This metadata describes your Salesforce objects and their
     * fields.
     * </p>
     * </li>
     * <li>
     * <p>
     * Calls to get or refresh access tokens that allow Amazon AppFlow to access your Salesforce records.
     * </p>
     * </li>
     * <li>
     * <p>
     * Calls to transfer your Salesforce records as part of a flow run.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>false</dt>
     * <dd>
     * <p>
     * The default value. Amazon AppFlow sends some calls to Salesforce privately and other calls over the public
     * internet.
     * </p>
     * <p>
     * The public calls are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Calls to get metadata about your Salesforce records.
     * </p>
     * </li>
     * <li>
     * <p>
     * Calls to get or refresh access tokens.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The private calls are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Calls to transfer your Salesforce records as part of a flow run.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * </dl>
     * 
     * @param usePrivateLinkForMetadataAndAuthorization
     *        If the connection mode for the connector profile is private, this parameter sets whether Amazon AppFlow
     *        uses the private network to send metadata and authorization calls to Salesforce. Amazon AppFlow sends
     *        private calls through Amazon Web Services PrivateLink. These calls travel through Amazon Web Services
     *        infrastructure without being exposed to the public internet.</p>
     *        <p>
     *        Set either of the following values:
     *        </p>
     *        <dl>
     *        <dt>true</dt>
     *        <dd>
     *        <p>
     *        Amazon AppFlow sends all calls to Salesforce over the private network.
     *        </p>
     *        <p>
     *        These private calls are:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        Calls to get metadata about your Salesforce records. This metadata describes your Salesforce objects and
     *        their fields.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Calls to get or refresh access tokens that allow Amazon AppFlow to access your Salesforce records.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Calls to transfer your Salesforce records as part of a flow run.
     *        </p>
     *        </li>
     *        </ul>
     *        </dd>
     *        <dt>false</dt>
     *        <dd>
     *        <p>
     *        The default value. Amazon AppFlow sends some calls to Salesforce privately and other calls over the public
     *        internet.
     *        </p>
     *        <p>
     *        The public calls are:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        Calls to get metadata about your Salesforce records.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Calls to get or refresh access tokens.
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        The private calls are:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        Calls to transfer your Salesforce records as part of a flow run.
     *        </p>
     *        </li>
     *        </ul>
     *        </dd>
     */

    public void setUsePrivateLinkForMetadataAndAuthorization(Boolean usePrivateLinkForMetadataAndAuthorization) {
        this.usePrivateLinkForMetadataAndAuthorization = usePrivateLinkForMetadataAndAuthorization;
    }

    /**
     * <p>
     * If the connection mode for the connector profile is private, this parameter sets whether Amazon AppFlow uses the
     * private network to send metadata and authorization calls to Salesforce. Amazon AppFlow sends private calls
     * through Amazon Web Services PrivateLink. These calls travel through Amazon Web Services infrastructure without
     * being exposed to the public internet.
     * </p>
     * <p>
     * Set either of the following values:
     * </p>
     * <dl>
     * <dt>true</dt>
     * <dd>
     * <p>
     * Amazon AppFlow sends all calls to Salesforce over the private network.
     * </p>
     * <p>
     * These private calls are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Calls to get metadata about your Salesforce records. This metadata describes your Salesforce objects and their
     * fields.
     * </p>
     * </li>
     * <li>
     * <p>
     * Calls to get or refresh access tokens that allow Amazon AppFlow to access your Salesforce records.
     * </p>
     * </li>
     * <li>
     * <p>
     * Calls to transfer your Salesforce records as part of a flow run.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>false</dt>
     * <dd>
     * <p>
     * The default value. Amazon AppFlow sends some calls to Salesforce privately and other calls over the public
     * internet.
     * </p>
     * <p>
     * The public calls are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Calls to get metadata about your Salesforce records.
     * </p>
     * </li>
     * <li>
     * <p>
     * Calls to get or refresh access tokens.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The private calls are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Calls to transfer your Salesforce records as part of a flow run.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * </dl>
     * 
     * @return If the connection mode for the connector profile is private, this parameter sets whether Amazon AppFlow
     *         uses the private network to send metadata and authorization calls to Salesforce. Amazon AppFlow sends
     *         private calls through Amazon Web Services PrivateLink. These calls travel through Amazon Web Services
     *         infrastructure without being exposed to the public internet.</p>
     *         <p>
     *         Set either of the following values:
     *         </p>
     *         <dl>
     *         <dt>true</dt>
     *         <dd>
     *         <p>
     *         Amazon AppFlow sends all calls to Salesforce over the private network.
     *         </p>
     *         <p>
     *         These private calls are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Calls to get metadata about your Salesforce records. This metadata describes your Salesforce objects and
     *         their fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Calls to get or refresh access tokens that allow Amazon AppFlow to access your Salesforce records.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Calls to transfer your Salesforce records as part of a flow run.
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>false</dt>
     *         <dd>
     *         <p>
     *         The default value. Amazon AppFlow sends some calls to Salesforce privately and other calls over the
     *         public internet.
     *         </p>
     *         <p>
     *         The public calls are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Calls to get metadata about your Salesforce records.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Calls to get or refresh access tokens.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The private calls are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Calls to transfer your Salesforce records as part of a flow run.
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     */

    public Boolean getUsePrivateLinkForMetadataAndAuthorization() {
        return this.usePrivateLinkForMetadataAndAuthorization;
    }

    /**
     * <p>
     * If the connection mode for the connector profile is private, this parameter sets whether Amazon AppFlow uses the
     * private network to send metadata and authorization calls to Salesforce. Amazon AppFlow sends private calls
     * through Amazon Web Services PrivateLink. These calls travel through Amazon Web Services infrastructure without
     * being exposed to the public internet.
     * </p>
     * <p>
     * Set either of the following values:
     * </p>
     * <dl>
     * <dt>true</dt>
     * <dd>
     * <p>
     * Amazon AppFlow sends all calls to Salesforce over the private network.
     * </p>
     * <p>
     * These private calls are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Calls to get metadata about your Salesforce records. This metadata describes your Salesforce objects and their
     * fields.
     * </p>
     * </li>
     * <li>
     * <p>
     * Calls to get or refresh access tokens that allow Amazon AppFlow to access your Salesforce records.
     * </p>
     * </li>
     * <li>
     * <p>
     * Calls to transfer your Salesforce records as part of a flow run.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>false</dt>
     * <dd>
     * <p>
     * The default value. Amazon AppFlow sends some calls to Salesforce privately and other calls over the public
     * internet.
     * </p>
     * <p>
     * The public calls are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Calls to get metadata about your Salesforce records.
     * </p>
     * </li>
     * <li>
     * <p>
     * Calls to get or refresh access tokens.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The private calls are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Calls to transfer your Salesforce records as part of a flow run.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * </dl>
     * 
     * @param usePrivateLinkForMetadataAndAuthorization
     *        If the connection mode for the connector profile is private, this parameter sets whether Amazon AppFlow
     *        uses the private network to send metadata and authorization calls to Salesforce. Amazon AppFlow sends
     *        private calls through Amazon Web Services PrivateLink. These calls travel through Amazon Web Services
     *        infrastructure without being exposed to the public internet.</p>
     *        <p>
     *        Set either of the following values:
     *        </p>
     *        <dl>
     *        <dt>true</dt>
     *        <dd>
     *        <p>
     *        Amazon AppFlow sends all calls to Salesforce over the private network.
     *        </p>
     *        <p>
     *        These private calls are:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        Calls to get metadata about your Salesforce records. This metadata describes your Salesforce objects and
     *        their fields.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Calls to get or refresh access tokens that allow Amazon AppFlow to access your Salesforce records.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Calls to transfer your Salesforce records as part of a flow run.
     *        </p>
     *        </li>
     *        </ul>
     *        </dd>
     *        <dt>false</dt>
     *        <dd>
     *        <p>
     *        The default value. Amazon AppFlow sends some calls to Salesforce privately and other calls over the public
     *        internet.
     *        </p>
     *        <p>
     *        The public calls are:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        Calls to get metadata about your Salesforce records.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Calls to get or refresh access tokens.
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        The private calls are:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        Calls to transfer your Salesforce records as part of a flow run.
     *        </p>
     *        </li>
     *        </ul>
     *        </dd>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SalesforceConnectorProfileProperties withUsePrivateLinkForMetadataAndAuthorization(Boolean usePrivateLinkForMetadataAndAuthorization) {
        setUsePrivateLinkForMetadataAndAuthorization(usePrivateLinkForMetadataAndAuthorization);
        return this;
    }

    /**
     * <p>
     * If the connection mode for the connector profile is private, this parameter sets whether Amazon AppFlow uses the
     * private network to send metadata and authorization calls to Salesforce. Amazon AppFlow sends private calls
     * through Amazon Web Services PrivateLink. These calls travel through Amazon Web Services infrastructure without
     * being exposed to the public internet.
     * </p>
     * <p>
     * Set either of the following values:
     * </p>
     * <dl>
     * <dt>true</dt>
     * <dd>
     * <p>
     * Amazon AppFlow sends all calls to Salesforce over the private network.
     * </p>
     * <p>
     * These private calls are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Calls to get metadata about your Salesforce records. This metadata describes your Salesforce objects and their
     * fields.
     * </p>
     * </li>
     * <li>
     * <p>
     * Calls to get or refresh access tokens that allow Amazon AppFlow to access your Salesforce records.
     * </p>
     * </li>
     * <li>
     * <p>
     * Calls to transfer your Salesforce records as part of a flow run.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * <dt>false</dt>
     * <dd>
     * <p>
     * The default value. Amazon AppFlow sends some calls to Salesforce privately and other calls over the public
     * internet.
     * </p>
     * <p>
     * The public calls are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Calls to get metadata about your Salesforce records.
     * </p>
     * </li>
     * <li>
     * <p>
     * Calls to get or refresh access tokens.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The private calls are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Calls to transfer your Salesforce records as part of a flow run.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * </dl>
     * 
     * @return If the connection mode for the connector profile is private, this parameter sets whether Amazon AppFlow
     *         uses the private network to send metadata and authorization calls to Salesforce. Amazon AppFlow sends
     *         private calls through Amazon Web Services PrivateLink. These calls travel through Amazon Web Services
     *         infrastructure without being exposed to the public internet.</p>
     *         <p>
     *         Set either of the following values:
     *         </p>
     *         <dl>
     *         <dt>true</dt>
     *         <dd>
     *         <p>
     *         Amazon AppFlow sends all calls to Salesforce over the private network.
     *         </p>
     *         <p>
     *         These private calls are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Calls to get metadata about your Salesforce records. This metadata describes your Salesforce objects and
     *         their fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Calls to get or refresh access tokens that allow Amazon AppFlow to access your Salesforce records.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Calls to transfer your Salesforce records as part of a flow run.
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     *         <dt>false</dt>
     *         <dd>
     *         <p>
     *         The default value. Amazon AppFlow sends some calls to Salesforce privately and other calls over the
     *         public internet.
     *         </p>
     *         <p>
     *         The public calls are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Calls to get metadata about your Salesforce records.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Calls to get or refresh access tokens.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The private calls are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Calls to transfer your Salesforce records as part of a flow run.
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     */

    public Boolean isUsePrivateLinkForMetadataAndAuthorization() {
        return this.usePrivateLinkForMetadataAndAuthorization;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getInstanceUrl() != null)
            sb.append("InstanceUrl: ").append(getInstanceUrl()).append(",");
        if (getIsSandboxEnvironment() != null)
            sb.append("IsSandboxEnvironment: ").append(getIsSandboxEnvironment()).append(",");
        if (getUsePrivateLinkForMetadataAndAuthorization() != null)
            sb.append("UsePrivateLinkForMetadataAndAuthorization: ").append(getUsePrivateLinkForMetadataAndAuthorization());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof SalesforceConnectorProfileProperties == false)
            return false;
        SalesforceConnectorProfileProperties other = (SalesforceConnectorProfileProperties) obj;
        if (other.getInstanceUrl() == null ^ this.getInstanceUrl() == null)
            return false;
        if (other.getInstanceUrl() != null && other.getInstanceUrl().equals(this.getInstanceUrl()) == false)
            return false;
        if (other.getIsSandboxEnvironment() == null ^ this.getIsSandboxEnvironment() == null)
            return false;
        if (other.getIsSandboxEnvironment() != null && other.getIsSandboxEnvironment().equals(this.getIsSandboxEnvironment()) == false)
            return false;
        if (other.getUsePrivateLinkForMetadataAndAuthorization() == null ^ this.getUsePrivateLinkForMetadataAndAuthorization() == null)
            return false;
        if (other.getUsePrivateLinkForMetadataAndAuthorization() != null
                && other.getUsePrivateLinkForMetadataAndAuthorization().equals(this.getUsePrivateLinkForMetadataAndAuthorization()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getInstanceUrl() == null) ? 0 : getInstanceUrl().hashCode());
        hashCode = prime * hashCode + ((getIsSandboxEnvironment() == null) ? 0 : getIsSandboxEnvironment().hashCode());
        hashCode = prime * hashCode
                + ((getUsePrivateLinkForMetadataAndAuthorization() == null) ? 0 : getUsePrivateLinkForMetadataAndAuthorization().hashCode());
        return hashCode;
    }

    @Override
    public SalesforceConnectorProfileProperties clone() {
        try {
            return (SalesforceConnectorProfileProperties) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.appflow.model.transform.SalesforceConnectorProfilePropertiesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
