/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appmesh.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.appmesh.model.WeightedTarget;

@SdkInternalApi
public class WeightedTargetMarshaller {
    private static final MarshallingInfo<Integer> PORT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("port").build();
    private static final MarshallingInfo<String> VIRTUALNODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("virtualNode").build();
    private static final MarshallingInfo<Integer> WEIGHT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("weight").build();
    private static final WeightedTargetMarshaller instance = new WeightedTargetMarshaller();

    public static WeightedTargetMarshaller getInstance() {
        return instance;
    }

    public void marshall(WeightedTarget weightedTarget, ProtocolMarshaller protocolMarshaller) {
        if (weightedTarget == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)weightedTarget.getPort(), PORT_BINDING);
            protocolMarshaller.marshall((Object)weightedTarget.getVirtualNode(), VIRTUALNODE_BINDING);
            protocolMarshaller.marshall((Object)weightedTarget.getWeight(), WEIGHT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

