/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.appregistry;

import javax.annotation.Generated;

import com.amazonaws.services.appregistry.model.*;

/**
 * Abstract implementation of {@code AWSAppRegistryAsync}. Convenient method forms pass through to the corresponding
 * overload that takes a request object and an {@code AsyncHandler}, which throws an
 * {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSAppRegistryAsync extends AbstractAWSAppRegistry implements AWSAppRegistryAsync {

    protected AbstractAWSAppRegistryAsync() {
    }

    @Override
    public java.util.concurrent.Future<AssociateAttributeGroupResult> associateAttributeGroupAsync(AssociateAttributeGroupRequest request) {

        return associateAttributeGroupAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<AssociateAttributeGroupResult> associateAttributeGroupAsync(AssociateAttributeGroupRequest request,
            com.amazonaws.handlers.AsyncHandler<AssociateAttributeGroupRequest, AssociateAttributeGroupResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<AssociateResourceResult> associateResourceAsync(AssociateResourceRequest request) {

        return associateResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<AssociateResourceResult> associateResourceAsync(AssociateResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<AssociateResourceRequest, AssociateResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateApplicationResult> createApplicationAsync(CreateApplicationRequest request) {

        return createApplicationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateApplicationResult> createApplicationAsync(CreateApplicationRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateApplicationRequest, CreateApplicationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateAttributeGroupResult> createAttributeGroupAsync(CreateAttributeGroupRequest request) {

        return createAttributeGroupAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateAttributeGroupResult> createAttributeGroupAsync(CreateAttributeGroupRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateAttributeGroupRequest, CreateAttributeGroupResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteApplicationResult> deleteApplicationAsync(DeleteApplicationRequest request) {

        return deleteApplicationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteApplicationResult> deleteApplicationAsync(DeleteApplicationRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteApplicationRequest, DeleteApplicationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteAttributeGroupResult> deleteAttributeGroupAsync(DeleteAttributeGroupRequest request) {

        return deleteAttributeGroupAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteAttributeGroupResult> deleteAttributeGroupAsync(DeleteAttributeGroupRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteAttributeGroupRequest, DeleteAttributeGroupResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DisassociateAttributeGroupResult> disassociateAttributeGroupAsync(DisassociateAttributeGroupRequest request) {

        return disassociateAttributeGroupAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DisassociateAttributeGroupResult> disassociateAttributeGroupAsync(DisassociateAttributeGroupRequest request,
            com.amazonaws.handlers.AsyncHandler<DisassociateAttributeGroupRequest, DisassociateAttributeGroupResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DisassociateResourceResult> disassociateResourceAsync(DisassociateResourceRequest request) {

        return disassociateResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DisassociateResourceResult> disassociateResourceAsync(DisassociateResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<DisassociateResourceRequest, DisassociateResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetApplicationResult> getApplicationAsync(GetApplicationRequest request) {

        return getApplicationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetApplicationResult> getApplicationAsync(GetApplicationRequest request,
            com.amazonaws.handlers.AsyncHandler<GetApplicationRequest, GetApplicationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetAttributeGroupResult> getAttributeGroupAsync(GetAttributeGroupRequest request) {

        return getAttributeGroupAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetAttributeGroupResult> getAttributeGroupAsync(GetAttributeGroupRequest request,
            com.amazonaws.handlers.AsyncHandler<GetAttributeGroupRequest, GetAttributeGroupResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListApplicationsResult> listApplicationsAsync(ListApplicationsRequest request) {

        return listApplicationsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListApplicationsResult> listApplicationsAsync(ListApplicationsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListApplicationsRequest, ListApplicationsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListAssociatedAttributeGroupsResult> listAssociatedAttributeGroupsAsync(ListAssociatedAttributeGroupsRequest request) {

        return listAssociatedAttributeGroupsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListAssociatedAttributeGroupsResult> listAssociatedAttributeGroupsAsync(ListAssociatedAttributeGroupsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListAssociatedAttributeGroupsRequest, ListAssociatedAttributeGroupsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListAssociatedResourcesResult> listAssociatedResourcesAsync(ListAssociatedResourcesRequest request) {

        return listAssociatedResourcesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListAssociatedResourcesResult> listAssociatedResourcesAsync(ListAssociatedResourcesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListAssociatedResourcesRequest, ListAssociatedResourcesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListAttributeGroupsResult> listAttributeGroupsAsync(ListAttributeGroupsRequest request) {

        return listAttributeGroupsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListAttributeGroupsResult> listAttributeGroupsAsync(ListAttributeGroupsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListAttributeGroupsRequest, ListAttributeGroupsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {

        return listTagsForResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<SyncResourceResult> syncResourceAsync(SyncResourceRequest request) {

        return syncResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<SyncResourceResult> syncResourceAsync(SyncResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<SyncResourceRequest, SyncResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {

        return tagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {

        return untagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateApplicationResult> updateApplicationAsync(UpdateApplicationRequest request) {

        return updateApplicationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateApplicationResult> updateApplicationAsync(UpdateApplicationRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateApplicationRequest, UpdateApplicationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateAttributeGroupResult> updateAttributeGroupAsync(UpdateAttributeGroupRequest request) {

        return updateAttributeGroupAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateAttributeGroupResult> updateAttributeGroupAsync(UpdateAttributeGroupRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateAttributeGroupRequest, UpdateAttributeGroupResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

}
