/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appregistry.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.appregistry.model.ApplicationTagResult;
import com.amazonaws.services.appregistry.model.AssociationOption;
import com.amazonaws.services.appregistry.model.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetAssociatedResourceResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private Resource resource;
    private List<String> options;
    private ApplicationTagResult applicationTagResult;

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public Resource getResource() {
        return this.resource;
    }

    public GetAssociatedResourceResult withResource(Resource resource) {
        this.setResource(resource);
        return this;
    }

    public List<String> getOptions() {
        return this.options;
    }

    public void setOptions(Collection<String> options) {
        if (options == null) {
            this.options = null;
            return;
        }
        this.options = new ArrayList<String>(options);
    }

    public GetAssociatedResourceResult withOptions(String ... options) {
        if (this.options == null) {
            this.setOptions(new ArrayList<String>(options.length));
        }
        for (String ele : options) {
            this.options.add(ele);
        }
        return this;
    }

    public GetAssociatedResourceResult withOptions(Collection<String> options) {
        this.setOptions(options);
        return this;
    }

    public GetAssociatedResourceResult withOptions(AssociationOption ... options) {
        ArrayList<String> optionsCopy = new ArrayList<String>(options.length);
        for (AssociationOption value : options) {
            optionsCopy.add(value.toString());
        }
        if (this.getOptions() == null) {
            this.setOptions(optionsCopy);
        } else {
            this.getOptions().addAll(optionsCopy);
        }
        return this;
    }

    public void setApplicationTagResult(ApplicationTagResult applicationTagResult) {
        this.applicationTagResult = applicationTagResult;
    }

    public ApplicationTagResult getApplicationTagResult() {
        return this.applicationTagResult;
    }

    public GetAssociatedResourceResult withApplicationTagResult(ApplicationTagResult applicationTagResult) {
        this.setApplicationTagResult(applicationTagResult);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResource() != null) {
            sb.append("Resource: ").append(this.getResource()).append(",");
        }
        if (this.getOptions() != null) {
            sb.append("Options: ").append(this.getOptions()).append(",");
        }
        if (this.getApplicationTagResult() != null) {
            sb.append("ApplicationTagResult: ").append(this.getApplicationTagResult());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAssociatedResourceResult)) {
            return false;
        }
        GetAssociatedResourceResult other = (GetAssociatedResourceResult)obj;
        if (other.getResource() == null ^ this.getResource() == null) {
            return false;
        }
        if (other.getResource() != null && !other.getResource().equals(this.getResource())) {
            return false;
        }
        if (other.getOptions() == null ^ this.getOptions() == null) {
            return false;
        }
        if (other.getOptions() != null && !other.getOptions().equals(this.getOptions())) {
            return false;
        }
        if (other.getApplicationTagResult() == null ^ this.getApplicationTagResult() == null) {
            return false;
        }
        return other.getApplicationTagResult() == null || other.getApplicationTagResult().equals(this.getApplicationTagResult());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResource() == null ? 0 : this.getResource().hashCode());
        hashCode = 31 * hashCode + (this.getOptions() == null ? 0 : this.getOptions().hashCode());
        hashCode = 31 * hashCode + (this.getApplicationTagResult() == null ? 0 : this.getApplicationTagResult().hashCode());
        return hashCode;
    }

    public GetAssociatedResourceResult clone() {
        try {
            return (GetAssociatedResourceResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

