/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appstream.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appstream.model.Application;
import com.amazonaws.services.appstream.model.ImageState;
import com.amazonaws.services.appstream.model.ImageStateChangeReason;
import com.amazonaws.services.appstream.model.PlatformType;
import com.amazonaws.services.appstream.model.VisibilityType;
import com.amazonaws.services.appstream.model.transform.ImageMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Image
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String arn;
    private String baseImageArn;
    private String displayName;
    private String state;
    private String visibility;
    private String platform;
    private String description;
    private ImageStateChangeReason stateChangeReason;
    private List<Application> applications;
    private Date createdTime;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Image withName(String name) {
        this.setName(name);
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public Image withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setBaseImageArn(String baseImageArn) {
        this.baseImageArn = baseImageArn;
    }

    public String getBaseImageArn() {
        return this.baseImageArn;
    }

    public Image withBaseImageArn(String baseImageArn) {
        this.setBaseImageArn(baseImageArn);
        return this;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Image withDisplayName(String displayName) {
        this.setDisplayName(displayName);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public Image withState(String state) {
        this.setState(state);
        return this;
    }

    public void setState(ImageState state) {
        this.state = state.toString();
    }

    public Image withState(ImageState state) {
        this.setState(state);
        return this;
    }

    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public Image withVisibility(String visibility) {
        this.setVisibility(visibility);
        return this;
    }

    public void setVisibility(VisibilityType visibility) {
        this.visibility = visibility.toString();
    }

    public Image withVisibility(VisibilityType visibility) {
        this.setVisibility(visibility);
        return this;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getPlatform() {
        return this.platform;
    }

    public Image withPlatform(String platform) {
        this.setPlatform(platform);
        return this;
    }

    public void setPlatform(PlatformType platform) {
        this.platform = platform.toString();
    }

    public Image withPlatform(PlatformType platform) {
        this.setPlatform(platform);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Image withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setStateChangeReason(ImageStateChangeReason stateChangeReason) {
        this.stateChangeReason = stateChangeReason;
    }

    public ImageStateChangeReason getStateChangeReason() {
        return this.stateChangeReason;
    }

    public Image withStateChangeReason(ImageStateChangeReason stateChangeReason) {
        this.setStateChangeReason(stateChangeReason);
        return this;
    }

    public List<Application> getApplications() {
        return this.applications;
    }

    public void setApplications(Collection<Application> applications) {
        if (applications == null) {
            this.applications = null;
            return;
        }
        this.applications = new ArrayList<Application>(applications);
    }

    public Image withApplications(Application ... applications) {
        if (this.applications == null) {
            this.setApplications(new ArrayList<Application>(applications.length));
        }
        for (Application ele : applications) {
            this.applications.add(ele);
        }
        return this;
    }

    public Image withApplications(Collection<Application> applications) {
        this.setApplications(applications);
        return this;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public Image withCreatedTime(Date createdTime) {
        this.setCreatedTime(createdTime);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getBaseImageArn() != null) {
            sb.append("BaseImageArn: ").append(this.getBaseImageArn()).append(",");
        }
        if (this.getDisplayName() != null) {
            sb.append("DisplayName: ").append(this.getDisplayName()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getVisibility() != null) {
            sb.append("Visibility: ").append(this.getVisibility()).append(",");
        }
        if (this.getPlatform() != null) {
            sb.append("Platform: ").append(this.getPlatform()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getStateChangeReason() != null) {
            sb.append("StateChangeReason: ").append(this.getStateChangeReason()).append(",");
        }
        if (this.getApplications() != null) {
            sb.append("Applications: ").append(this.getApplications()).append(",");
        }
        if (this.getCreatedTime() != null) {
            sb.append("CreatedTime: ").append(this.getCreatedTime());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Image)) {
            return false;
        }
        Image other = (Image)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getBaseImageArn() == null ^ this.getBaseImageArn() == null) {
            return false;
        }
        if (other.getBaseImageArn() != null && !other.getBaseImageArn().equals(this.getBaseImageArn())) {
            return false;
        }
        if (other.getDisplayName() == null ^ this.getDisplayName() == null) {
            return false;
        }
        if (other.getDisplayName() != null && !other.getDisplayName().equals(this.getDisplayName())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getVisibility() == null ^ this.getVisibility() == null) {
            return false;
        }
        if (other.getVisibility() != null && !other.getVisibility().equals(this.getVisibility())) {
            return false;
        }
        if (other.getPlatform() == null ^ this.getPlatform() == null) {
            return false;
        }
        if (other.getPlatform() != null && !other.getPlatform().equals(this.getPlatform())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getStateChangeReason() == null ^ this.getStateChangeReason() == null) {
            return false;
        }
        if (other.getStateChangeReason() != null && !other.getStateChangeReason().equals(this.getStateChangeReason())) {
            return false;
        }
        if (other.getApplications() == null ^ this.getApplications() == null) {
            return false;
        }
        if (other.getApplications() != null && !other.getApplications().equals(this.getApplications())) {
            return false;
        }
        if (other.getCreatedTime() == null ^ this.getCreatedTime() == null) {
            return false;
        }
        return other.getCreatedTime() == null || other.getCreatedTime().equals(this.getCreatedTime());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getBaseImageArn() == null ? 0 : this.getBaseImageArn().hashCode());
        hashCode = 31 * hashCode + (this.getDisplayName() == null ? 0 : this.getDisplayName().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getVisibility() == null ? 0 : this.getVisibility().hashCode());
        hashCode = 31 * hashCode + (this.getPlatform() == null ? 0 : this.getPlatform().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getStateChangeReason() == null ? 0 : this.getStateChangeReason().hashCode());
        hashCode = 31 * hashCode + (this.getApplications() == null ? 0 : this.getApplications().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedTime() == null ? 0 : this.getCreatedTime().hashCode());
        return hashCode;
    }

    public Image clone() {
        try {
            return (Image)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ImageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

