/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appstream.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appstream.model.AccessEndpoint;
import com.amazonaws.services.appstream.model.ApplicationSettingsResponse;
import com.amazonaws.services.appstream.model.StackError;
import com.amazonaws.services.appstream.model.StorageConnector;
import com.amazonaws.services.appstream.model.StreamingExperienceSettings;
import com.amazonaws.services.appstream.model.UserSetting;
import com.amazonaws.services.appstream.model.transform.StackMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Stack
implements Serializable,
Cloneable,
StructuredPojo {
    private String arn;
    private String name;
    private String description;
    private String displayName;
    private Date createdTime;
    private List<StorageConnector> storageConnectors;
    private String redirectURL;
    private String feedbackURL;
    private List<StackError> stackErrors;
    private List<UserSetting> userSettings;
    private ApplicationSettingsResponse applicationSettings;
    private List<AccessEndpoint> accessEndpoints;
    private List<String> embedHostDomains;
    private StreamingExperienceSettings streamingExperienceSettings;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public Stack withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Stack withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Stack withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Stack withDisplayName(String displayName) {
        this.setDisplayName(displayName);
        return this;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public Stack withCreatedTime(Date createdTime) {
        this.setCreatedTime(createdTime);
        return this;
    }

    public List<StorageConnector> getStorageConnectors() {
        return this.storageConnectors;
    }

    public void setStorageConnectors(Collection<StorageConnector> storageConnectors) {
        if (storageConnectors == null) {
            this.storageConnectors = null;
            return;
        }
        this.storageConnectors = new ArrayList<StorageConnector>(storageConnectors);
    }

    public Stack withStorageConnectors(StorageConnector ... storageConnectors) {
        if (this.storageConnectors == null) {
            this.setStorageConnectors(new ArrayList<StorageConnector>(storageConnectors.length));
        }
        for (StorageConnector ele : storageConnectors) {
            this.storageConnectors.add(ele);
        }
        return this;
    }

    public Stack withStorageConnectors(Collection<StorageConnector> storageConnectors) {
        this.setStorageConnectors(storageConnectors);
        return this;
    }

    public void setRedirectURL(String redirectURL) {
        this.redirectURL = redirectURL;
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    public Stack withRedirectURL(String redirectURL) {
        this.setRedirectURL(redirectURL);
        return this;
    }

    public void setFeedbackURL(String feedbackURL) {
        this.feedbackURL = feedbackURL;
    }

    public String getFeedbackURL() {
        return this.feedbackURL;
    }

    public Stack withFeedbackURL(String feedbackURL) {
        this.setFeedbackURL(feedbackURL);
        return this;
    }

    public List<StackError> getStackErrors() {
        return this.stackErrors;
    }

    public void setStackErrors(Collection<StackError> stackErrors) {
        if (stackErrors == null) {
            this.stackErrors = null;
            return;
        }
        this.stackErrors = new ArrayList<StackError>(stackErrors);
    }

    public Stack withStackErrors(StackError ... stackErrors) {
        if (this.stackErrors == null) {
            this.setStackErrors(new ArrayList<StackError>(stackErrors.length));
        }
        for (StackError ele : stackErrors) {
            this.stackErrors.add(ele);
        }
        return this;
    }

    public Stack withStackErrors(Collection<StackError> stackErrors) {
        this.setStackErrors(stackErrors);
        return this;
    }

    public List<UserSetting> getUserSettings() {
        return this.userSettings;
    }

    public void setUserSettings(Collection<UserSetting> userSettings) {
        if (userSettings == null) {
            this.userSettings = null;
            return;
        }
        this.userSettings = new ArrayList<UserSetting>(userSettings);
    }

    public Stack withUserSettings(UserSetting ... userSettings) {
        if (this.userSettings == null) {
            this.setUserSettings(new ArrayList<UserSetting>(userSettings.length));
        }
        for (UserSetting ele : userSettings) {
            this.userSettings.add(ele);
        }
        return this;
    }

    public Stack withUserSettings(Collection<UserSetting> userSettings) {
        this.setUserSettings(userSettings);
        return this;
    }

    public void setApplicationSettings(ApplicationSettingsResponse applicationSettings) {
        this.applicationSettings = applicationSettings;
    }

    public ApplicationSettingsResponse getApplicationSettings() {
        return this.applicationSettings;
    }

    public Stack withApplicationSettings(ApplicationSettingsResponse applicationSettings) {
        this.setApplicationSettings(applicationSettings);
        return this;
    }

    public List<AccessEndpoint> getAccessEndpoints() {
        return this.accessEndpoints;
    }

    public void setAccessEndpoints(Collection<AccessEndpoint> accessEndpoints) {
        if (accessEndpoints == null) {
            this.accessEndpoints = null;
            return;
        }
        this.accessEndpoints = new ArrayList<AccessEndpoint>(accessEndpoints);
    }

    public Stack withAccessEndpoints(AccessEndpoint ... accessEndpoints) {
        if (this.accessEndpoints == null) {
            this.setAccessEndpoints(new ArrayList<AccessEndpoint>(accessEndpoints.length));
        }
        for (AccessEndpoint ele : accessEndpoints) {
            this.accessEndpoints.add(ele);
        }
        return this;
    }

    public Stack withAccessEndpoints(Collection<AccessEndpoint> accessEndpoints) {
        this.setAccessEndpoints(accessEndpoints);
        return this;
    }

    public List<String> getEmbedHostDomains() {
        return this.embedHostDomains;
    }

    public void setEmbedHostDomains(Collection<String> embedHostDomains) {
        if (embedHostDomains == null) {
            this.embedHostDomains = null;
            return;
        }
        this.embedHostDomains = new ArrayList<String>(embedHostDomains);
    }

    public Stack withEmbedHostDomains(String ... embedHostDomains) {
        if (this.embedHostDomains == null) {
            this.setEmbedHostDomains(new ArrayList<String>(embedHostDomains.length));
        }
        for (String ele : embedHostDomains) {
            this.embedHostDomains.add(ele);
        }
        return this;
    }

    public Stack withEmbedHostDomains(Collection<String> embedHostDomains) {
        this.setEmbedHostDomains(embedHostDomains);
        return this;
    }

    public void setStreamingExperienceSettings(StreamingExperienceSettings streamingExperienceSettings) {
        this.streamingExperienceSettings = streamingExperienceSettings;
    }

    public StreamingExperienceSettings getStreamingExperienceSettings() {
        return this.streamingExperienceSettings;
    }

    public Stack withStreamingExperienceSettings(StreamingExperienceSettings streamingExperienceSettings) {
        this.setStreamingExperienceSettings(streamingExperienceSettings);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getDisplayName() != null) {
            sb.append("DisplayName: ").append(this.getDisplayName()).append(",");
        }
        if (this.getCreatedTime() != null) {
            sb.append("CreatedTime: ").append(this.getCreatedTime()).append(",");
        }
        if (this.getStorageConnectors() != null) {
            sb.append("StorageConnectors: ").append(this.getStorageConnectors()).append(",");
        }
        if (this.getRedirectURL() != null) {
            sb.append("RedirectURL: ").append(this.getRedirectURL()).append(",");
        }
        if (this.getFeedbackURL() != null) {
            sb.append("FeedbackURL: ").append(this.getFeedbackURL()).append(",");
        }
        if (this.getStackErrors() != null) {
            sb.append("StackErrors: ").append(this.getStackErrors()).append(",");
        }
        if (this.getUserSettings() != null) {
            sb.append("UserSettings: ").append(this.getUserSettings()).append(",");
        }
        if (this.getApplicationSettings() != null) {
            sb.append("ApplicationSettings: ").append(this.getApplicationSettings()).append(",");
        }
        if (this.getAccessEndpoints() != null) {
            sb.append("AccessEndpoints: ").append(this.getAccessEndpoints()).append(",");
        }
        if (this.getEmbedHostDomains() != null) {
            sb.append("EmbedHostDomains: ").append(this.getEmbedHostDomains()).append(",");
        }
        if (this.getStreamingExperienceSettings() != null) {
            sb.append("StreamingExperienceSettings: ").append(this.getStreamingExperienceSettings());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Stack)) {
            return false;
        }
        Stack other = (Stack)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getDisplayName() == null ^ this.getDisplayName() == null) {
            return false;
        }
        if (other.getDisplayName() != null && !other.getDisplayName().equals(this.getDisplayName())) {
            return false;
        }
        if (other.getCreatedTime() == null ^ this.getCreatedTime() == null) {
            return false;
        }
        if (other.getCreatedTime() != null && !other.getCreatedTime().equals(this.getCreatedTime())) {
            return false;
        }
        if (other.getStorageConnectors() == null ^ this.getStorageConnectors() == null) {
            return false;
        }
        if (other.getStorageConnectors() != null && !other.getStorageConnectors().equals(this.getStorageConnectors())) {
            return false;
        }
        if (other.getRedirectURL() == null ^ this.getRedirectURL() == null) {
            return false;
        }
        if (other.getRedirectURL() != null && !other.getRedirectURL().equals(this.getRedirectURL())) {
            return false;
        }
        if (other.getFeedbackURL() == null ^ this.getFeedbackURL() == null) {
            return false;
        }
        if (other.getFeedbackURL() != null && !other.getFeedbackURL().equals(this.getFeedbackURL())) {
            return false;
        }
        if (other.getStackErrors() == null ^ this.getStackErrors() == null) {
            return false;
        }
        if (other.getStackErrors() != null && !other.getStackErrors().equals(this.getStackErrors())) {
            return false;
        }
        if (other.getUserSettings() == null ^ this.getUserSettings() == null) {
            return false;
        }
        if (other.getUserSettings() != null && !other.getUserSettings().equals(this.getUserSettings())) {
            return false;
        }
        if (other.getApplicationSettings() == null ^ this.getApplicationSettings() == null) {
            return false;
        }
        if (other.getApplicationSettings() != null && !other.getApplicationSettings().equals(this.getApplicationSettings())) {
            return false;
        }
        if (other.getAccessEndpoints() == null ^ this.getAccessEndpoints() == null) {
            return false;
        }
        if (other.getAccessEndpoints() != null && !other.getAccessEndpoints().equals(this.getAccessEndpoints())) {
            return false;
        }
        if (other.getEmbedHostDomains() == null ^ this.getEmbedHostDomains() == null) {
            return false;
        }
        if (other.getEmbedHostDomains() != null && !other.getEmbedHostDomains().equals(this.getEmbedHostDomains())) {
            return false;
        }
        if (other.getStreamingExperienceSettings() == null ^ this.getStreamingExperienceSettings() == null) {
            return false;
        }
        return other.getStreamingExperienceSettings() == null || other.getStreamingExperienceSettings().equals(this.getStreamingExperienceSettings());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getDisplayName() == null ? 0 : this.getDisplayName().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedTime() == null ? 0 : this.getCreatedTime().hashCode());
        hashCode = 31 * hashCode + (this.getStorageConnectors() == null ? 0 : this.getStorageConnectors().hashCode());
        hashCode = 31 * hashCode + (this.getRedirectURL() == null ? 0 : this.getRedirectURL().hashCode());
        hashCode = 31 * hashCode + (this.getFeedbackURL() == null ? 0 : this.getFeedbackURL().hashCode());
        hashCode = 31 * hashCode + (this.getStackErrors() == null ? 0 : this.getStackErrors().hashCode());
        hashCode = 31 * hashCode + (this.getUserSettings() == null ? 0 : this.getUserSettings().hashCode());
        hashCode = 31 * hashCode + (this.getApplicationSettings() == null ? 0 : this.getApplicationSettings().hashCode());
        hashCode = 31 * hashCode + (this.getAccessEndpoints() == null ? 0 : this.getAccessEndpoints().hashCode());
        hashCode = 31 * hashCode + (this.getEmbedHostDomains() == null ? 0 : this.getEmbedHostDomains().hashCode());
        hashCode = 31 * hashCode + (this.getStreamingExperienceSettings() == null ? 0 : this.getStreamingExperienceSettings().hashCode());
        return hashCode;
    }

    public Stack clone() {
        try {
            return (Stack)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StackMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

