/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.appstream.model;

import javax.annotation.Generated;

/**
 * <p>
 * The fleet attribute.
 * </p>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public enum FleetAttribute {

    VPC_CONFIGURATION("VPC_CONFIGURATION"),
    VPC_CONFIGURATION_SECURITY_GROUP_IDS("VPC_CONFIGURATION_SECURITY_GROUP_IDS"),
    DOMAIN_JOIN_INFO("DOMAIN_JOIN_INFO"),
    IAM_ROLE_ARN("IAM_ROLE_ARN"),
    USB_DEVICE_FILTER_STRINGS("USB_DEVICE_FILTER_STRINGS"),
    SESSION_SCRIPT_S3_LOCATION("SESSION_SCRIPT_S3_LOCATION");

    private String value;

    private FleetAttribute(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return this.value;
    }

    /**
     * Use this in place of valueOf.
     *
     * @param value
     *        real value
     * @return FleetAttribute corresponding to the value
     *
     * @throws IllegalArgumentException
     *         If the specified value does not map to one of the known values in this enum.
     */
    public static FleetAttribute fromValue(String value) {
        if (value == null || "".equals(value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }

        for (FleetAttribute enumEntry : FleetAttribute.values()) {
            if (enumEntry.toString().equals(value)) {
                return enumEntry;
            }
        }

        throw new IllegalArgumentException("Cannot create enum from " + value + " value!");
    }
}
