/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appstream.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appstream.model.AccessEndpoint;
import com.amazonaws.services.appstream.model.DomainJoinInfo;
import com.amazonaws.services.appstream.model.ImageBuilderState;
import com.amazonaws.services.appstream.model.ImageBuilderStateChangeReason;
import com.amazonaws.services.appstream.model.NetworkAccessConfiguration;
import com.amazonaws.services.appstream.model.PlatformType;
import com.amazonaws.services.appstream.model.ResourceError;
import com.amazonaws.services.appstream.model.VpcConfig;
import com.amazonaws.services.appstream.model.transform.ImageBuilderMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class ImageBuilder
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String arn;
    private String imageArn;
    private String description;
    private String displayName;
    private VpcConfig vpcConfig;
    private String instanceType;
    private String platform;
    private String iamRoleArn;
    private String state;
    private ImageBuilderStateChangeReason stateChangeReason;
    private Date createdTime;
    private Boolean enableDefaultInternetAccess;
    private DomainJoinInfo domainJoinInfo;
    private NetworkAccessConfiguration networkAccessConfiguration;
    private List<ResourceError> imageBuilderErrors;
    private String appstreamAgentVersion;
    private List<AccessEndpoint> accessEndpoints;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ImageBuilder withName(String name) {
        this.setName(name);
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public ImageBuilder withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setImageArn(String imageArn) {
        this.imageArn = imageArn;
    }

    public String getImageArn() {
        return this.imageArn;
    }

    public ImageBuilder withImageArn(String imageArn) {
        this.setImageArn(imageArn);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public ImageBuilder withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public ImageBuilder withDisplayName(String displayName) {
        this.setDisplayName(displayName);
        return this;
    }

    public void setVpcConfig(VpcConfig vpcConfig) {
        this.vpcConfig = vpcConfig;
    }

    public VpcConfig getVpcConfig() {
        return this.vpcConfig;
    }

    public ImageBuilder withVpcConfig(VpcConfig vpcConfig) {
        this.setVpcConfig(vpcConfig);
        return this;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public ImageBuilder withInstanceType(String instanceType) {
        this.setInstanceType(instanceType);
        return this;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getPlatform() {
        return this.platform;
    }

    public ImageBuilder withPlatform(String platform) {
        this.setPlatform(platform);
        return this;
    }

    public ImageBuilder withPlatform(PlatformType platform) {
        this.platform = platform.toString();
        return this;
    }

    public void setIamRoleArn(String iamRoleArn) {
        this.iamRoleArn = iamRoleArn;
    }

    public String getIamRoleArn() {
        return this.iamRoleArn;
    }

    public ImageBuilder withIamRoleArn(String iamRoleArn) {
        this.setIamRoleArn(iamRoleArn);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public ImageBuilder withState(String state) {
        this.setState(state);
        return this;
    }

    public ImageBuilder withState(ImageBuilderState state) {
        this.state = state.toString();
        return this;
    }

    public void setStateChangeReason(ImageBuilderStateChangeReason stateChangeReason) {
        this.stateChangeReason = stateChangeReason;
    }

    public ImageBuilderStateChangeReason getStateChangeReason() {
        return this.stateChangeReason;
    }

    public ImageBuilder withStateChangeReason(ImageBuilderStateChangeReason stateChangeReason) {
        this.setStateChangeReason(stateChangeReason);
        return this;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public ImageBuilder withCreatedTime(Date createdTime) {
        this.setCreatedTime(createdTime);
        return this;
    }

    public void setEnableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
        this.enableDefaultInternetAccess = enableDefaultInternetAccess;
    }

    public Boolean getEnableDefaultInternetAccess() {
        return this.enableDefaultInternetAccess;
    }

    public ImageBuilder withEnableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
        this.setEnableDefaultInternetAccess(enableDefaultInternetAccess);
        return this;
    }

    public Boolean isEnableDefaultInternetAccess() {
        return this.enableDefaultInternetAccess;
    }

    public void setDomainJoinInfo(DomainJoinInfo domainJoinInfo) {
        this.domainJoinInfo = domainJoinInfo;
    }

    public DomainJoinInfo getDomainJoinInfo() {
        return this.domainJoinInfo;
    }

    public ImageBuilder withDomainJoinInfo(DomainJoinInfo domainJoinInfo) {
        this.setDomainJoinInfo(domainJoinInfo);
        return this;
    }

    public void setNetworkAccessConfiguration(NetworkAccessConfiguration networkAccessConfiguration) {
        this.networkAccessConfiguration = networkAccessConfiguration;
    }

    public NetworkAccessConfiguration getNetworkAccessConfiguration() {
        return this.networkAccessConfiguration;
    }

    public ImageBuilder withNetworkAccessConfiguration(NetworkAccessConfiguration networkAccessConfiguration) {
        this.setNetworkAccessConfiguration(networkAccessConfiguration);
        return this;
    }

    public List<ResourceError> getImageBuilderErrors() {
        return this.imageBuilderErrors;
    }

    public void setImageBuilderErrors(Collection<ResourceError> imageBuilderErrors) {
        if (imageBuilderErrors == null) {
            this.imageBuilderErrors = null;
            return;
        }
        this.imageBuilderErrors = new ArrayList<ResourceError>(imageBuilderErrors);
    }

    public ImageBuilder withImageBuilderErrors(ResourceError ... imageBuilderErrors) {
        if (this.imageBuilderErrors == null) {
            this.setImageBuilderErrors(new ArrayList<ResourceError>(imageBuilderErrors.length));
        }
        for (ResourceError ele : imageBuilderErrors) {
            this.imageBuilderErrors.add(ele);
        }
        return this;
    }

    public ImageBuilder withImageBuilderErrors(Collection<ResourceError> imageBuilderErrors) {
        this.setImageBuilderErrors(imageBuilderErrors);
        return this;
    }

    public void setAppstreamAgentVersion(String appstreamAgentVersion) {
        this.appstreamAgentVersion = appstreamAgentVersion;
    }

    public String getAppstreamAgentVersion() {
        return this.appstreamAgentVersion;
    }

    public ImageBuilder withAppstreamAgentVersion(String appstreamAgentVersion) {
        this.setAppstreamAgentVersion(appstreamAgentVersion);
        return this;
    }

    public List<AccessEndpoint> getAccessEndpoints() {
        return this.accessEndpoints;
    }

    public void setAccessEndpoints(Collection<AccessEndpoint> accessEndpoints) {
        if (accessEndpoints == null) {
            this.accessEndpoints = null;
            return;
        }
        this.accessEndpoints = new ArrayList<AccessEndpoint>(accessEndpoints);
    }

    public ImageBuilder withAccessEndpoints(AccessEndpoint ... accessEndpoints) {
        if (this.accessEndpoints == null) {
            this.setAccessEndpoints(new ArrayList<AccessEndpoint>(accessEndpoints.length));
        }
        for (AccessEndpoint ele : accessEndpoints) {
            this.accessEndpoints.add(ele);
        }
        return this;
    }

    public ImageBuilder withAccessEndpoints(Collection<AccessEndpoint> accessEndpoints) {
        this.setAccessEndpoints(accessEndpoints);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getImageArn() != null) {
            sb.append("ImageArn: ").append(this.getImageArn()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getDisplayName() != null) {
            sb.append("DisplayName: ").append(this.getDisplayName()).append(",");
        }
        if (this.getVpcConfig() != null) {
            sb.append("VpcConfig: ").append(this.getVpcConfig()).append(",");
        }
        if (this.getInstanceType() != null) {
            sb.append("InstanceType: ").append(this.getInstanceType()).append(",");
        }
        if (this.getPlatform() != null) {
            sb.append("Platform: ").append(this.getPlatform()).append(",");
        }
        if (this.getIamRoleArn() != null) {
            sb.append("IamRoleArn: ").append(this.getIamRoleArn()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getStateChangeReason() != null) {
            sb.append("StateChangeReason: ").append(this.getStateChangeReason()).append(",");
        }
        if (this.getCreatedTime() != null) {
            sb.append("CreatedTime: ").append(this.getCreatedTime()).append(",");
        }
        if (this.getEnableDefaultInternetAccess() != null) {
            sb.append("EnableDefaultInternetAccess: ").append(this.getEnableDefaultInternetAccess()).append(",");
        }
        if (this.getDomainJoinInfo() != null) {
            sb.append("DomainJoinInfo: ").append(this.getDomainJoinInfo()).append(",");
        }
        if (this.getNetworkAccessConfiguration() != null) {
            sb.append("NetworkAccessConfiguration: ").append(this.getNetworkAccessConfiguration()).append(",");
        }
        if (this.getImageBuilderErrors() != null) {
            sb.append("ImageBuilderErrors: ").append(this.getImageBuilderErrors()).append(",");
        }
        if (this.getAppstreamAgentVersion() != null) {
            sb.append("AppstreamAgentVersion: ").append(this.getAppstreamAgentVersion()).append(",");
        }
        if (this.getAccessEndpoints() != null) {
            sb.append("AccessEndpoints: ").append(this.getAccessEndpoints());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageBuilder)) {
            return false;
        }
        ImageBuilder other = (ImageBuilder)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getImageArn() == null ^ this.getImageArn() == null) {
            return false;
        }
        if (other.getImageArn() != null && !other.getImageArn().equals(this.getImageArn())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getDisplayName() == null ^ this.getDisplayName() == null) {
            return false;
        }
        if (other.getDisplayName() != null && !other.getDisplayName().equals(this.getDisplayName())) {
            return false;
        }
        if (other.getVpcConfig() == null ^ this.getVpcConfig() == null) {
            return false;
        }
        if (other.getVpcConfig() != null && !other.getVpcConfig().equals(this.getVpcConfig())) {
            return false;
        }
        if (other.getInstanceType() == null ^ this.getInstanceType() == null) {
            return false;
        }
        if (other.getInstanceType() != null && !other.getInstanceType().equals(this.getInstanceType())) {
            return false;
        }
        if (other.getPlatform() == null ^ this.getPlatform() == null) {
            return false;
        }
        if (other.getPlatform() != null && !other.getPlatform().equals(this.getPlatform())) {
            return false;
        }
        if (other.getIamRoleArn() == null ^ this.getIamRoleArn() == null) {
            return false;
        }
        if (other.getIamRoleArn() != null && !other.getIamRoleArn().equals(this.getIamRoleArn())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getStateChangeReason() == null ^ this.getStateChangeReason() == null) {
            return false;
        }
        if (other.getStateChangeReason() != null && !other.getStateChangeReason().equals(this.getStateChangeReason())) {
            return false;
        }
        if (other.getCreatedTime() == null ^ this.getCreatedTime() == null) {
            return false;
        }
        if (other.getCreatedTime() != null && !other.getCreatedTime().equals(this.getCreatedTime())) {
            return false;
        }
        if (other.getEnableDefaultInternetAccess() == null ^ this.getEnableDefaultInternetAccess() == null) {
            return false;
        }
        if (other.getEnableDefaultInternetAccess() != null && !other.getEnableDefaultInternetAccess().equals(this.getEnableDefaultInternetAccess())) {
            return false;
        }
        if (other.getDomainJoinInfo() == null ^ this.getDomainJoinInfo() == null) {
            return false;
        }
        if (other.getDomainJoinInfo() != null && !other.getDomainJoinInfo().equals(this.getDomainJoinInfo())) {
            return false;
        }
        if (other.getNetworkAccessConfiguration() == null ^ this.getNetworkAccessConfiguration() == null) {
            return false;
        }
        if (other.getNetworkAccessConfiguration() != null && !other.getNetworkAccessConfiguration().equals(this.getNetworkAccessConfiguration())) {
            return false;
        }
        if (other.getImageBuilderErrors() == null ^ this.getImageBuilderErrors() == null) {
            return false;
        }
        if (other.getImageBuilderErrors() != null && !other.getImageBuilderErrors().equals(this.getImageBuilderErrors())) {
            return false;
        }
        if (other.getAppstreamAgentVersion() == null ^ this.getAppstreamAgentVersion() == null) {
            return false;
        }
        if (other.getAppstreamAgentVersion() != null && !other.getAppstreamAgentVersion().equals(this.getAppstreamAgentVersion())) {
            return false;
        }
        if (other.getAccessEndpoints() == null ^ this.getAccessEndpoints() == null) {
            return false;
        }
        return other.getAccessEndpoints() == null || other.getAccessEndpoints().equals(this.getAccessEndpoints());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getImageArn() == null ? 0 : this.getImageArn().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getDisplayName() == null ? 0 : this.getDisplayName().hashCode());
        hashCode = 31 * hashCode + (this.getVpcConfig() == null ? 0 : this.getVpcConfig().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceType() == null ? 0 : this.getInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getPlatform() == null ? 0 : this.getPlatform().hashCode());
        hashCode = 31 * hashCode + (this.getIamRoleArn() == null ? 0 : this.getIamRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getStateChangeReason() == null ? 0 : this.getStateChangeReason().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedTime() == null ? 0 : this.getCreatedTime().hashCode());
        hashCode = 31 * hashCode + (this.getEnableDefaultInternetAccess() == null ? 0 : this.getEnableDefaultInternetAccess().hashCode());
        hashCode = 31 * hashCode + (this.getDomainJoinInfo() == null ? 0 : this.getDomainJoinInfo().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkAccessConfiguration() == null ? 0 : this.getNetworkAccessConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getImageBuilderErrors() == null ? 0 : this.getImageBuilderErrors().hashCode());
        hashCode = 31 * hashCode + (this.getAppstreamAgentVersion() == null ? 0 : this.getAppstreamAgentVersion().hashCode());
        hashCode = 31 * hashCode + (this.getAccessEndpoints() == null ? 0 : this.getAccessEndpoints().hashCode());
        return hashCode;
    }

    public ImageBuilder clone() {
        try {
            return (ImageBuilder)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ImageBuilderMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

