/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appstream.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appstream.model.ComputeCapacityStatus;
import com.amazonaws.services.appstream.model.DomainJoinInfo;
import com.amazonaws.services.appstream.model.FleetError;
import com.amazonaws.services.appstream.model.FleetState;
import com.amazonaws.services.appstream.model.FleetType;
import com.amazonaws.services.appstream.model.PlatformType;
import com.amazonaws.services.appstream.model.S3Location;
import com.amazonaws.services.appstream.model.StreamView;
import com.amazonaws.services.appstream.model.VpcConfig;
import com.amazonaws.services.appstream.model.transform.FleetMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Fleet
implements Serializable,
Cloneable,
StructuredPojo {
    private String arn;
    private String name;
    private String displayName;
    private String description;
    private String imageName;
    private String imageArn;
    private String instanceType;
    private String fleetType;
    private ComputeCapacityStatus computeCapacityStatus;
    private Integer maxUserDurationInSeconds;
    private Integer disconnectTimeoutInSeconds;
    private String state;
    private VpcConfig vpcConfig;
    private Date createdTime;
    private List<FleetError> fleetErrors;
    private Boolean enableDefaultInternetAccess;
    private DomainJoinInfo domainJoinInfo;
    private Integer idleDisconnectTimeoutInSeconds;
    private String iamRoleArn;
    private String streamView;
    private String platform;
    private Integer maxConcurrentSessions;
    private List<String> usbDeviceFilterStrings;
    private S3Location sessionScriptS3Location;
    private Integer maxSessionsPerInstance;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public Fleet withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Fleet withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Fleet withDisplayName(String displayName) {
        this.setDisplayName(displayName);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Fleet withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public String getImageName() {
        return this.imageName;
    }

    public Fleet withImageName(String imageName) {
        this.setImageName(imageName);
        return this;
    }

    public void setImageArn(String imageArn) {
        this.imageArn = imageArn;
    }

    public String getImageArn() {
        return this.imageArn;
    }

    public Fleet withImageArn(String imageArn) {
        this.setImageArn(imageArn);
        return this;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public Fleet withInstanceType(String instanceType) {
        this.setInstanceType(instanceType);
        return this;
    }

    public void setFleetType(String fleetType) {
        this.fleetType = fleetType;
    }

    public String getFleetType() {
        return this.fleetType;
    }

    public Fleet withFleetType(String fleetType) {
        this.setFleetType(fleetType);
        return this;
    }

    public void setFleetType(FleetType fleetType) {
        this.withFleetType(fleetType);
    }

    public Fleet withFleetType(FleetType fleetType) {
        this.fleetType = fleetType.toString();
        return this;
    }

    public void setComputeCapacityStatus(ComputeCapacityStatus computeCapacityStatus) {
        this.computeCapacityStatus = computeCapacityStatus;
    }

    public ComputeCapacityStatus getComputeCapacityStatus() {
        return this.computeCapacityStatus;
    }

    public Fleet withComputeCapacityStatus(ComputeCapacityStatus computeCapacityStatus) {
        this.setComputeCapacityStatus(computeCapacityStatus);
        return this;
    }

    public void setMaxUserDurationInSeconds(Integer maxUserDurationInSeconds) {
        this.maxUserDurationInSeconds = maxUserDurationInSeconds;
    }

    public Integer getMaxUserDurationInSeconds() {
        return this.maxUserDurationInSeconds;
    }

    public Fleet withMaxUserDurationInSeconds(Integer maxUserDurationInSeconds) {
        this.setMaxUserDurationInSeconds(maxUserDurationInSeconds);
        return this;
    }

    public void setDisconnectTimeoutInSeconds(Integer disconnectTimeoutInSeconds) {
        this.disconnectTimeoutInSeconds = disconnectTimeoutInSeconds;
    }

    public Integer getDisconnectTimeoutInSeconds() {
        return this.disconnectTimeoutInSeconds;
    }

    public Fleet withDisconnectTimeoutInSeconds(Integer disconnectTimeoutInSeconds) {
        this.setDisconnectTimeoutInSeconds(disconnectTimeoutInSeconds);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public Fleet withState(String state) {
        this.setState(state);
        return this;
    }

    public void setState(FleetState state) {
        this.withState(state);
    }

    public Fleet withState(FleetState state) {
        this.state = state.toString();
        return this;
    }

    public void setVpcConfig(VpcConfig vpcConfig) {
        this.vpcConfig = vpcConfig;
    }

    public VpcConfig getVpcConfig() {
        return this.vpcConfig;
    }

    public Fleet withVpcConfig(VpcConfig vpcConfig) {
        this.setVpcConfig(vpcConfig);
        return this;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public Fleet withCreatedTime(Date createdTime) {
        this.setCreatedTime(createdTime);
        return this;
    }

    public List<FleetError> getFleetErrors() {
        return this.fleetErrors;
    }

    public void setFleetErrors(Collection<FleetError> fleetErrors) {
        if (fleetErrors == null) {
            this.fleetErrors = null;
            return;
        }
        this.fleetErrors = new ArrayList<FleetError>(fleetErrors);
    }

    public Fleet withFleetErrors(FleetError ... fleetErrors) {
        if (this.fleetErrors == null) {
            this.setFleetErrors(new ArrayList<FleetError>(fleetErrors.length));
        }
        for (FleetError ele : fleetErrors) {
            this.fleetErrors.add(ele);
        }
        return this;
    }

    public Fleet withFleetErrors(Collection<FleetError> fleetErrors) {
        this.setFleetErrors(fleetErrors);
        return this;
    }

    public void setEnableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
        this.enableDefaultInternetAccess = enableDefaultInternetAccess;
    }

    public Boolean getEnableDefaultInternetAccess() {
        return this.enableDefaultInternetAccess;
    }

    public Fleet withEnableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
        this.setEnableDefaultInternetAccess(enableDefaultInternetAccess);
        return this;
    }

    public Boolean isEnableDefaultInternetAccess() {
        return this.enableDefaultInternetAccess;
    }

    public void setDomainJoinInfo(DomainJoinInfo domainJoinInfo) {
        this.domainJoinInfo = domainJoinInfo;
    }

    public DomainJoinInfo getDomainJoinInfo() {
        return this.domainJoinInfo;
    }

    public Fleet withDomainJoinInfo(DomainJoinInfo domainJoinInfo) {
        this.setDomainJoinInfo(domainJoinInfo);
        return this;
    }

    public void setIdleDisconnectTimeoutInSeconds(Integer idleDisconnectTimeoutInSeconds) {
        this.idleDisconnectTimeoutInSeconds = idleDisconnectTimeoutInSeconds;
    }

    public Integer getIdleDisconnectTimeoutInSeconds() {
        return this.idleDisconnectTimeoutInSeconds;
    }

    public Fleet withIdleDisconnectTimeoutInSeconds(Integer idleDisconnectTimeoutInSeconds) {
        this.setIdleDisconnectTimeoutInSeconds(idleDisconnectTimeoutInSeconds);
        return this;
    }

    public void setIamRoleArn(String iamRoleArn) {
        this.iamRoleArn = iamRoleArn;
    }

    public String getIamRoleArn() {
        return this.iamRoleArn;
    }

    public Fleet withIamRoleArn(String iamRoleArn) {
        this.setIamRoleArn(iamRoleArn);
        return this;
    }

    public void setStreamView(String streamView) {
        this.streamView = streamView;
    }

    public String getStreamView() {
        return this.streamView;
    }

    public Fleet withStreamView(String streamView) {
        this.setStreamView(streamView);
        return this;
    }

    public void setStreamView(StreamView streamView) {
        this.withStreamView(streamView);
    }

    public Fleet withStreamView(StreamView streamView) {
        this.streamView = streamView.toString();
        return this;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getPlatform() {
        return this.platform;
    }

    public Fleet withPlatform(String platform) {
        this.setPlatform(platform);
        return this;
    }

    public void setPlatform(PlatformType platform) {
        this.withPlatform(platform);
    }

    public Fleet withPlatform(PlatformType platform) {
        this.platform = platform.toString();
        return this;
    }

    public void setMaxConcurrentSessions(Integer maxConcurrentSessions) {
        this.maxConcurrentSessions = maxConcurrentSessions;
    }

    public Integer getMaxConcurrentSessions() {
        return this.maxConcurrentSessions;
    }

    public Fleet withMaxConcurrentSessions(Integer maxConcurrentSessions) {
        this.setMaxConcurrentSessions(maxConcurrentSessions);
        return this;
    }

    public List<String> getUsbDeviceFilterStrings() {
        return this.usbDeviceFilterStrings;
    }

    public void setUsbDeviceFilterStrings(Collection<String> usbDeviceFilterStrings) {
        if (usbDeviceFilterStrings == null) {
            this.usbDeviceFilterStrings = null;
            return;
        }
        this.usbDeviceFilterStrings = new ArrayList<String>(usbDeviceFilterStrings);
    }

    public Fleet withUsbDeviceFilterStrings(String ... usbDeviceFilterStrings) {
        if (this.usbDeviceFilterStrings == null) {
            this.setUsbDeviceFilterStrings(new ArrayList<String>(usbDeviceFilterStrings.length));
        }
        for (String ele : usbDeviceFilterStrings) {
            this.usbDeviceFilterStrings.add(ele);
        }
        return this;
    }

    public Fleet withUsbDeviceFilterStrings(Collection<String> usbDeviceFilterStrings) {
        this.setUsbDeviceFilterStrings(usbDeviceFilterStrings);
        return this;
    }

    public void setSessionScriptS3Location(S3Location sessionScriptS3Location) {
        this.sessionScriptS3Location = sessionScriptS3Location;
    }

    public S3Location getSessionScriptS3Location() {
        return this.sessionScriptS3Location;
    }

    public Fleet withSessionScriptS3Location(S3Location sessionScriptS3Location) {
        this.setSessionScriptS3Location(sessionScriptS3Location);
        return this;
    }

    public void setMaxSessionsPerInstance(Integer maxSessionsPerInstance) {
        this.maxSessionsPerInstance = maxSessionsPerInstance;
    }

    public Integer getMaxSessionsPerInstance() {
        return this.maxSessionsPerInstance;
    }

    public Fleet withMaxSessionsPerInstance(Integer maxSessionsPerInstance) {
        this.setMaxSessionsPerInstance(maxSessionsPerInstance);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDisplayName() != null) {
            sb.append("DisplayName: ").append(this.getDisplayName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getImageName() != null) {
            sb.append("ImageName: ").append(this.getImageName()).append(",");
        }
        if (this.getImageArn() != null) {
            sb.append("ImageArn: ").append(this.getImageArn()).append(",");
        }
        if (this.getInstanceType() != null) {
            sb.append("InstanceType: ").append(this.getInstanceType()).append(",");
        }
        if (this.getFleetType() != null) {
            sb.append("FleetType: ").append(this.getFleetType()).append(",");
        }
        if (this.getComputeCapacityStatus() != null) {
            sb.append("ComputeCapacityStatus: ").append(this.getComputeCapacityStatus()).append(",");
        }
        if (this.getMaxUserDurationInSeconds() != null) {
            sb.append("MaxUserDurationInSeconds: ").append(this.getMaxUserDurationInSeconds()).append(",");
        }
        if (this.getDisconnectTimeoutInSeconds() != null) {
            sb.append("DisconnectTimeoutInSeconds: ").append(this.getDisconnectTimeoutInSeconds()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getVpcConfig() != null) {
            sb.append("VpcConfig: ").append(this.getVpcConfig()).append(",");
        }
        if (this.getCreatedTime() != null) {
            sb.append("CreatedTime: ").append(this.getCreatedTime()).append(",");
        }
        if (this.getFleetErrors() != null) {
            sb.append("FleetErrors: ").append(this.getFleetErrors()).append(",");
        }
        if (this.getEnableDefaultInternetAccess() != null) {
            sb.append("EnableDefaultInternetAccess: ").append(this.getEnableDefaultInternetAccess()).append(",");
        }
        if (this.getDomainJoinInfo() != null) {
            sb.append("DomainJoinInfo: ").append(this.getDomainJoinInfo()).append(",");
        }
        if (this.getIdleDisconnectTimeoutInSeconds() != null) {
            sb.append("IdleDisconnectTimeoutInSeconds: ").append(this.getIdleDisconnectTimeoutInSeconds()).append(",");
        }
        if (this.getIamRoleArn() != null) {
            sb.append("IamRoleArn: ").append(this.getIamRoleArn()).append(",");
        }
        if (this.getStreamView() != null) {
            sb.append("StreamView: ").append(this.getStreamView()).append(",");
        }
        if (this.getPlatform() != null) {
            sb.append("Platform: ").append(this.getPlatform()).append(",");
        }
        if (this.getMaxConcurrentSessions() != null) {
            sb.append("MaxConcurrentSessions: ").append(this.getMaxConcurrentSessions()).append(",");
        }
        if (this.getUsbDeviceFilterStrings() != null) {
            sb.append("UsbDeviceFilterStrings: ").append(this.getUsbDeviceFilterStrings()).append(",");
        }
        if (this.getSessionScriptS3Location() != null) {
            sb.append("SessionScriptS3Location: ").append(this.getSessionScriptS3Location()).append(",");
        }
        if (this.getMaxSessionsPerInstance() != null) {
            sb.append("MaxSessionsPerInstance: ").append(this.getMaxSessionsPerInstance());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Fleet)) {
            return false;
        }
        Fleet other = (Fleet)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDisplayName() == null ^ this.getDisplayName() == null) {
            return false;
        }
        if (other.getDisplayName() != null && !other.getDisplayName().equals(this.getDisplayName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getImageName() == null ^ this.getImageName() == null) {
            return false;
        }
        if (other.getImageName() != null && !other.getImageName().equals(this.getImageName())) {
            return false;
        }
        if (other.getImageArn() == null ^ this.getImageArn() == null) {
            return false;
        }
        if (other.getImageArn() != null && !other.getImageArn().equals(this.getImageArn())) {
            return false;
        }
        if (other.getInstanceType() == null ^ this.getInstanceType() == null) {
            return false;
        }
        if (other.getInstanceType() != null && !other.getInstanceType().equals(this.getInstanceType())) {
            return false;
        }
        if (other.getFleetType() == null ^ this.getFleetType() == null) {
            return false;
        }
        if (other.getFleetType() != null && !other.getFleetType().equals(this.getFleetType())) {
            return false;
        }
        if (other.getComputeCapacityStatus() == null ^ this.getComputeCapacityStatus() == null) {
            return false;
        }
        if (other.getComputeCapacityStatus() != null && !other.getComputeCapacityStatus().equals(this.getComputeCapacityStatus())) {
            return false;
        }
        if (other.getMaxUserDurationInSeconds() == null ^ this.getMaxUserDurationInSeconds() == null) {
            return false;
        }
        if (other.getMaxUserDurationInSeconds() != null && !other.getMaxUserDurationInSeconds().equals(this.getMaxUserDurationInSeconds())) {
            return false;
        }
        if (other.getDisconnectTimeoutInSeconds() == null ^ this.getDisconnectTimeoutInSeconds() == null) {
            return false;
        }
        if (other.getDisconnectTimeoutInSeconds() != null && !other.getDisconnectTimeoutInSeconds().equals(this.getDisconnectTimeoutInSeconds())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getVpcConfig() == null ^ this.getVpcConfig() == null) {
            return false;
        }
        if (other.getVpcConfig() != null && !other.getVpcConfig().equals(this.getVpcConfig())) {
            return false;
        }
        if (other.getCreatedTime() == null ^ this.getCreatedTime() == null) {
            return false;
        }
        if (other.getCreatedTime() != null && !other.getCreatedTime().equals(this.getCreatedTime())) {
            return false;
        }
        if (other.getFleetErrors() == null ^ this.getFleetErrors() == null) {
            return false;
        }
        if (other.getFleetErrors() != null && !other.getFleetErrors().equals(this.getFleetErrors())) {
            return false;
        }
        if (other.getEnableDefaultInternetAccess() == null ^ this.getEnableDefaultInternetAccess() == null) {
            return false;
        }
        if (other.getEnableDefaultInternetAccess() != null && !other.getEnableDefaultInternetAccess().equals(this.getEnableDefaultInternetAccess())) {
            return false;
        }
        if (other.getDomainJoinInfo() == null ^ this.getDomainJoinInfo() == null) {
            return false;
        }
        if (other.getDomainJoinInfo() != null && !other.getDomainJoinInfo().equals(this.getDomainJoinInfo())) {
            return false;
        }
        if (other.getIdleDisconnectTimeoutInSeconds() == null ^ this.getIdleDisconnectTimeoutInSeconds() == null) {
            return false;
        }
        if (other.getIdleDisconnectTimeoutInSeconds() != null && !other.getIdleDisconnectTimeoutInSeconds().equals(this.getIdleDisconnectTimeoutInSeconds())) {
            return false;
        }
        if (other.getIamRoleArn() == null ^ this.getIamRoleArn() == null) {
            return false;
        }
        if (other.getIamRoleArn() != null && !other.getIamRoleArn().equals(this.getIamRoleArn())) {
            return false;
        }
        if (other.getStreamView() == null ^ this.getStreamView() == null) {
            return false;
        }
        if (other.getStreamView() != null && !other.getStreamView().equals(this.getStreamView())) {
            return false;
        }
        if (other.getPlatform() == null ^ this.getPlatform() == null) {
            return false;
        }
        if (other.getPlatform() != null && !other.getPlatform().equals(this.getPlatform())) {
            return false;
        }
        if (other.getMaxConcurrentSessions() == null ^ this.getMaxConcurrentSessions() == null) {
            return false;
        }
        if (other.getMaxConcurrentSessions() != null && !other.getMaxConcurrentSessions().equals(this.getMaxConcurrentSessions())) {
            return false;
        }
        if (other.getUsbDeviceFilterStrings() == null ^ this.getUsbDeviceFilterStrings() == null) {
            return false;
        }
        if (other.getUsbDeviceFilterStrings() != null && !other.getUsbDeviceFilterStrings().equals(this.getUsbDeviceFilterStrings())) {
            return false;
        }
        if (other.getSessionScriptS3Location() == null ^ this.getSessionScriptS3Location() == null) {
            return false;
        }
        if (other.getSessionScriptS3Location() != null && !other.getSessionScriptS3Location().equals(this.getSessionScriptS3Location())) {
            return false;
        }
        if (other.getMaxSessionsPerInstance() == null ^ this.getMaxSessionsPerInstance() == null) {
            return false;
        }
        return other.getMaxSessionsPerInstance() == null || other.getMaxSessionsPerInstance().equals(this.getMaxSessionsPerInstance());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDisplayName() == null ? 0 : this.getDisplayName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getImageName() == null ? 0 : this.getImageName().hashCode());
        hashCode = 31 * hashCode + (this.getImageArn() == null ? 0 : this.getImageArn().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceType() == null ? 0 : this.getInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getFleetType() == null ? 0 : this.getFleetType().hashCode());
        hashCode = 31 * hashCode + (this.getComputeCapacityStatus() == null ? 0 : this.getComputeCapacityStatus().hashCode());
        hashCode = 31 * hashCode + (this.getMaxUserDurationInSeconds() == null ? 0 : this.getMaxUserDurationInSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getDisconnectTimeoutInSeconds() == null ? 0 : this.getDisconnectTimeoutInSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getVpcConfig() == null ? 0 : this.getVpcConfig().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedTime() == null ? 0 : this.getCreatedTime().hashCode());
        hashCode = 31 * hashCode + (this.getFleetErrors() == null ? 0 : this.getFleetErrors().hashCode());
        hashCode = 31 * hashCode + (this.getEnableDefaultInternetAccess() == null ? 0 : this.getEnableDefaultInternetAccess().hashCode());
        hashCode = 31 * hashCode + (this.getDomainJoinInfo() == null ? 0 : this.getDomainJoinInfo().hashCode());
        hashCode = 31 * hashCode + (this.getIdleDisconnectTimeoutInSeconds() == null ? 0 : this.getIdleDisconnectTimeoutInSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getIamRoleArn() == null ? 0 : this.getIamRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getStreamView() == null ? 0 : this.getStreamView().hashCode());
        hashCode = 31 * hashCode + (this.getPlatform() == null ? 0 : this.getPlatform().hashCode());
        hashCode = 31 * hashCode + (this.getMaxConcurrentSessions() == null ? 0 : this.getMaxConcurrentSessions().hashCode());
        hashCode = 31 * hashCode + (this.getUsbDeviceFilterStrings() == null ? 0 : this.getUsbDeviceFilterStrings().hashCode());
        hashCode = 31 * hashCode + (this.getSessionScriptS3Location() == null ? 0 : this.getSessionScriptS3Location().hashCode());
        hashCode = 31 * hashCode + (this.getMaxSessionsPerInstance() == null ? 0 : this.getMaxSessionsPerInstance().hashCode());
        return hashCode;
    }

    public Fleet clone() {
        try {
            return (Fleet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FleetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

