/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.athena.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.athena.model.QueryExecution;
import com.amazonaws.services.athena.model.UnprocessedQueryExecutionId;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchGetQueryExecutionResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<QueryExecution> queryExecutions;
    private List<UnprocessedQueryExecutionId> unprocessedQueryExecutionIds;

    public List<QueryExecution> getQueryExecutions() {
        return this.queryExecutions;
    }

    public void setQueryExecutions(Collection<QueryExecution> queryExecutions) {
        if (queryExecutions == null) {
            this.queryExecutions = null;
            return;
        }
        this.queryExecutions = new ArrayList<QueryExecution>(queryExecutions);
    }

    public BatchGetQueryExecutionResult withQueryExecutions(QueryExecution ... queryExecutions) {
        if (this.queryExecutions == null) {
            this.setQueryExecutions(new ArrayList<QueryExecution>(queryExecutions.length));
        }
        for (QueryExecution ele : queryExecutions) {
            this.queryExecutions.add(ele);
        }
        return this;
    }

    public BatchGetQueryExecutionResult withQueryExecutions(Collection<QueryExecution> queryExecutions) {
        this.setQueryExecutions(queryExecutions);
        return this;
    }

    public List<UnprocessedQueryExecutionId> getUnprocessedQueryExecutionIds() {
        return this.unprocessedQueryExecutionIds;
    }

    public void setUnprocessedQueryExecutionIds(Collection<UnprocessedQueryExecutionId> unprocessedQueryExecutionIds) {
        if (unprocessedQueryExecutionIds == null) {
            this.unprocessedQueryExecutionIds = null;
            return;
        }
        this.unprocessedQueryExecutionIds = new ArrayList<UnprocessedQueryExecutionId>(unprocessedQueryExecutionIds);
    }

    public BatchGetQueryExecutionResult withUnprocessedQueryExecutionIds(UnprocessedQueryExecutionId ... unprocessedQueryExecutionIds) {
        if (this.unprocessedQueryExecutionIds == null) {
            this.setUnprocessedQueryExecutionIds(new ArrayList<UnprocessedQueryExecutionId>(unprocessedQueryExecutionIds.length));
        }
        for (UnprocessedQueryExecutionId ele : unprocessedQueryExecutionIds) {
            this.unprocessedQueryExecutionIds.add(ele);
        }
        return this;
    }

    public BatchGetQueryExecutionResult withUnprocessedQueryExecutionIds(Collection<UnprocessedQueryExecutionId> unprocessedQueryExecutionIds) {
        this.setUnprocessedQueryExecutionIds(unprocessedQueryExecutionIds);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getQueryExecutions() != null) {
            sb.append("QueryExecutions: ").append(this.getQueryExecutions()).append(",");
        }
        if (this.getUnprocessedQueryExecutionIds() != null) {
            sb.append("UnprocessedQueryExecutionIds: ").append(this.getUnprocessedQueryExecutionIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetQueryExecutionResult)) {
            return false;
        }
        BatchGetQueryExecutionResult other = (BatchGetQueryExecutionResult)obj;
        if (other.getQueryExecutions() == null ^ this.getQueryExecutions() == null) {
            return false;
        }
        if (other.getQueryExecutions() != null && !other.getQueryExecutions().equals(this.getQueryExecutions())) {
            return false;
        }
        if (other.getUnprocessedQueryExecutionIds() == null ^ this.getUnprocessedQueryExecutionIds() == null) {
            return false;
        }
        return other.getUnprocessedQueryExecutionIds() == null || other.getUnprocessedQueryExecutionIds().equals(this.getUnprocessedQueryExecutionIds());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getQueryExecutions() == null ? 0 : this.getQueryExecutions().hashCode());
        hashCode = 31 * hashCode + (this.getUnprocessedQueryExecutionIds() == null ? 0 : this.getUnprocessedQueryExecutionIds().hashCode());
        return hashCode;
    }

    public BatchGetQueryExecutionResult clone() {
        try {
            return (BatchGetQueryExecutionResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

