/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.athena;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.athena.AmazonAthenaAsync;
import com.amazonaws.services.athena.AmazonAthenaAsyncClientBuilder;
import com.amazonaws.services.athena.AmazonAthenaClient;
import com.amazonaws.services.athena.model.BatchGetNamedQueryRequest;
import com.amazonaws.services.athena.model.BatchGetNamedQueryResult;
import com.amazonaws.services.athena.model.BatchGetQueryExecutionRequest;
import com.amazonaws.services.athena.model.BatchGetQueryExecutionResult;
import com.amazonaws.services.athena.model.CreateDataCatalogRequest;
import com.amazonaws.services.athena.model.CreateDataCatalogResult;
import com.amazonaws.services.athena.model.CreateNamedQueryRequest;
import com.amazonaws.services.athena.model.CreateNamedQueryResult;
import com.amazonaws.services.athena.model.CreateWorkGroupRequest;
import com.amazonaws.services.athena.model.CreateWorkGroupResult;
import com.amazonaws.services.athena.model.DeleteDataCatalogRequest;
import com.amazonaws.services.athena.model.DeleteDataCatalogResult;
import com.amazonaws.services.athena.model.DeleteNamedQueryRequest;
import com.amazonaws.services.athena.model.DeleteNamedQueryResult;
import com.amazonaws.services.athena.model.DeleteWorkGroupRequest;
import com.amazonaws.services.athena.model.DeleteWorkGroupResult;
import com.amazonaws.services.athena.model.GetDataCatalogRequest;
import com.amazonaws.services.athena.model.GetDataCatalogResult;
import com.amazonaws.services.athena.model.GetDatabaseRequest;
import com.amazonaws.services.athena.model.GetDatabaseResult;
import com.amazonaws.services.athena.model.GetNamedQueryRequest;
import com.amazonaws.services.athena.model.GetNamedQueryResult;
import com.amazonaws.services.athena.model.GetQueryExecutionRequest;
import com.amazonaws.services.athena.model.GetQueryExecutionResult;
import com.amazonaws.services.athena.model.GetQueryResultsRequest;
import com.amazonaws.services.athena.model.GetQueryResultsResult;
import com.amazonaws.services.athena.model.GetTableMetadataRequest;
import com.amazonaws.services.athena.model.GetTableMetadataResult;
import com.amazonaws.services.athena.model.GetWorkGroupRequest;
import com.amazonaws.services.athena.model.GetWorkGroupResult;
import com.amazonaws.services.athena.model.ListDataCatalogsRequest;
import com.amazonaws.services.athena.model.ListDataCatalogsResult;
import com.amazonaws.services.athena.model.ListDatabasesRequest;
import com.amazonaws.services.athena.model.ListDatabasesResult;
import com.amazonaws.services.athena.model.ListNamedQueriesRequest;
import com.amazonaws.services.athena.model.ListNamedQueriesResult;
import com.amazonaws.services.athena.model.ListQueryExecutionsRequest;
import com.amazonaws.services.athena.model.ListQueryExecutionsResult;
import com.amazonaws.services.athena.model.ListTableMetadataRequest;
import com.amazonaws.services.athena.model.ListTableMetadataResult;
import com.amazonaws.services.athena.model.ListTagsForResourceRequest;
import com.amazonaws.services.athena.model.ListTagsForResourceResult;
import com.amazonaws.services.athena.model.ListWorkGroupsRequest;
import com.amazonaws.services.athena.model.ListWorkGroupsResult;
import com.amazonaws.services.athena.model.StartQueryExecutionRequest;
import com.amazonaws.services.athena.model.StartQueryExecutionResult;
import com.amazonaws.services.athena.model.StopQueryExecutionRequest;
import com.amazonaws.services.athena.model.StopQueryExecutionResult;
import com.amazonaws.services.athena.model.TagResourceRequest;
import com.amazonaws.services.athena.model.TagResourceResult;
import com.amazonaws.services.athena.model.UntagResourceRequest;
import com.amazonaws.services.athena.model.UntagResourceResult;
import com.amazonaws.services.athena.model.UpdateDataCatalogRequest;
import com.amazonaws.services.athena.model.UpdateDataCatalogResult;
import com.amazonaws.services.athena.model.UpdateWorkGroupRequest;
import com.amazonaws.services.athena.model.UpdateWorkGroupResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonAthenaAsyncClient
extends AmazonAthenaClient
implements AmazonAthenaAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonAthenaAsyncClientBuilder asyncBuilder() {
        return AmazonAthenaAsyncClientBuilder.standard();
    }

    AmazonAthenaAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonAthenaAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<BatchGetNamedQueryResult> batchGetNamedQueryAsync(BatchGetNamedQueryRequest request) {
        return this.batchGetNamedQueryAsync(request, null);
    }

    @Override
    public Future<BatchGetNamedQueryResult> batchGetNamedQueryAsync(BatchGetNamedQueryRequest request, final AsyncHandler<BatchGetNamedQueryRequest, BatchGetNamedQueryResult> asyncHandler) {
        final BatchGetNamedQueryRequest finalRequest = (BatchGetNamedQueryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchGetNamedQueryResult>(){

            @Override
            public BatchGetNamedQueryResult call() throws Exception {
                BatchGetNamedQueryResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeBatchGetNamedQuery(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchGetQueryExecutionResult> batchGetQueryExecutionAsync(BatchGetQueryExecutionRequest request) {
        return this.batchGetQueryExecutionAsync(request, null);
    }

    @Override
    public Future<BatchGetQueryExecutionResult> batchGetQueryExecutionAsync(BatchGetQueryExecutionRequest request, final AsyncHandler<BatchGetQueryExecutionRequest, BatchGetQueryExecutionResult> asyncHandler) {
        final BatchGetQueryExecutionRequest finalRequest = (BatchGetQueryExecutionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchGetQueryExecutionResult>(){

            @Override
            public BatchGetQueryExecutionResult call() throws Exception {
                BatchGetQueryExecutionResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeBatchGetQueryExecution(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateDataCatalogResult> createDataCatalogAsync(CreateDataCatalogRequest request) {
        return this.createDataCatalogAsync(request, null);
    }

    @Override
    public Future<CreateDataCatalogResult> createDataCatalogAsync(CreateDataCatalogRequest request, final AsyncHandler<CreateDataCatalogRequest, CreateDataCatalogResult> asyncHandler) {
        final CreateDataCatalogRequest finalRequest = (CreateDataCatalogRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateDataCatalogResult>(){

            @Override
            public CreateDataCatalogResult call() throws Exception {
                CreateDataCatalogResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeCreateDataCatalog(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateNamedQueryResult> createNamedQueryAsync(CreateNamedQueryRequest request) {
        return this.createNamedQueryAsync(request, null);
    }

    @Override
    public Future<CreateNamedQueryResult> createNamedQueryAsync(CreateNamedQueryRequest request, final AsyncHandler<CreateNamedQueryRequest, CreateNamedQueryResult> asyncHandler) {
        final CreateNamedQueryRequest finalRequest = (CreateNamedQueryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateNamedQueryResult>(){

            @Override
            public CreateNamedQueryResult call() throws Exception {
                CreateNamedQueryResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeCreateNamedQuery(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateWorkGroupResult> createWorkGroupAsync(CreateWorkGroupRequest request) {
        return this.createWorkGroupAsync(request, null);
    }

    @Override
    public Future<CreateWorkGroupResult> createWorkGroupAsync(CreateWorkGroupRequest request, final AsyncHandler<CreateWorkGroupRequest, CreateWorkGroupResult> asyncHandler) {
        final CreateWorkGroupRequest finalRequest = (CreateWorkGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateWorkGroupResult>(){

            @Override
            public CreateWorkGroupResult call() throws Exception {
                CreateWorkGroupResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeCreateWorkGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDataCatalogResult> deleteDataCatalogAsync(DeleteDataCatalogRequest request) {
        return this.deleteDataCatalogAsync(request, null);
    }

    @Override
    public Future<DeleteDataCatalogResult> deleteDataCatalogAsync(DeleteDataCatalogRequest request, final AsyncHandler<DeleteDataCatalogRequest, DeleteDataCatalogResult> asyncHandler) {
        final DeleteDataCatalogRequest finalRequest = (DeleteDataCatalogRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteDataCatalogResult>(){

            @Override
            public DeleteDataCatalogResult call() throws Exception {
                DeleteDataCatalogResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeDeleteDataCatalog(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteNamedQueryResult> deleteNamedQueryAsync(DeleteNamedQueryRequest request) {
        return this.deleteNamedQueryAsync(request, null);
    }

    @Override
    public Future<DeleteNamedQueryResult> deleteNamedQueryAsync(DeleteNamedQueryRequest request, final AsyncHandler<DeleteNamedQueryRequest, DeleteNamedQueryResult> asyncHandler) {
        final DeleteNamedQueryRequest finalRequest = (DeleteNamedQueryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteNamedQueryResult>(){

            @Override
            public DeleteNamedQueryResult call() throws Exception {
                DeleteNamedQueryResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeDeleteNamedQuery(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteWorkGroupResult> deleteWorkGroupAsync(DeleteWorkGroupRequest request) {
        return this.deleteWorkGroupAsync(request, null);
    }

    @Override
    public Future<DeleteWorkGroupResult> deleteWorkGroupAsync(DeleteWorkGroupRequest request, final AsyncHandler<DeleteWorkGroupRequest, DeleteWorkGroupResult> asyncHandler) {
        final DeleteWorkGroupRequest finalRequest = (DeleteWorkGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteWorkGroupResult>(){

            @Override
            public DeleteWorkGroupResult call() throws Exception {
                DeleteWorkGroupResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeDeleteWorkGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDataCatalogResult> getDataCatalogAsync(GetDataCatalogRequest request) {
        return this.getDataCatalogAsync(request, null);
    }

    @Override
    public Future<GetDataCatalogResult> getDataCatalogAsync(GetDataCatalogRequest request, final AsyncHandler<GetDataCatalogRequest, GetDataCatalogResult> asyncHandler) {
        final GetDataCatalogRequest finalRequest = (GetDataCatalogRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDataCatalogResult>(){

            @Override
            public GetDataCatalogResult call() throws Exception {
                GetDataCatalogResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeGetDataCatalog(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDatabaseResult> getDatabaseAsync(GetDatabaseRequest request) {
        return this.getDatabaseAsync(request, null);
    }

    @Override
    public Future<GetDatabaseResult> getDatabaseAsync(GetDatabaseRequest request, final AsyncHandler<GetDatabaseRequest, GetDatabaseResult> asyncHandler) {
        final GetDatabaseRequest finalRequest = (GetDatabaseRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDatabaseResult>(){

            @Override
            public GetDatabaseResult call() throws Exception {
                GetDatabaseResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeGetDatabase(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetNamedQueryResult> getNamedQueryAsync(GetNamedQueryRequest request) {
        return this.getNamedQueryAsync(request, null);
    }

    @Override
    public Future<GetNamedQueryResult> getNamedQueryAsync(GetNamedQueryRequest request, final AsyncHandler<GetNamedQueryRequest, GetNamedQueryResult> asyncHandler) {
        final GetNamedQueryRequest finalRequest = (GetNamedQueryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetNamedQueryResult>(){

            @Override
            public GetNamedQueryResult call() throws Exception {
                GetNamedQueryResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeGetNamedQuery(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetQueryExecutionResult> getQueryExecutionAsync(GetQueryExecutionRequest request) {
        return this.getQueryExecutionAsync(request, null);
    }

    @Override
    public Future<GetQueryExecutionResult> getQueryExecutionAsync(GetQueryExecutionRequest request, final AsyncHandler<GetQueryExecutionRequest, GetQueryExecutionResult> asyncHandler) {
        final GetQueryExecutionRequest finalRequest = (GetQueryExecutionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetQueryExecutionResult>(){

            @Override
            public GetQueryExecutionResult call() throws Exception {
                GetQueryExecutionResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeGetQueryExecution(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetQueryResultsResult> getQueryResultsAsync(GetQueryResultsRequest request) {
        return this.getQueryResultsAsync(request, null);
    }

    @Override
    public Future<GetQueryResultsResult> getQueryResultsAsync(GetQueryResultsRequest request, final AsyncHandler<GetQueryResultsRequest, GetQueryResultsResult> asyncHandler) {
        final GetQueryResultsRequest finalRequest = (GetQueryResultsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetQueryResultsResult>(){

            @Override
            public GetQueryResultsResult call() throws Exception {
                GetQueryResultsResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeGetQueryResults(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTableMetadataResult> getTableMetadataAsync(GetTableMetadataRequest request) {
        return this.getTableMetadataAsync(request, null);
    }

    @Override
    public Future<GetTableMetadataResult> getTableMetadataAsync(GetTableMetadataRequest request, final AsyncHandler<GetTableMetadataRequest, GetTableMetadataResult> asyncHandler) {
        final GetTableMetadataRequest finalRequest = (GetTableMetadataRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetTableMetadataResult>(){

            @Override
            public GetTableMetadataResult call() throws Exception {
                GetTableMetadataResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeGetTableMetadata(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetWorkGroupResult> getWorkGroupAsync(GetWorkGroupRequest request) {
        return this.getWorkGroupAsync(request, null);
    }

    @Override
    public Future<GetWorkGroupResult> getWorkGroupAsync(GetWorkGroupRequest request, final AsyncHandler<GetWorkGroupRequest, GetWorkGroupResult> asyncHandler) {
        final GetWorkGroupRequest finalRequest = (GetWorkGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetWorkGroupResult>(){

            @Override
            public GetWorkGroupResult call() throws Exception {
                GetWorkGroupResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeGetWorkGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDataCatalogsResult> listDataCatalogsAsync(ListDataCatalogsRequest request) {
        return this.listDataCatalogsAsync(request, null);
    }

    @Override
    public Future<ListDataCatalogsResult> listDataCatalogsAsync(ListDataCatalogsRequest request, final AsyncHandler<ListDataCatalogsRequest, ListDataCatalogsResult> asyncHandler) {
        final ListDataCatalogsRequest finalRequest = (ListDataCatalogsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDataCatalogsResult>(){

            @Override
            public ListDataCatalogsResult call() throws Exception {
                ListDataCatalogsResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeListDataCatalogs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDatabasesResult> listDatabasesAsync(ListDatabasesRequest request) {
        return this.listDatabasesAsync(request, null);
    }

    @Override
    public Future<ListDatabasesResult> listDatabasesAsync(ListDatabasesRequest request, final AsyncHandler<ListDatabasesRequest, ListDatabasesResult> asyncHandler) {
        final ListDatabasesRequest finalRequest = (ListDatabasesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDatabasesResult>(){

            @Override
            public ListDatabasesResult call() throws Exception {
                ListDatabasesResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeListDatabases(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListNamedQueriesResult> listNamedQueriesAsync(ListNamedQueriesRequest request) {
        return this.listNamedQueriesAsync(request, null);
    }

    @Override
    public Future<ListNamedQueriesResult> listNamedQueriesAsync(ListNamedQueriesRequest request, final AsyncHandler<ListNamedQueriesRequest, ListNamedQueriesResult> asyncHandler) {
        final ListNamedQueriesRequest finalRequest = (ListNamedQueriesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListNamedQueriesResult>(){

            @Override
            public ListNamedQueriesResult call() throws Exception {
                ListNamedQueriesResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeListNamedQueries(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListQueryExecutionsResult> listQueryExecutionsAsync(ListQueryExecutionsRequest request) {
        return this.listQueryExecutionsAsync(request, null);
    }

    @Override
    public Future<ListQueryExecutionsResult> listQueryExecutionsAsync(ListQueryExecutionsRequest request, final AsyncHandler<ListQueryExecutionsRequest, ListQueryExecutionsResult> asyncHandler) {
        final ListQueryExecutionsRequest finalRequest = (ListQueryExecutionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListQueryExecutionsResult>(){

            @Override
            public ListQueryExecutionsResult call() throws Exception {
                ListQueryExecutionsResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeListQueryExecutions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTableMetadataResult> listTableMetadataAsync(ListTableMetadataRequest request) {
        return this.listTableMetadataAsync(request, null);
    }

    @Override
    public Future<ListTableMetadataResult> listTableMetadataAsync(ListTableMetadataRequest request, final AsyncHandler<ListTableMetadataRequest, ListTableMetadataResult> asyncHandler) {
        final ListTableMetadataRequest finalRequest = (ListTableMetadataRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTableMetadataResult>(){

            @Override
            public ListTableMetadataResult call() throws Exception {
                ListTableMetadataResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeListTableMetadata(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListWorkGroupsResult> listWorkGroupsAsync(ListWorkGroupsRequest request) {
        return this.listWorkGroupsAsync(request, null);
    }

    @Override
    public Future<ListWorkGroupsResult> listWorkGroupsAsync(ListWorkGroupsRequest request, final AsyncHandler<ListWorkGroupsRequest, ListWorkGroupsResult> asyncHandler) {
        final ListWorkGroupsRequest finalRequest = (ListWorkGroupsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListWorkGroupsResult>(){

            @Override
            public ListWorkGroupsResult call() throws Exception {
                ListWorkGroupsResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeListWorkGroups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartQueryExecutionResult> startQueryExecutionAsync(StartQueryExecutionRequest request) {
        return this.startQueryExecutionAsync(request, null);
    }

    @Override
    public Future<StartQueryExecutionResult> startQueryExecutionAsync(StartQueryExecutionRequest request, final AsyncHandler<StartQueryExecutionRequest, StartQueryExecutionResult> asyncHandler) {
        final StartQueryExecutionRequest finalRequest = (StartQueryExecutionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartQueryExecutionResult>(){

            @Override
            public StartQueryExecutionResult call() throws Exception {
                StartQueryExecutionResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeStartQueryExecution(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopQueryExecutionResult> stopQueryExecutionAsync(StopQueryExecutionRequest request) {
        return this.stopQueryExecutionAsync(request, null);
    }

    @Override
    public Future<StopQueryExecutionResult> stopQueryExecutionAsync(StopQueryExecutionRequest request, final AsyncHandler<StopQueryExecutionRequest, StopQueryExecutionResult> asyncHandler) {
        final StopQueryExecutionRequest finalRequest = (StopQueryExecutionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopQueryExecutionResult>(){

            @Override
            public StopQueryExecutionResult call() throws Exception {
                StopQueryExecutionResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeStopQueryExecution(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateDataCatalogResult> updateDataCatalogAsync(UpdateDataCatalogRequest request) {
        return this.updateDataCatalogAsync(request, null);
    }

    @Override
    public Future<UpdateDataCatalogResult> updateDataCatalogAsync(UpdateDataCatalogRequest request, final AsyncHandler<UpdateDataCatalogRequest, UpdateDataCatalogResult> asyncHandler) {
        final UpdateDataCatalogRequest finalRequest = (UpdateDataCatalogRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateDataCatalogResult>(){

            @Override
            public UpdateDataCatalogResult call() throws Exception {
                UpdateDataCatalogResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeUpdateDataCatalog(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateWorkGroupResult> updateWorkGroupAsync(UpdateWorkGroupRequest request) {
        return this.updateWorkGroupAsync(request, null);
    }

    @Override
    public Future<UpdateWorkGroupResult> updateWorkGroupAsync(UpdateWorkGroupRequest request, final AsyncHandler<UpdateWorkGroupRequest, UpdateWorkGroupResult> asyncHandler) {
        final UpdateWorkGroupRequest finalRequest = (UpdateWorkGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateWorkGroupResult>(){

            @Override
            public UpdateWorkGroupResult call() throws Exception {
                UpdateWorkGroupResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeUpdateWorkGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

