/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.athena.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.athena.model.EncryptionConfiguration;
import com.amazonaws.services.athena.model.transform.ResultConfigurationMarshaller;
import java.io.Serializable;

public class ResultConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String outputLocation;
    private EncryptionConfiguration encryptionConfiguration;
    private String expectedBucketOwner;

    public void setOutputLocation(String outputLocation) {
        this.outputLocation = outputLocation;
    }

    public String getOutputLocation() {
        return this.outputLocation;
    }

    public ResultConfiguration withOutputLocation(String outputLocation) {
        this.setOutputLocation(outputLocation);
        return this;
    }

    public void setEncryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
        this.encryptionConfiguration = encryptionConfiguration;
    }

    public EncryptionConfiguration getEncryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public ResultConfiguration withEncryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
        this.setEncryptionConfiguration(encryptionConfiguration);
        return this;
    }

    public void setExpectedBucketOwner(String expectedBucketOwner) {
        this.expectedBucketOwner = expectedBucketOwner;
    }

    public String getExpectedBucketOwner() {
        return this.expectedBucketOwner;
    }

    public ResultConfiguration withExpectedBucketOwner(String expectedBucketOwner) {
        this.setExpectedBucketOwner(expectedBucketOwner);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOutputLocation() != null) {
            sb.append("OutputLocation: ").append(this.getOutputLocation()).append(",");
        }
        if (this.getEncryptionConfiguration() != null) {
            sb.append("EncryptionConfiguration: ").append(this.getEncryptionConfiguration()).append(",");
        }
        if (this.getExpectedBucketOwner() != null) {
            sb.append("ExpectedBucketOwner: ").append(this.getExpectedBucketOwner());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResultConfiguration)) {
            return false;
        }
        ResultConfiguration other = (ResultConfiguration)obj;
        if (other.getOutputLocation() == null ^ this.getOutputLocation() == null) {
            return false;
        }
        if (other.getOutputLocation() != null && !other.getOutputLocation().equals(this.getOutputLocation())) {
            return false;
        }
        if (other.getEncryptionConfiguration() == null ^ this.getEncryptionConfiguration() == null) {
            return false;
        }
        if (other.getEncryptionConfiguration() != null && !other.getEncryptionConfiguration().equals(this.getEncryptionConfiguration())) {
            return false;
        }
        if (other.getExpectedBucketOwner() == null ^ this.getExpectedBucketOwner() == null) {
            return false;
        }
        return other.getExpectedBucketOwner() == null || other.getExpectedBucketOwner().equals(this.getExpectedBucketOwner());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOutputLocation() == null ? 0 : this.getOutputLocation().hashCode());
        hashCode = 31 * hashCode + (this.getEncryptionConfiguration() == null ? 0 : this.getEncryptionConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getExpectedBucketOwner() == null ? 0 : this.getExpectedBucketOwner().hashCode());
        return hashCode;
    }

    public ResultConfiguration clone() {
        try {
            return (ResultConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResultConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

