/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.athena.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListEngineVersions" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListEngineVersionsResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * A list of engine versions that are available to choose from.
     * </p>
     */
    private java.util.List<EngineVersion> engineVersions;
    /**
     * <p>
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was
     * truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the
     * previous page call.
     * </p>
     */
    private String nextToken;

    /**
     * <p>
     * A list of engine versions that are available to choose from.
     * </p>
     * 
     * @return A list of engine versions that are available to choose from.
     */

    public java.util.List<EngineVersion> getEngineVersions() {
        return engineVersions;
    }

    /**
     * <p>
     * A list of engine versions that are available to choose from.
     * </p>
     * 
     * @param engineVersions
     *        A list of engine versions that are available to choose from.
     */

    public void setEngineVersions(java.util.Collection<EngineVersion> engineVersions) {
        if (engineVersions == null) {
            this.engineVersions = null;
            return;
        }

        this.engineVersions = new java.util.ArrayList<EngineVersion>(engineVersions);
    }

    /**
     * <p>
     * A list of engine versions that are available to choose from.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setEngineVersions(java.util.Collection)} or {@link #withEngineVersions(java.util.Collection)} if you want
     * to override the existing values.
     * </p>
     * 
     * @param engineVersions
     *        A list of engine versions that are available to choose from.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListEngineVersionsResult withEngineVersions(EngineVersion... engineVersions) {
        if (this.engineVersions == null) {
            setEngineVersions(new java.util.ArrayList<EngineVersion>(engineVersions.length));
        }
        for (EngineVersion ele : engineVersions) {
            this.engineVersions.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of engine versions that are available to choose from.
     * </p>
     * 
     * @param engineVersions
     *        A list of engine versions that are available to choose from.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListEngineVersionsResult withEngineVersions(java.util.Collection<EngineVersion> engineVersions) {
        setEngineVersions(engineVersions);
        return this;
    }

    /**
     * <p>
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was
     * truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the
     * previous page call.
     * </p>
     * 
     * @param nextToken
     *        A token generated by the Athena service that specifies where to continue pagination if a previous request
     *        was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response
     *        object of the previous page call.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was
     * truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the
     * previous page call.
     * </p>
     * 
     * @return A token generated by the Athena service that specifies where to continue pagination if a previous request
     *         was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response
     *         object of the previous page call.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was
     * truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the
     * previous page call.
     * </p>
     * 
     * @param nextToken
     *        A token generated by the Athena service that specifies where to continue pagination if a previous request
     *        was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response
     *        object of the previous page call.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListEngineVersionsResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getEngineVersions() != null)
            sb.append("EngineVersions: ").append(getEngineVersions()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListEngineVersionsResult == false)
            return false;
        ListEngineVersionsResult other = (ListEngineVersionsResult) obj;
        if (other.getEngineVersions() == null ^ this.getEngineVersions() == null)
            return false;
        if (other.getEngineVersions() != null && other.getEngineVersions().equals(this.getEngineVersions()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getEngineVersions() == null) ? 0 : getEngineVersions().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public ListEngineVersionsResult clone() {
        try {
            return (ListEngineVersionsResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
