/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.athena.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The configuration information that will be updated for this workgroup, which includes the location in Amazon S3 where
 * query and calculation results are stored, the encryption option, if any, used for query results, whether the Amazon
 * CloudWatch Metrics are enabled for the workgroup, whether the workgroup settings override the client-side settings,
 * and the data usage limit for the amount of bytes scanned per query, if it is specified.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/WorkGroupConfigurationUpdates"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class WorkGroupConfigurationUpdates implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * If set to "true", the settings for the workgroup override client-side settings. If set to "false" client-side
     * settings are used. For more information, see <a
     * href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override
     * Client-Side Settings</a>.
     * </p>
     */
    private Boolean enforceWorkGroupConfiguration;
    /**
     * <p>
     * The result configuration information about the queries in this workgroup that will be updated. Includes the
     * updated results location and an updated option for encrypting query results.
     * </p>
     */
    private ResultConfigurationUpdates resultConfigurationUpdates;
    /**
     * <p>
     * Indicates whether this workgroup enables publishing metrics to Amazon CloudWatch.
     * </p>
     */
    private Boolean publishCloudWatchMetricsEnabled;
    /**
     * <p>
     * The upper limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan.
     * </p>
     */
    private Long bytesScannedCutoffPerQuery;
    /**
     * <p>
     * Indicates that the data usage control limit per query is removed.
     * <a>WorkGroupConfiguration$BytesScannedCutoffPerQuery</a>
     * </p>
     */
    private Boolean removeBytesScannedCutoffPerQuery;
    /**
     * <p>
     * If set to <code>true</code>, allows members assigned to a workgroup to specify Amazon S3 Requester Pays buckets
     * in queries. If set to <code>false</code>, workgroup members cannot query data from Requester Pays buckets, and
     * queries that retrieve data from Requester Pays buckets cause an error. The default is <code>false</code>. For
     * more information about Requester Pays buckets, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html">Requester Pays Buckets</a> in
     * the <i>Amazon Simple Storage Service Developer Guide</i>.
     * </p>
     */
    private Boolean requesterPaysEnabled;
    /**
     * <p>
     * The engine version requested when a workgroup is updated. After the update, all queries on the workgroup run on
     * the requested engine version. If no value was previously set, the default is Auto. Queries on the
     * <code>AmazonAthenaPreviewFunctionality</code> workgroup run on the preview engine regardless of this setting.
     * </p>
     */
    private EngineVersion engineVersion;
    /**
     * <p>
     * Removes content encryption configuration for a workgroup.
     * </p>
     */
    private Boolean removeCustomerContentEncryptionConfiguration;
    /**
     * <p>
     * Contains a user defined string in JSON format for a Spark-enabled workgroup.
     * </p>
     */
    private String additionalConfiguration;
    /**
     * <p>
     * Contains the ARN of the execution role for the workgroup
     * </p>
     */
    private String executionRole;

    private CustomerContentEncryptionConfiguration customerContentEncryptionConfiguration;
    /**
     * <p>
     * Enforces a minimal level of encryption for the workgroup for query and calculation results that are written to
     * Amazon S3. When enabled, workgroup users can set encryption only to the minimum level set by the administrator or
     * higher when they submit queries. This setting does not apply to Spark-enabled workgroups.
     * </p>
     * <p>
     * The <code>EnforceWorkGroupConfiguration</code> setting takes precedence over the
     * <code>EnableMinimumEncryptionConfiguration</code> flag. This means that if
     * <code>EnforceWorkGroupConfiguration</code> is true, the <code>EnableMinimumEncryptionConfiguration</code> flag is
     * ignored, and the workgroup configuration for encryption is used.
     * </p>
     */
    private Boolean enableMinimumEncryptionConfiguration;

    /**
     * <p>
     * If set to "true", the settings for the workgroup override client-side settings. If set to "false" client-side
     * settings are used. For more information, see <a
     * href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override
     * Client-Side Settings</a>.
     * </p>
     * 
     * @param enforceWorkGroupConfiguration
     *        If set to "true", the settings for the workgroup override client-side settings. If set to "false"
     *        client-side settings are used. For more information, see <a
     *        href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings
     *        Override Client-Side Settings</a>.
     */

    public void setEnforceWorkGroupConfiguration(Boolean enforceWorkGroupConfiguration) {
        this.enforceWorkGroupConfiguration = enforceWorkGroupConfiguration;
    }

    /**
     * <p>
     * If set to "true", the settings for the workgroup override client-side settings. If set to "false" client-side
     * settings are used. For more information, see <a
     * href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override
     * Client-Side Settings</a>.
     * </p>
     * 
     * @return If set to "true", the settings for the workgroup override client-side settings. If set to "false"
     *         client-side settings are used. For more information, see <a
     *         href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings
     *         Override Client-Side Settings</a>.
     */

    public Boolean getEnforceWorkGroupConfiguration() {
        return this.enforceWorkGroupConfiguration;
    }

    /**
     * <p>
     * If set to "true", the settings for the workgroup override client-side settings. If set to "false" client-side
     * settings are used. For more information, see <a
     * href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override
     * Client-Side Settings</a>.
     * </p>
     * 
     * @param enforceWorkGroupConfiguration
     *        If set to "true", the settings for the workgroup override client-side settings. If set to "false"
     *        client-side settings are used. For more information, see <a
     *        href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings
     *        Override Client-Side Settings</a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public WorkGroupConfigurationUpdates withEnforceWorkGroupConfiguration(Boolean enforceWorkGroupConfiguration) {
        setEnforceWorkGroupConfiguration(enforceWorkGroupConfiguration);
        return this;
    }

    /**
     * <p>
     * If set to "true", the settings for the workgroup override client-side settings. If set to "false" client-side
     * settings are used. For more information, see <a
     * href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override
     * Client-Side Settings</a>.
     * </p>
     * 
     * @return If set to "true", the settings for the workgroup override client-side settings. If set to "false"
     *         client-side settings are used. For more information, see <a
     *         href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings
     *         Override Client-Side Settings</a>.
     */

    public Boolean isEnforceWorkGroupConfiguration() {
        return this.enforceWorkGroupConfiguration;
    }

    /**
     * <p>
     * The result configuration information about the queries in this workgroup that will be updated. Includes the
     * updated results location and an updated option for encrypting query results.
     * </p>
     * 
     * @param resultConfigurationUpdates
     *        The result configuration information about the queries in this workgroup that will be updated. Includes
     *        the updated results location and an updated option for encrypting query results.
     */

    public void setResultConfigurationUpdates(ResultConfigurationUpdates resultConfigurationUpdates) {
        this.resultConfigurationUpdates = resultConfigurationUpdates;
    }

    /**
     * <p>
     * The result configuration information about the queries in this workgroup that will be updated. Includes the
     * updated results location and an updated option for encrypting query results.
     * </p>
     * 
     * @return The result configuration information about the queries in this workgroup that will be updated. Includes
     *         the updated results location and an updated option for encrypting query results.
     */

    public ResultConfigurationUpdates getResultConfigurationUpdates() {
        return this.resultConfigurationUpdates;
    }

    /**
     * <p>
     * The result configuration information about the queries in this workgroup that will be updated. Includes the
     * updated results location and an updated option for encrypting query results.
     * </p>
     * 
     * @param resultConfigurationUpdates
     *        The result configuration information about the queries in this workgroup that will be updated. Includes
     *        the updated results location and an updated option for encrypting query results.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public WorkGroupConfigurationUpdates withResultConfigurationUpdates(ResultConfigurationUpdates resultConfigurationUpdates) {
        setResultConfigurationUpdates(resultConfigurationUpdates);
        return this;
    }

    /**
     * <p>
     * Indicates whether this workgroup enables publishing metrics to Amazon CloudWatch.
     * </p>
     * 
     * @param publishCloudWatchMetricsEnabled
     *        Indicates whether this workgroup enables publishing metrics to Amazon CloudWatch.
     */

    public void setPublishCloudWatchMetricsEnabled(Boolean publishCloudWatchMetricsEnabled) {
        this.publishCloudWatchMetricsEnabled = publishCloudWatchMetricsEnabled;
    }

    /**
     * <p>
     * Indicates whether this workgroup enables publishing metrics to Amazon CloudWatch.
     * </p>
     * 
     * @return Indicates whether this workgroup enables publishing metrics to Amazon CloudWatch.
     */

    public Boolean getPublishCloudWatchMetricsEnabled() {
        return this.publishCloudWatchMetricsEnabled;
    }

    /**
     * <p>
     * Indicates whether this workgroup enables publishing metrics to Amazon CloudWatch.
     * </p>
     * 
     * @param publishCloudWatchMetricsEnabled
     *        Indicates whether this workgroup enables publishing metrics to Amazon CloudWatch.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public WorkGroupConfigurationUpdates withPublishCloudWatchMetricsEnabled(Boolean publishCloudWatchMetricsEnabled) {
        setPublishCloudWatchMetricsEnabled(publishCloudWatchMetricsEnabled);
        return this;
    }

    /**
     * <p>
     * Indicates whether this workgroup enables publishing metrics to Amazon CloudWatch.
     * </p>
     * 
     * @return Indicates whether this workgroup enables publishing metrics to Amazon CloudWatch.
     */

    public Boolean isPublishCloudWatchMetricsEnabled() {
        return this.publishCloudWatchMetricsEnabled;
    }

    /**
     * <p>
     * The upper limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan.
     * </p>
     * 
     * @param bytesScannedCutoffPerQuery
     *        The upper limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan.
     */

    public void setBytesScannedCutoffPerQuery(Long bytesScannedCutoffPerQuery) {
        this.bytesScannedCutoffPerQuery = bytesScannedCutoffPerQuery;
    }

    /**
     * <p>
     * The upper limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan.
     * </p>
     * 
     * @return The upper limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan.
     */

    public Long getBytesScannedCutoffPerQuery() {
        return this.bytesScannedCutoffPerQuery;
    }

    /**
     * <p>
     * The upper limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan.
     * </p>
     * 
     * @param bytesScannedCutoffPerQuery
     *        The upper limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public WorkGroupConfigurationUpdates withBytesScannedCutoffPerQuery(Long bytesScannedCutoffPerQuery) {
        setBytesScannedCutoffPerQuery(bytesScannedCutoffPerQuery);
        return this;
    }

    /**
     * <p>
     * Indicates that the data usage control limit per query is removed.
     * <a>WorkGroupConfiguration$BytesScannedCutoffPerQuery</a>
     * </p>
     * 
     * @param removeBytesScannedCutoffPerQuery
     *        Indicates that the data usage control limit per query is removed.
     *        <a>WorkGroupConfiguration$BytesScannedCutoffPerQuery</a>
     */

    public void setRemoveBytesScannedCutoffPerQuery(Boolean removeBytesScannedCutoffPerQuery) {
        this.removeBytesScannedCutoffPerQuery = removeBytesScannedCutoffPerQuery;
    }

    /**
     * <p>
     * Indicates that the data usage control limit per query is removed.
     * <a>WorkGroupConfiguration$BytesScannedCutoffPerQuery</a>
     * </p>
     * 
     * @return Indicates that the data usage control limit per query is removed.
     *         <a>WorkGroupConfiguration$BytesScannedCutoffPerQuery</a>
     */

    public Boolean getRemoveBytesScannedCutoffPerQuery() {
        return this.removeBytesScannedCutoffPerQuery;
    }

    /**
     * <p>
     * Indicates that the data usage control limit per query is removed.
     * <a>WorkGroupConfiguration$BytesScannedCutoffPerQuery</a>
     * </p>
     * 
     * @param removeBytesScannedCutoffPerQuery
     *        Indicates that the data usage control limit per query is removed.
     *        <a>WorkGroupConfiguration$BytesScannedCutoffPerQuery</a>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public WorkGroupConfigurationUpdates withRemoveBytesScannedCutoffPerQuery(Boolean removeBytesScannedCutoffPerQuery) {
        setRemoveBytesScannedCutoffPerQuery(removeBytesScannedCutoffPerQuery);
        return this;
    }

    /**
     * <p>
     * Indicates that the data usage control limit per query is removed.
     * <a>WorkGroupConfiguration$BytesScannedCutoffPerQuery</a>
     * </p>
     * 
     * @return Indicates that the data usage control limit per query is removed.
     *         <a>WorkGroupConfiguration$BytesScannedCutoffPerQuery</a>
     */

    public Boolean isRemoveBytesScannedCutoffPerQuery() {
        return this.removeBytesScannedCutoffPerQuery;
    }

    /**
     * <p>
     * If set to <code>true</code>, allows members assigned to a workgroup to specify Amazon S3 Requester Pays buckets
     * in queries. If set to <code>false</code>, workgroup members cannot query data from Requester Pays buckets, and
     * queries that retrieve data from Requester Pays buckets cause an error. The default is <code>false</code>. For
     * more information about Requester Pays buckets, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html">Requester Pays Buckets</a> in
     * the <i>Amazon Simple Storage Service Developer Guide</i>.
     * </p>
     * 
     * @param requesterPaysEnabled
     *        If set to <code>true</code>, allows members assigned to a workgroup to specify Amazon S3 Requester Pays
     *        buckets in queries. If set to <code>false</code>, workgroup members cannot query data from Requester Pays
     *        buckets, and queries that retrieve data from Requester Pays buckets cause an error. The default is
     *        <code>false</code>. For more information about Requester Pays buckets, see <a
     *        href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html">Requester Pays
     *        Buckets</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.
     */

    public void setRequesterPaysEnabled(Boolean requesterPaysEnabled) {
        this.requesterPaysEnabled = requesterPaysEnabled;
    }

    /**
     * <p>
     * If set to <code>true</code>, allows members assigned to a workgroup to specify Amazon S3 Requester Pays buckets
     * in queries. If set to <code>false</code>, workgroup members cannot query data from Requester Pays buckets, and
     * queries that retrieve data from Requester Pays buckets cause an error. The default is <code>false</code>. For
     * more information about Requester Pays buckets, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html">Requester Pays Buckets</a> in
     * the <i>Amazon Simple Storage Service Developer Guide</i>.
     * </p>
     * 
     * @return If set to <code>true</code>, allows members assigned to a workgroup to specify Amazon S3 Requester Pays
     *         buckets in queries. If set to <code>false</code>, workgroup members cannot query data from Requester Pays
     *         buckets, and queries that retrieve data from Requester Pays buckets cause an error. The default is
     *         <code>false</code>. For more information about Requester Pays buckets, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html">Requester Pays
     *         Buckets</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.
     */

    public Boolean getRequesterPaysEnabled() {
        return this.requesterPaysEnabled;
    }

    /**
     * <p>
     * If set to <code>true</code>, allows members assigned to a workgroup to specify Amazon S3 Requester Pays buckets
     * in queries. If set to <code>false</code>, workgroup members cannot query data from Requester Pays buckets, and
     * queries that retrieve data from Requester Pays buckets cause an error. The default is <code>false</code>. For
     * more information about Requester Pays buckets, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html">Requester Pays Buckets</a> in
     * the <i>Amazon Simple Storage Service Developer Guide</i>.
     * </p>
     * 
     * @param requesterPaysEnabled
     *        If set to <code>true</code>, allows members assigned to a workgroup to specify Amazon S3 Requester Pays
     *        buckets in queries. If set to <code>false</code>, workgroup members cannot query data from Requester Pays
     *        buckets, and queries that retrieve data from Requester Pays buckets cause an error. The default is
     *        <code>false</code>. For more information about Requester Pays buckets, see <a
     *        href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html">Requester Pays
     *        Buckets</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public WorkGroupConfigurationUpdates withRequesterPaysEnabled(Boolean requesterPaysEnabled) {
        setRequesterPaysEnabled(requesterPaysEnabled);
        return this;
    }

    /**
     * <p>
     * If set to <code>true</code>, allows members assigned to a workgroup to specify Amazon S3 Requester Pays buckets
     * in queries. If set to <code>false</code>, workgroup members cannot query data from Requester Pays buckets, and
     * queries that retrieve data from Requester Pays buckets cause an error. The default is <code>false</code>. For
     * more information about Requester Pays buckets, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html">Requester Pays Buckets</a> in
     * the <i>Amazon Simple Storage Service Developer Guide</i>.
     * </p>
     * 
     * @return If set to <code>true</code>, allows members assigned to a workgroup to specify Amazon S3 Requester Pays
     *         buckets in queries. If set to <code>false</code>, workgroup members cannot query data from Requester Pays
     *         buckets, and queries that retrieve data from Requester Pays buckets cause an error. The default is
     *         <code>false</code>. For more information about Requester Pays buckets, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html">Requester Pays
     *         Buckets</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.
     */

    public Boolean isRequesterPaysEnabled() {
        return this.requesterPaysEnabled;
    }

    /**
     * <p>
     * The engine version requested when a workgroup is updated. After the update, all queries on the workgroup run on
     * the requested engine version. If no value was previously set, the default is Auto. Queries on the
     * <code>AmazonAthenaPreviewFunctionality</code> workgroup run on the preview engine regardless of this setting.
     * </p>
     * 
     * @param engineVersion
     *        The engine version requested when a workgroup is updated. After the update, all queries on the workgroup
     *        run on the requested engine version. If no value was previously set, the default is Auto. Queries on the
     *        <code>AmazonAthenaPreviewFunctionality</code> workgroup run on the preview engine regardless of this
     *        setting.
     */

    public void setEngineVersion(EngineVersion engineVersion) {
        this.engineVersion = engineVersion;
    }

    /**
     * <p>
     * The engine version requested when a workgroup is updated. After the update, all queries on the workgroup run on
     * the requested engine version. If no value was previously set, the default is Auto. Queries on the
     * <code>AmazonAthenaPreviewFunctionality</code> workgroup run on the preview engine regardless of this setting.
     * </p>
     * 
     * @return The engine version requested when a workgroup is updated. After the update, all queries on the workgroup
     *         run on the requested engine version. If no value was previously set, the default is Auto. Queries on the
     *         <code>AmazonAthenaPreviewFunctionality</code> workgroup run on the preview engine regardless of this
     *         setting.
     */

    public EngineVersion getEngineVersion() {
        return this.engineVersion;
    }

    /**
     * <p>
     * The engine version requested when a workgroup is updated. After the update, all queries on the workgroup run on
     * the requested engine version. If no value was previously set, the default is Auto. Queries on the
     * <code>AmazonAthenaPreviewFunctionality</code> workgroup run on the preview engine regardless of this setting.
     * </p>
     * 
     * @param engineVersion
     *        The engine version requested when a workgroup is updated. After the update, all queries on the workgroup
     *        run on the requested engine version. If no value was previously set, the default is Auto. Queries on the
     *        <code>AmazonAthenaPreviewFunctionality</code> workgroup run on the preview engine regardless of this
     *        setting.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public WorkGroupConfigurationUpdates withEngineVersion(EngineVersion engineVersion) {
        setEngineVersion(engineVersion);
        return this;
    }

    /**
     * <p>
     * Removes content encryption configuration for a workgroup.
     * </p>
     * 
     * @param removeCustomerContentEncryptionConfiguration
     *        Removes content encryption configuration for a workgroup.
     */

    public void setRemoveCustomerContentEncryptionConfiguration(Boolean removeCustomerContentEncryptionConfiguration) {
        this.removeCustomerContentEncryptionConfiguration = removeCustomerContentEncryptionConfiguration;
    }

    /**
     * <p>
     * Removes content encryption configuration for a workgroup.
     * </p>
     * 
     * @return Removes content encryption configuration for a workgroup.
     */

    public Boolean getRemoveCustomerContentEncryptionConfiguration() {
        return this.removeCustomerContentEncryptionConfiguration;
    }

    /**
     * <p>
     * Removes content encryption configuration for a workgroup.
     * </p>
     * 
     * @param removeCustomerContentEncryptionConfiguration
     *        Removes content encryption configuration for a workgroup.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public WorkGroupConfigurationUpdates withRemoveCustomerContentEncryptionConfiguration(Boolean removeCustomerContentEncryptionConfiguration) {
        setRemoveCustomerContentEncryptionConfiguration(removeCustomerContentEncryptionConfiguration);
        return this;
    }

    /**
     * <p>
     * Removes content encryption configuration for a workgroup.
     * </p>
     * 
     * @return Removes content encryption configuration for a workgroup.
     */

    public Boolean isRemoveCustomerContentEncryptionConfiguration() {
        return this.removeCustomerContentEncryptionConfiguration;
    }

    /**
     * <p>
     * Contains a user defined string in JSON format for a Spark-enabled workgroup.
     * </p>
     * 
     * @param additionalConfiguration
     *        Contains a user defined string in JSON format for a Spark-enabled workgroup.
     */

    public void setAdditionalConfiguration(String additionalConfiguration) {
        this.additionalConfiguration = additionalConfiguration;
    }

    /**
     * <p>
     * Contains a user defined string in JSON format for a Spark-enabled workgroup.
     * </p>
     * 
     * @return Contains a user defined string in JSON format for a Spark-enabled workgroup.
     */

    public String getAdditionalConfiguration() {
        return this.additionalConfiguration;
    }

    /**
     * <p>
     * Contains a user defined string in JSON format for a Spark-enabled workgroup.
     * </p>
     * 
     * @param additionalConfiguration
     *        Contains a user defined string in JSON format for a Spark-enabled workgroup.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public WorkGroupConfigurationUpdates withAdditionalConfiguration(String additionalConfiguration) {
        setAdditionalConfiguration(additionalConfiguration);
        return this;
    }

    /**
     * <p>
     * Contains the ARN of the execution role for the workgroup
     * </p>
     * 
     * @param executionRole
     *        Contains the ARN of the execution role for the workgroup
     */

    public void setExecutionRole(String executionRole) {
        this.executionRole = executionRole;
    }

    /**
     * <p>
     * Contains the ARN of the execution role for the workgroup
     * </p>
     * 
     * @return Contains the ARN of the execution role for the workgroup
     */

    public String getExecutionRole() {
        return this.executionRole;
    }

    /**
     * <p>
     * Contains the ARN of the execution role for the workgroup
     * </p>
     * 
     * @param executionRole
     *        Contains the ARN of the execution role for the workgroup
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public WorkGroupConfigurationUpdates withExecutionRole(String executionRole) {
        setExecutionRole(executionRole);
        return this;
    }

    /**
     * @param customerContentEncryptionConfiguration
     */

    public void setCustomerContentEncryptionConfiguration(CustomerContentEncryptionConfiguration customerContentEncryptionConfiguration) {
        this.customerContentEncryptionConfiguration = customerContentEncryptionConfiguration;
    }

    /**
     * @return
     */

    public CustomerContentEncryptionConfiguration getCustomerContentEncryptionConfiguration() {
        return this.customerContentEncryptionConfiguration;
    }

    /**
     * @param customerContentEncryptionConfiguration
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public WorkGroupConfigurationUpdates withCustomerContentEncryptionConfiguration(
            CustomerContentEncryptionConfiguration customerContentEncryptionConfiguration) {
        setCustomerContentEncryptionConfiguration(customerContentEncryptionConfiguration);
        return this;
    }

    /**
     * <p>
     * Enforces a minimal level of encryption for the workgroup for query and calculation results that are written to
     * Amazon S3. When enabled, workgroup users can set encryption only to the minimum level set by the administrator or
     * higher when they submit queries. This setting does not apply to Spark-enabled workgroups.
     * </p>
     * <p>
     * The <code>EnforceWorkGroupConfiguration</code> setting takes precedence over the
     * <code>EnableMinimumEncryptionConfiguration</code> flag. This means that if
     * <code>EnforceWorkGroupConfiguration</code> is true, the <code>EnableMinimumEncryptionConfiguration</code> flag is
     * ignored, and the workgroup configuration for encryption is used.
     * </p>
     * 
     * @param enableMinimumEncryptionConfiguration
     *        Enforces a minimal level of encryption for the workgroup for query and calculation results that are
     *        written to Amazon S3. When enabled, workgroup users can set encryption only to the minimum level set by
     *        the administrator or higher when they submit queries. This setting does not apply to Spark-enabled
     *        workgroups.</p>
     *        <p>
     *        The <code>EnforceWorkGroupConfiguration</code> setting takes precedence over the
     *        <code>EnableMinimumEncryptionConfiguration</code> flag. This means that if
     *        <code>EnforceWorkGroupConfiguration</code> is true, the <code>EnableMinimumEncryptionConfiguration</code>
     *        flag is ignored, and the workgroup configuration for encryption is used.
     */

    public void setEnableMinimumEncryptionConfiguration(Boolean enableMinimumEncryptionConfiguration) {
        this.enableMinimumEncryptionConfiguration = enableMinimumEncryptionConfiguration;
    }

    /**
     * <p>
     * Enforces a minimal level of encryption for the workgroup for query and calculation results that are written to
     * Amazon S3. When enabled, workgroup users can set encryption only to the minimum level set by the administrator or
     * higher when they submit queries. This setting does not apply to Spark-enabled workgroups.
     * </p>
     * <p>
     * The <code>EnforceWorkGroupConfiguration</code> setting takes precedence over the
     * <code>EnableMinimumEncryptionConfiguration</code> flag. This means that if
     * <code>EnforceWorkGroupConfiguration</code> is true, the <code>EnableMinimumEncryptionConfiguration</code> flag is
     * ignored, and the workgroup configuration for encryption is used.
     * </p>
     * 
     * @return Enforces a minimal level of encryption for the workgroup for query and calculation results that are
     *         written to Amazon S3. When enabled, workgroup users can set encryption only to the minimum level set by
     *         the administrator or higher when they submit queries. This setting does not apply to Spark-enabled
     *         workgroups.</p>
     *         <p>
     *         The <code>EnforceWorkGroupConfiguration</code> setting takes precedence over the
     *         <code>EnableMinimumEncryptionConfiguration</code> flag. This means that if
     *         <code>EnforceWorkGroupConfiguration</code> is true, the <code>EnableMinimumEncryptionConfiguration</code>
     *         flag is ignored, and the workgroup configuration for encryption is used.
     */

    public Boolean getEnableMinimumEncryptionConfiguration() {
        return this.enableMinimumEncryptionConfiguration;
    }

    /**
     * <p>
     * Enforces a minimal level of encryption for the workgroup for query and calculation results that are written to
     * Amazon S3. When enabled, workgroup users can set encryption only to the minimum level set by the administrator or
     * higher when they submit queries. This setting does not apply to Spark-enabled workgroups.
     * </p>
     * <p>
     * The <code>EnforceWorkGroupConfiguration</code> setting takes precedence over the
     * <code>EnableMinimumEncryptionConfiguration</code> flag. This means that if
     * <code>EnforceWorkGroupConfiguration</code> is true, the <code>EnableMinimumEncryptionConfiguration</code> flag is
     * ignored, and the workgroup configuration for encryption is used.
     * </p>
     * 
     * @param enableMinimumEncryptionConfiguration
     *        Enforces a minimal level of encryption for the workgroup for query and calculation results that are
     *        written to Amazon S3. When enabled, workgroup users can set encryption only to the minimum level set by
     *        the administrator or higher when they submit queries. This setting does not apply to Spark-enabled
     *        workgroups.</p>
     *        <p>
     *        The <code>EnforceWorkGroupConfiguration</code> setting takes precedence over the
     *        <code>EnableMinimumEncryptionConfiguration</code> flag. This means that if
     *        <code>EnforceWorkGroupConfiguration</code> is true, the <code>EnableMinimumEncryptionConfiguration</code>
     *        flag is ignored, and the workgroup configuration for encryption is used.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public WorkGroupConfigurationUpdates withEnableMinimumEncryptionConfiguration(Boolean enableMinimumEncryptionConfiguration) {
        setEnableMinimumEncryptionConfiguration(enableMinimumEncryptionConfiguration);
        return this;
    }

    /**
     * <p>
     * Enforces a minimal level of encryption for the workgroup for query and calculation results that are written to
     * Amazon S3. When enabled, workgroup users can set encryption only to the minimum level set by the administrator or
     * higher when they submit queries. This setting does not apply to Spark-enabled workgroups.
     * </p>
     * <p>
     * The <code>EnforceWorkGroupConfiguration</code> setting takes precedence over the
     * <code>EnableMinimumEncryptionConfiguration</code> flag. This means that if
     * <code>EnforceWorkGroupConfiguration</code> is true, the <code>EnableMinimumEncryptionConfiguration</code> flag is
     * ignored, and the workgroup configuration for encryption is used.
     * </p>
     * 
     * @return Enforces a minimal level of encryption for the workgroup for query and calculation results that are
     *         written to Amazon S3. When enabled, workgroup users can set encryption only to the minimum level set by
     *         the administrator or higher when they submit queries. This setting does not apply to Spark-enabled
     *         workgroups.</p>
     *         <p>
     *         The <code>EnforceWorkGroupConfiguration</code> setting takes precedence over the
     *         <code>EnableMinimumEncryptionConfiguration</code> flag. This means that if
     *         <code>EnforceWorkGroupConfiguration</code> is true, the <code>EnableMinimumEncryptionConfiguration</code>
     *         flag is ignored, and the workgroup configuration for encryption is used.
     */

    public Boolean isEnableMinimumEncryptionConfiguration() {
        return this.enableMinimumEncryptionConfiguration;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getEnforceWorkGroupConfiguration() != null)
            sb.append("EnforceWorkGroupConfiguration: ").append(getEnforceWorkGroupConfiguration()).append(",");
        if (getResultConfigurationUpdates() != null)
            sb.append("ResultConfigurationUpdates: ").append(getResultConfigurationUpdates()).append(",");
        if (getPublishCloudWatchMetricsEnabled() != null)
            sb.append("PublishCloudWatchMetricsEnabled: ").append(getPublishCloudWatchMetricsEnabled()).append(",");
        if (getBytesScannedCutoffPerQuery() != null)
            sb.append("BytesScannedCutoffPerQuery: ").append(getBytesScannedCutoffPerQuery()).append(",");
        if (getRemoveBytesScannedCutoffPerQuery() != null)
            sb.append("RemoveBytesScannedCutoffPerQuery: ").append(getRemoveBytesScannedCutoffPerQuery()).append(",");
        if (getRequesterPaysEnabled() != null)
            sb.append("RequesterPaysEnabled: ").append(getRequesterPaysEnabled()).append(",");
        if (getEngineVersion() != null)
            sb.append("EngineVersion: ").append(getEngineVersion()).append(",");
        if (getRemoveCustomerContentEncryptionConfiguration() != null)
            sb.append("RemoveCustomerContentEncryptionConfiguration: ").append(getRemoveCustomerContentEncryptionConfiguration()).append(",");
        if (getAdditionalConfiguration() != null)
            sb.append("AdditionalConfiguration: ").append(getAdditionalConfiguration()).append(",");
        if (getExecutionRole() != null)
            sb.append("ExecutionRole: ").append(getExecutionRole()).append(",");
        if (getCustomerContentEncryptionConfiguration() != null)
            sb.append("CustomerContentEncryptionConfiguration: ").append(getCustomerContentEncryptionConfiguration()).append(",");
        if (getEnableMinimumEncryptionConfiguration() != null)
            sb.append("EnableMinimumEncryptionConfiguration: ").append(getEnableMinimumEncryptionConfiguration());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof WorkGroupConfigurationUpdates == false)
            return false;
        WorkGroupConfigurationUpdates other = (WorkGroupConfigurationUpdates) obj;
        if (other.getEnforceWorkGroupConfiguration() == null ^ this.getEnforceWorkGroupConfiguration() == null)
            return false;
        if (other.getEnforceWorkGroupConfiguration() != null
                && other.getEnforceWorkGroupConfiguration().equals(this.getEnforceWorkGroupConfiguration()) == false)
            return false;
        if (other.getResultConfigurationUpdates() == null ^ this.getResultConfigurationUpdates() == null)
            return false;
        if (other.getResultConfigurationUpdates() != null && other.getResultConfigurationUpdates().equals(this.getResultConfigurationUpdates()) == false)
            return false;
        if (other.getPublishCloudWatchMetricsEnabled() == null ^ this.getPublishCloudWatchMetricsEnabled() == null)
            return false;
        if (other.getPublishCloudWatchMetricsEnabled() != null
                && other.getPublishCloudWatchMetricsEnabled().equals(this.getPublishCloudWatchMetricsEnabled()) == false)
            return false;
        if (other.getBytesScannedCutoffPerQuery() == null ^ this.getBytesScannedCutoffPerQuery() == null)
            return false;
        if (other.getBytesScannedCutoffPerQuery() != null && other.getBytesScannedCutoffPerQuery().equals(this.getBytesScannedCutoffPerQuery()) == false)
            return false;
        if (other.getRemoveBytesScannedCutoffPerQuery() == null ^ this.getRemoveBytesScannedCutoffPerQuery() == null)
            return false;
        if (other.getRemoveBytesScannedCutoffPerQuery() != null
                && other.getRemoveBytesScannedCutoffPerQuery().equals(this.getRemoveBytesScannedCutoffPerQuery()) == false)
            return false;
        if (other.getRequesterPaysEnabled() == null ^ this.getRequesterPaysEnabled() == null)
            return false;
        if (other.getRequesterPaysEnabled() != null && other.getRequesterPaysEnabled().equals(this.getRequesterPaysEnabled()) == false)
            return false;
        if (other.getEngineVersion() == null ^ this.getEngineVersion() == null)
            return false;
        if (other.getEngineVersion() != null && other.getEngineVersion().equals(this.getEngineVersion()) == false)
            return false;
        if (other.getRemoveCustomerContentEncryptionConfiguration() == null ^ this.getRemoveCustomerContentEncryptionConfiguration() == null)
            return false;
        if (other.getRemoveCustomerContentEncryptionConfiguration() != null
                && other.getRemoveCustomerContentEncryptionConfiguration().equals(this.getRemoveCustomerContentEncryptionConfiguration()) == false)
            return false;
        if (other.getAdditionalConfiguration() == null ^ this.getAdditionalConfiguration() == null)
            return false;
        if (other.getAdditionalConfiguration() != null && other.getAdditionalConfiguration().equals(this.getAdditionalConfiguration()) == false)
            return false;
        if (other.getExecutionRole() == null ^ this.getExecutionRole() == null)
            return false;
        if (other.getExecutionRole() != null && other.getExecutionRole().equals(this.getExecutionRole()) == false)
            return false;
        if (other.getCustomerContentEncryptionConfiguration() == null ^ this.getCustomerContentEncryptionConfiguration() == null)
            return false;
        if (other.getCustomerContentEncryptionConfiguration() != null
                && other.getCustomerContentEncryptionConfiguration().equals(this.getCustomerContentEncryptionConfiguration()) == false)
            return false;
        if (other.getEnableMinimumEncryptionConfiguration() == null ^ this.getEnableMinimumEncryptionConfiguration() == null)
            return false;
        if (other.getEnableMinimumEncryptionConfiguration() != null
                && other.getEnableMinimumEncryptionConfiguration().equals(this.getEnableMinimumEncryptionConfiguration()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getEnforceWorkGroupConfiguration() == null) ? 0 : getEnforceWorkGroupConfiguration().hashCode());
        hashCode = prime * hashCode + ((getResultConfigurationUpdates() == null) ? 0 : getResultConfigurationUpdates().hashCode());
        hashCode = prime * hashCode + ((getPublishCloudWatchMetricsEnabled() == null) ? 0 : getPublishCloudWatchMetricsEnabled().hashCode());
        hashCode = prime * hashCode + ((getBytesScannedCutoffPerQuery() == null) ? 0 : getBytesScannedCutoffPerQuery().hashCode());
        hashCode = prime * hashCode + ((getRemoveBytesScannedCutoffPerQuery() == null) ? 0 : getRemoveBytesScannedCutoffPerQuery().hashCode());
        hashCode = prime * hashCode + ((getRequesterPaysEnabled() == null) ? 0 : getRequesterPaysEnabled().hashCode());
        hashCode = prime * hashCode + ((getEngineVersion() == null) ? 0 : getEngineVersion().hashCode());
        hashCode = prime * hashCode
                + ((getRemoveCustomerContentEncryptionConfiguration() == null) ? 0 : getRemoveCustomerContentEncryptionConfiguration().hashCode());
        hashCode = prime * hashCode + ((getAdditionalConfiguration() == null) ? 0 : getAdditionalConfiguration().hashCode());
        hashCode = prime * hashCode + ((getExecutionRole() == null) ? 0 : getExecutionRole().hashCode());
        hashCode = prime * hashCode + ((getCustomerContentEncryptionConfiguration() == null) ? 0 : getCustomerContentEncryptionConfiguration().hashCode());
        hashCode = prime * hashCode + ((getEnableMinimumEncryptionConfiguration() == null) ? 0 : getEnableMinimumEncryptionConfiguration().hashCode());
        return hashCode;
    }

    @Override
    public WorkGroupConfigurationUpdates clone() {
        try {
            return (WorkGroupConfigurationUpdates) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.athena.model.transform.WorkGroupConfigurationUpdatesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
