/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.athena;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.athena.AmazonAthenaAsync;
import com.amazonaws.services.athena.AmazonAthenaAsyncClientBuilder;
import com.amazonaws.services.athena.AmazonAthenaClient;
import com.amazonaws.services.athena.model.BatchGetNamedQueryRequest;
import com.amazonaws.services.athena.model.BatchGetNamedQueryResult;
import com.amazonaws.services.athena.model.BatchGetPreparedStatementRequest;
import com.amazonaws.services.athena.model.BatchGetPreparedStatementResult;
import com.amazonaws.services.athena.model.BatchGetQueryExecutionRequest;
import com.amazonaws.services.athena.model.BatchGetQueryExecutionResult;
import com.amazonaws.services.athena.model.CancelCapacityReservationRequest;
import com.amazonaws.services.athena.model.CancelCapacityReservationResult;
import com.amazonaws.services.athena.model.CreateCapacityReservationRequest;
import com.amazonaws.services.athena.model.CreateCapacityReservationResult;
import com.amazonaws.services.athena.model.CreateDataCatalogRequest;
import com.amazonaws.services.athena.model.CreateDataCatalogResult;
import com.amazonaws.services.athena.model.CreateNamedQueryRequest;
import com.amazonaws.services.athena.model.CreateNamedQueryResult;
import com.amazonaws.services.athena.model.CreateNotebookRequest;
import com.amazonaws.services.athena.model.CreateNotebookResult;
import com.amazonaws.services.athena.model.CreatePreparedStatementRequest;
import com.amazonaws.services.athena.model.CreatePreparedStatementResult;
import com.amazonaws.services.athena.model.CreatePresignedNotebookUrlRequest;
import com.amazonaws.services.athena.model.CreatePresignedNotebookUrlResult;
import com.amazonaws.services.athena.model.CreateWorkGroupRequest;
import com.amazonaws.services.athena.model.CreateWorkGroupResult;
import com.amazonaws.services.athena.model.DeleteDataCatalogRequest;
import com.amazonaws.services.athena.model.DeleteDataCatalogResult;
import com.amazonaws.services.athena.model.DeleteNamedQueryRequest;
import com.amazonaws.services.athena.model.DeleteNamedQueryResult;
import com.amazonaws.services.athena.model.DeleteNotebookRequest;
import com.amazonaws.services.athena.model.DeleteNotebookResult;
import com.amazonaws.services.athena.model.DeletePreparedStatementRequest;
import com.amazonaws.services.athena.model.DeletePreparedStatementResult;
import com.amazonaws.services.athena.model.DeleteWorkGroupRequest;
import com.amazonaws.services.athena.model.DeleteWorkGroupResult;
import com.amazonaws.services.athena.model.ExportNotebookRequest;
import com.amazonaws.services.athena.model.ExportNotebookResult;
import com.amazonaws.services.athena.model.GetCalculationExecutionCodeRequest;
import com.amazonaws.services.athena.model.GetCalculationExecutionCodeResult;
import com.amazonaws.services.athena.model.GetCalculationExecutionRequest;
import com.amazonaws.services.athena.model.GetCalculationExecutionResult;
import com.amazonaws.services.athena.model.GetCalculationExecutionStatusRequest;
import com.amazonaws.services.athena.model.GetCalculationExecutionStatusResult;
import com.amazonaws.services.athena.model.GetCapacityAssignmentConfigurationRequest;
import com.amazonaws.services.athena.model.GetCapacityAssignmentConfigurationResult;
import com.amazonaws.services.athena.model.GetCapacityReservationRequest;
import com.amazonaws.services.athena.model.GetCapacityReservationResult;
import com.amazonaws.services.athena.model.GetDataCatalogRequest;
import com.amazonaws.services.athena.model.GetDataCatalogResult;
import com.amazonaws.services.athena.model.GetDatabaseRequest;
import com.amazonaws.services.athena.model.GetDatabaseResult;
import com.amazonaws.services.athena.model.GetNamedQueryRequest;
import com.amazonaws.services.athena.model.GetNamedQueryResult;
import com.amazonaws.services.athena.model.GetNotebookMetadataRequest;
import com.amazonaws.services.athena.model.GetNotebookMetadataResult;
import com.amazonaws.services.athena.model.GetPreparedStatementRequest;
import com.amazonaws.services.athena.model.GetPreparedStatementResult;
import com.amazonaws.services.athena.model.GetQueryExecutionRequest;
import com.amazonaws.services.athena.model.GetQueryExecutionResult;
import com.amazonaws.services.athena.model.GetQueryResultsRequest;
import com.amazonaws.services.athena.model.GetQueryResultsResult;
import com.amazonaws.services.athena.model.GetQueryRuntimeStatisticsRequest;
import com.amazonaws.services.athena.model.GetQueryRuntimeStatisticsResult;
import com.amazonaws.services.athena.model.GetSessionRequest;
import com.amazonaws.services.athena.model.GetSessionResult;
import com.amazonaws.services.athena.model.GetSessionStatusRequest;
import com.amazonaws.services.athena.model.GetSessionStatusResult;
import com.amazonaws.services.athena.model.GetTableMetadataRequest;
import com.amazonaws.services.athena.model.GetTableMetadataResult;
import com.amazonaws.services.athena.model.GetWorkGroupRequest;
import com.amazonaws.services.athena.model.GetWorkGroupResult;
import com.amazonaws.services.athena.model.ImportNotebookRequest;
import com.amazonaws.services.athena.model.ImportNotebookResult;
import com.amazonaws.services.athena.model.ListApplicationDPUSizesRequest;
import com.amazonaws.services.athena.model.ListApplicationDPUSizesResult;
import com.amazonaws.services.athena.model.ListCalculationExecutionsRequest;
import com.amazonaws.services.athena.model.ListCalculationExecutionsResult;
import com.amazonaws.services.athena.model.ListCapacityReservationsRequest;
import com.amazonaws.services.athena.model.ListCapacityReservationsResult;
import com.amazonaws.services.athena.model.ListDataCatalogsRequest;
import com.amazonaws.services.athena.model.ListDataCatalogsResult;
import com.amazonaws.services.athena.model.ListDatabasesRequest;
import com.amazonaws.services.athena.model.ListDatabasesResult;
import com.amazonaws.services.athena.model.ListEngineVersionsRequest;
import com.amazonaws.services.athena.model.ListEngineVersionsResult;
import com.amazonaws.services.athena.model.ListExecutorsRequest;
import com.amazonaws.services.athena.model.ListExecutorsResult;
import com.amazonaws.services.athena.model.ListNamedQueriesRequest;
import com.amazonaws.services.athena.model.ListNamedQueriesResult;
import com.amazonaws.services.athena.model.ListNotebookMetadataRequest;
import com.amazonaws.services.athena.model.ListNotebookMetadataResult;
import com.amazonaws.services.athena.model.ListNotebookSessionsRequest;
import com.amazonaws.services.athena.model.ListNotebookSessionsResult;
import com.amazonaws.services.athena.model.ListPreparedStatementsRequest;
import com.amazonaws.services.athena.model.ListPreparedStatementsResult;
import com.amazonaws.services.athena.model.ListQueryExecutionsRequest;
import com.amazonaws.services.athena.model.ListQueryExecutionsResult;
import com.amazonaws.services.athena.model.ListSessionsRequest;
import com.amazonaws.services.athena.model.ListSessionsResult;
import com.amazonaws.services.athena.model.ListTableMetadataRequest;
import com.amazonaws.services.athena.model.ListTableMetadataResult;
import com.amazonaws.services.athena.model.ListTagsForResourceRequest;
import com.amazonaws.services.athena.model.ListTagsForResourceResult;
import com.amazonaws.services.athena.model.ListWorkGroupsRequest;
import com.amazonaws.services.athena.model.ListWorkGroupsResult;
import com.amazonaws.services.athena.model.PutCapacityAssignmentConfigurationRequest;
import com.amazonaws.services.athena.model.PutCapacityAssignmentConfigurationResult;
import com.amazonaws.services.athena.model.StartCalculationExecutionRequest;
import com.amazonaws.services.athena.model.StartCalculationExecutionResult;
import com.amazonaws.services.athena.model.StartQueryExecutionRequest;
import com.amazonaws.services.athena.model.StartQueryExecutionResult;
import com.amazonaws.services.athena.model.StartSessionRequest;
import com.amazonaws.services.athena.model.StartSessionResult;
import com.amazonaws.services.athena.model.StopCalculationExecutionRequest;
import com.amazonaws.services.athena.model.StopCalculationExecutionResult;
import com.amazonaws.services.athena.model.StopQueryExecutionRequest;
import com.amazonaws.services.athena.model.StopQueryExecutionResult;
import com.amazonaws.services.athena.model.TagResourceRequest;
import com.amazonaws.services.athena.model.TagResourceResult;
import com.amazonaws.services.athena.model.TerminateSessionRequest;
import com.amazonaws.services.athena.model.TerminateSessionResult;
import com.amazonaws.services.athena.model.UntagResourceRequest;
import com.amazonaws.services.athena.model.UntagResourceResult;
import com.amazonaws.services.athena.model.UpdateCapacityReservationRequest;
import com.amazonaws.services.athena.model.UpdateCapacityReservationResult;
import com.amazonaws.services.athena.model.UpdateDataCatalogRequest;
import com.amazonaws.services.athena.model.UpdateDataCatalogResult;
import com.amazonaws.services.athena.model.UpdateNamedQueryRequest;
import com.amazonaws.services.athena.model.UpdateNamedQueryResult;
import com.amazonaws.services.athena.model.UpdateNotebookMetadataRequest;
import com.amazonaws.services.athena.model.UpdateNotebookMetadataResult;
import com.amazonaws.services.athena.model.UpdateNotebookRequest;
import com.amazonaws.services.athena.model.UpdateNotebookResult;
import com.amazonaws.services.athena.model.UpdatePreparedStatementRequest;
import com.amazonaws.services.athena.model.UpdatePreparedStatementResult;
import com.amazonaws.services.athena.model.UpdateWorkGroupRequest;
import com.amazonaws.services.athena.model.UpdateWorkGroupResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonAthenaAsyncClient
extends AmazonAthenaClient
implements AmazonAthenaAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonAthenaAsyncClientBuilder asyncBuilder() {
        return AmazonAthenaAsyncClientBuilder.standard();
    }

    AmazonAthenaAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonAthenaAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<BatchGetNamedQueryResult> batchGetNamedQueryAsync(BatchGetNamedQueryRequest request) {
        return this.batchGetNamedQueryAsync(request, null);
    }

    @Override
    public Future<BatchGetNamedQueryResult> batchGetNamedQueryAsync(BatchGetNamedQueryRequest request, final AsyncHandler<BatchGetNamedQueryRequest, BatchGetNamedQueryResult> asyncHandler) {
        final BatchGetNamedQueryRequest finalRequest = (BatchGetNamedQueryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchGetNamedQueryResult>(){

            @Override
            public BatchGetNamedQueryResult call() throws Exception {
                BatchGetNamedQueryResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeBatchGetNamedQuery(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchGetPreparedStatementResult> batchGetPreparedStatementAsync(BatchGetPreparedStatementRequest request) {
        return this.batchGetPreparedStatementAsync(request, null);
    }

    @Override
    public Future<BatchGetPreparedStatementResult> batchGetPreparedStatementAsync(BatchGetPreparedStatementRequest request, final AsyncHandler<BatchGetPreparedStatementRequest, BatchGetPreparedStatementResult> asyncHandler) {
        final BatchGetPreparedStatementRequest finalRequest = (BatchGetPreparedStatementRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchGetPreparedStatementResult>(){

            @Override
            public BatchGetPreparedStatementResult call() throws Exception {
                BatchGetPreparedStatementResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeBatchGetPreparedStatement(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchGetQueryExecutionResult> batchGetQueryExecutionAsync(BatchGetQueryExecutionRequest request) {
        return this.batchGetQueryExecutionAsync(request, null);
    }

    @Override
    public Future<BatchGetQueryExecutionResult> batchGetQueryExecutionAsync(BatchGetQueryExecutionRequest request, final AsyncHandler<BatchGetQueryExecutionRequest, BatchGetQueryExecutionResult> asyncHandler) {
        final BatchGetQueryExecutionRequest finalRequest = (BatchGetQueryExecutionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchGetQueryExecutionResult>(){

            @Override
            public BatchGetQueryExecutionResult call() throws Exception {
                BatchGetQueryExecutionResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeBatchGetQueryExecution(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CancelCapacityReservationResult> cancelCapacityReservationAsync(CancelCapacityReservationRequest request) {
        return this.cancelCapacityReservationAsync(request, null);
    }

    @Override
    public Future<CancelCapacityReservationResult> cancelCapacityReservationAsync(CancelCapacityReservationRequest request, final AsyncHandler<CancelCapacityReservationRequest, CancelCapacityReservationResult> asyncHandler) {
        final CancelCapacityReservationRequest finalRequest = (CancelCapacityReservationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CancelCapacityReservationResult>(){

            @Override
            public CancelCapacityReservationResult call() throws Exception {
                CancelCapacityReservationResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeCancelCapacityReservation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateCapacityReservationResult> createCapacityReservationAsync(CreateCapacityReservationRequest request) {
        return this.createCapacityReservationAsync(request, null);
    }

    @Override
    public Future<CreateCapacityReservationResult> createCapacityReservationAsync(CreateCapacityReservationRequest request, final AsyncHandler<CreateCapacityReservationRequest, CreateCapacityReservationResult> asyncHandler) {
        final CreateCapacityReservationRequest finalRequest = (CreateCapacityReservationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateCapacityReservationResult>(){

            @Override
            public CreateCapacityReservationResult call() throws Exception {
                CreateCapacityReservationResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeCreateCapacityReservation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateDataCatalogResult> createDataCatalogAsync(CreateDataCatalogRequest request) {
        return this.createDataCatalogAsync(request, null);
    }

    @Override
    public Future<CreateDataCatalogResult> createDataCatalogAsync(CreateDataCatalogRequest request, final AsyncHandler<CreateDataCatalogRequest, CreateDataCatalogResult> asyncHandler) {
        final CreateDataCatalogRequest finalRequest = (CreateDataCatalogRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateDataCatalogResult>(){

            @Override
            public CreateDataCatalogResult call() throws Exception {
                CreateDataCatalogResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeCreateDataCatalog(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateNamedQueryResult> createNamedQueryAsync(CreateNamedQueryRequest request) {
        return this.createNamedQueryAsync(request, null);
    }

    @Override
    public Future<CreateNamedQueryResult> createNamedQueryAsync(CreateNamedQueryRequest request, final AsyncHandler<CreateNamedQueryRequest, CreateNamedQueryResult> asyncHandler) {
        final CreateNamedQueryRequest finalRequest = (CreateNamedQueryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateNamedQueryResult>(){

            @Override
            public CreateNamedQueryResult call() throws Exception {
                CreateNamedQueryResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeCreateNamedQuery(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateNotebookResult> createNotebookAsync(CreateNotebookRequest request) {
        return this.createNotebookAsync(request, null);
    }

    @Override
    public Future<CreateNotebookResult> createNotebookAsync(CreateNotebookRequest request, final AsyncHandler<CreateNotebookRequest, CreateNotebookResult> asyncHandler) {
        final CreateNotebookRequest finalRequest = (CreateNotebookRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateNotebookResult>(){

            @Override
            public CreateNotebookResult call() throws Exception {
                CreateNotebookResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeCreateNotebook(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreatePreparedStatementResult> createPreparedStatementAsync(CreatePreparedStatementRequest request) {
        return this.createPreparedStatementAsync(request, null);
    }

    @Override
    public Future<CreatePreparedStatementResult> createPreparedStatementAsync(CreatePreparedStatementRequest request, final AsyncHandler<CreatePreparedStatementRequest, CreatePreparedStatementResult> asyncHandler) {
        final CreatePreparedStatementRequest finalRequest = (CreatePreparedStatementRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreatePreparedStatementResult>(){

            @Override
            public CreatePreparedStatementResult call() throws Exception {
                CreatePreparedStatementResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeCreatePreparedStatement(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreatePresignedNotebookUrlResult> createPresignedNotebookUrlAsync(CreatePresignedNotebookUrlRequest request) {
        return this.createPresignedNotebookUrlAsync(request, null);
    }

    @Override
    public Future<CreatePresignedNotebookUrlResult> createPresignedNotebookUrlAsync(CreatePresignedNotebookUrlRequest request, final AsyncHandler<CreatePresignedNotebookUrlRequest, CreatePresignedNotebookUrlResult> asyncHandler) {
        final CreatePresignedNotebookUrlRequest finalRequest = (CreatePresignedNotebookUrlRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreatePresignedNotebookUrlResult>(){

            @Override
            public CreatePresignedNotebookUrlResult call() throws Exception {
                CreatePresignedNotebookUrlResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeCreatePresignedNotebookUrl(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateWorkGroupResult> createWorkGroupAsync(CreateWorkGroupRequest request) {
        return this.createWorkGroupAsync(request, null);
    }

    @Override
    public Future<CreateWorkGroupResult> createWorkGroupAsync(CreateWorkGroupRequest request, final AsyncHandler<CreateWorkGroupRequest, CreateWorkGroupResult> asyncHandler) {
        final CreateWorkGroupRequest finalRequest = (CreateWorkGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateWorkGroupResult>(){

            @Override
            public CreateWorkGroupResult call() throws Exception {
                CreateWorkGroupResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeCreateWorkGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDataCatalogResult> deleteDataCatalogAsync(DeleteDataCatalogRequest request) {
        return this.deleteDataCatalogAsync(request, null);
    }

    @Override
    public Future<DeleteDataCatalogResult> deleteDataCatalogAsync(DeleteDataCatalogRequest request, final AsyncHandler<DeleteDataCatalogRequest, DeleteDataCatalogResult> asyncHandler) {
        final DeleteDataCatalogRequest finalRequest = (DeleteDataCatalogRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteDataCatalogResult>(){

            @Override
            public DeleteDataCatalogResult call() throws Exception {
                DeleteDataCatalogResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeDeleteDataCatalog(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteNamedQueryResult> deleteNamedQueryAsync(DeleteNamedQueryRequest request) {
        return this.deleteNamedQueryAsync(request, null);
    }

    @Override
    public Future<DeleteNamedQueryResult> deleteNamedQueryAsync(DeleteNamedQueryRequest request, final AsyncHandler<DeleteNamedQueryRequest, DeleteNamedQueryResult> asyncHandler) {
        final DeleteNamedQueryRequest finalRequest = (DeleteNamedQueryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteNamedQueryResult>(){

            @Override
            public DeleteNamedQueryResult call() throws Exception {
                DeleteNamedQueryResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeDeleteNamedQuery(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteNotebookResult> deleteNotebookAsync(DeleteNotebookRequest request) {
        return this.deleteNotebookAsync(request, null);
    }

    @Override
    public Future<DeleteNotebookResult> deleteNotebookAsync(DeleteNotebookRequest request, final AsyncHandler<DeleteNotebookRequest, DeleteNotebookResult> asyncHandler) {
        final DeleteNotebookRequest finalRequest = (DeleteNotebookRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteNotebookResult>(){

            @Override
            public DeleteNotebookResult call() throws Exception {
                DeleteNotebookResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeDeleteNotebook(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeletePreparedStatementResult> deletePreparedStatementAsync(DeletePreparedStatementRequest request) {
        return this.deletePreparedStatementAsync(request, null);
    }

    @Override
    public Future<DeletePreparedStatementResult> deletePreparedStatementAsync(DeletePreparedStatementRequest request, final AsyncHandler<DeletePreparedStatementRequest, DeletePreparedStatementResult> asyncHandler) {
        final DeletePreparedStatementRequest finalRequest = (DeletePreparedStatementRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeletePreparedStatementResult>(){

            @Override
            public DeletePreparedStatementResult call() throws Exception {
                DeletePreparedStatementResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeDeletePreparedStatement(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteWorkGroupResult> deleteWorkGroupAsync(DeleteWorkGroupRequest request) {
        return this.deleteWorkGroupAsync(request, null);
    }

    @Override
    public Future<DeleteWorkGroupResult> deleteWorkGroupAsync(DeleteWorkGroupRequest request, final AsyncHandler<DeleteWorkGroupRequest, DeleteWorkGroupResult> asyncHandler) {
        final DeleteWorkGroupRequest finalRequest = (DeleteWorkGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteWorkGroupResult>(){

            @Override
            public DeleteWorkGroupResult call() throws Exception {
                DeleteWorkGroupResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeDeleteWorkGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ExportNotebookResult> exportNotebookAsync(ExportNotebookRequest request) {
        return this.exportNotebookAsync(request, null);
    }

    @Override
    public Future<ExportNotebookResult> exportNotebookAsync(ExportNotebookRequest request, final AsyncHandler<ExportNotebookRequest, ExportNotebookResult> asyncHandler) {
        final ExportNotebookRequest finalRequest = (ExportNotebookRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ExportNotebookResult>(){

            @Override
            public ExportNotebookResult call() throws Exception {
                ExportNotebookResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeExportNotebook(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCalculationExecutionResult> getCalculationExecutionAsync(GetCalculationExecutionRequest request) {
        return this.getCalculationExecutionAsync(request, null);
    }

    @Override
    public Future<GetCalculationExecutionResult> getCalculationExecutionAsync(GetCalculationExecutionRequest request, final AsyncHandler<GetCalculationExecutionRequest, GetCalculationExecutionResult> asyncHandler) {
        final GetCalculationExecutionRequest finalRequest = (GetCalculationExecutionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetCalculationExecutionResult>(){

            @Override
            public GetCalculationExecutionResult call() throws Exception {
                GetCalculationExecutionResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeGetCalculationExecution(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCalculationExecutionCodeResult> getCalculationExecutionCodeAsync(GetCalculationExecutionCodeRequest request) {
        return this.getCalculationExecutionCodeAsync(request, null);
    }

    @Override
    public Future<GetCalculationExecutionCodeResult> getCalculationExecutionCodeAsync(GetCalculationExecutionCodeRequest request, final AsyncHandler<GetCalculationExecutionCodeRequest, GetCalculationExecutionCodeResult> asyncHandler) {
        final GetCalculationExecutionCodeRequest finalRequest = (GetCalculationExecutionCodeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetCalculationExecutionCodeResult>(){

            @Override
            public GetCalculationExecutionCodeResult call() throws Exception {
                GetCalculationExecutionCodeResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeGetCalculationExecutionCode(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCalculationExecutionStatusResult> getCalculationExecutionStatusAsync(GetCalculationExecutionStatusRequest request) {
        return this.getCalculationExecutionStatusAsync(request, null);
    }

    @Override
    public Future<GetCalculationExecutionStatusResult> getCalculationExecutionStatusAsync(GetCalculationExecutionStatusRequest request, final AsyncHandler<GetCalculationExecutionStatusRequest, GetCalculationExecutionStatusResult> asyncHandler) {
        final GetCalculationExecutionStatusRequest finalRequest = (GetCalculationExecutionStatusRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetCalculationExecutionStatusResult>(){

            @Override
            public GetCalculationExecutionStatusResult call() throws Exception {
                GetCalculationExecutionStatusResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeGetCalculationExecutionStatus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCapacityAssignmentConfigurationResult> getCapacityAssignmentConfigurationAsync(GetCapacityAssignmentConfigurationRequest request) {
        return this.getCapacityAssignmentConfigurationAsync(request, null);
    }

    @Override
    public Future<GetCapacityAssignmentConfigurationResult> getCapacityAssignmentConfigurationAsync(GetCapacityAssignmentConfigurationRequest request, final AsyncHandler<GetCapacityAssignmentConfigurationRequest, GetCapacityAssignmentConfigurationResult> asyncHandler) {
        final GetCapacityAssignmentConfigurationRequest finalRequest = (GetCapacityAssignmentConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetCapacityAssignmentConfigurationResult>(){

            @Override
            public GetCapacityAssignmentConfigurationResult call() throws Exception {
                GetCapacityAssignmentConfigurationResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeGetCapacityAssignmentConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCapacityReservationResult> getCapacityReservationAsync(GetCapacityReservationRequest request) {
        return this.getCapacityReservationAsync(request, null);
    }

    @Override
    public Future<GetCapacityReservationResult> getCapacityReservationAsync(GetCapacityReservationRequest request, final AsyncHandler<GetCapacityReservationRequest, GetCapacityReservationResult> asyncHandler) {
        final GetCapacityReservationRequest finalRequest = (GetCapacityReservationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetCapacityReservationResult>(){

            @Override
            public GetCapacityReservationResult call() throws Exception {
                GetCapacityReservationResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeGetCapacityReservation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDataCatalogResult> getDataCatalogAsync(GetDataCatalogRequest request) {
        return this.getDataCatalogAsync(request, null);
    }

    @Override
    public Future<GetDataCatalogResult> getDataCatalogAsync(GetDataCatalogRequest request, final AsyncHandler<GetDataCatalogRequest, GetDataCatalogResult> asyncHandler) {
        final GetDataCatalogRequest finalRequest = (GetDataCatalogRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDataCatalogResult>(){

            @Override
            public GetDataCatalogResult call() throws Exception {
                GetDataCatalogResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeGetDataCatalog(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDatabaseResult> getDatabaseAsync(GetDatabaseRequest request) {
        return this.getDatabaseAsync(request, null);
    }

    @Override
    public Future<GetDatabaseResult> getDatabaseAsync(GetDatabaseRequest request, final AsyncHandler<GetDatabaseRequest, GetDatabaseResult> asyncHandler) {
        final GetDatabaseRequest finalRequest = (GetDatabaseRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDatabaseResult>(){

            @Override
            public GetDatabaseResult call() throws Exception {
                GetDatabaseResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeGetDatabase(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetNamedQueryResult> getNamedQueryAsync(GetNamedQueryRequest request) {
        return this.getNamedQueryAsync(request, null);
    }

    @Override
    public Future<GetNamedQueryResult> getNamedQueryAsync(GetNamedQueryRequest request, final AsyncHandler<GetNamedQueryRequest, GetNamedQueryResult> asyncHandler) {
        final GetNamedQueryRequest finalRequest = (GetNamedQueryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetNamedQueryResult>(){

            @Override
            public GetNamedQueryResult call() throws Exception {
                GetNamedQueryResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeGetNamedQuery(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetNotebookMetadataResult> getNotebookMetadataAsync(GetNotebookMetadataRequest request) {
        return this.getNotebookMetadataAsync(request, null);
    }

    @Override
    public Future<GetNotebookMetadataResult> getNotebookMetadataAsync(GetNotebookMetadataRequest request, final AsyncHandler<GetNotebookMetadataRequest, GetNotebookMetadataResult> asyncHandler) {
        final GetNotebookMetadataRequest finalRequest = (GetNotebookMetadataRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetNotebookMetadataResult>(){

            @Override
            public GetNotebookMetadataResult call() throws Exception {
                GetNotebookMetadataResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeGetNotebookMetadata(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetPreparedStatementResult> getPreparedStatementAsync(GetPreparedStatementRequest request) {
        return this.getPreparedStatementAsync(request, null);
    }

    @Override
    public Future<GetPreparedStatementResult> getPreparedStatementAsync(GetPreparedStatementRequest request, final AsyncHandler<GetPreparedStatementRequest, GetPreparedStatementResult> asyncHandler) {
        final GetPreparedStatementRequest finalRequest = (GetPreparedStatementRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetPreparedStatementResult>(){

            @Override
            public GetPreparedStatementResult call() throws Exception {
                GetPreparedStatementResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeGetPreparedStatement(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetQueryExecutionResult> getQueryExecutionAsync(GetQueryExecutionRequest request) {
        return this.getQueryExecutionAsync(request, null);
    }

    @Override
    public Future<GetQueryExecutionResult> getQueryExecutionAsync(GetQueryExecutionRequest request, final AsyncHandler<GetQueryExecutionRequest, GetQueryExecutionResult> asyncHandler) {
        final GetQueryExecutionRequest finalRequest = (GetQueryExecutionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetQueryExecutionResult>(){

            @Override
            public GetQueryExecutionResult call() throws Exception {
                GetQueryExecutionResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeGetQueryExecution(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetQueryResultsResult> getQueryResultsAsync(GetQueryResultsRequest request) {
        return this.getQueryResultsAsync(request, null);
    }

    @Override
    public Future<GetQueryResultsResult> getQueryResultsAsync(GetQueryResultsRequest request, final AsyncHandler<GetQueryResultsRequest, GetQueryResultsResult> asyncHandler) {
        final GetQueryResultsRequest finalRequest = (GetQueryResultsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetQueryResultsResult>(){

            @Override
            public GetQueryResultsResult call() throws Exception {
                GetQueryResultsResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeGetQueryResults(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetQueryRuntimeStatisticsResult> getQueryRuntimeStatisticsAsync(GetQueryRuntimeStatisticsRequest request) {
        return this.getQueryRuntimeStatisticsAsync(request, null);
    }

    @Override
    public Future<GetQueryRuntimeStatisticsResult> getQueryRuntimeStatisticsAsync(GetQueryRuntimeStatisticsRequest request, final AsyncHandler<GetQueryRuntimeStatisticsRequest, GetQueryRuntimeStatisticsResult> asyncHandler) {
        final GetQueryRuntimeStatisticsRequest finalRequest = (GetQueryRuntimeStatisticsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetQueryRuntimeStatisticsResult>(){

            @Override
            public GetQueryRuntimeStatisticsResult call() throws Exception {
                GetQueryRuntimeStatisticsResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeGetQueryRuntimeStatistics(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSessionResult> getSessionAsync(GetSessionRequest request) {
        return this.getSessionAsync(request, null);
    }

    @Override
    public Future<GetSessionResult> getSessionAsync(GetSessionRequest request, final AsyncHandler<GetSessionRequest, GetSessionResult> asyncHandler) {
        final GetSessionRequest finalRequest = (GetSessionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSessionResult>(){

            @Override
            public GetSessionResult call() throws Exception {
                GetSessionResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeGetSession(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSessionStatusResult> getSessionStatusAsync(GetSessionStatusRequest request) {
        return this.getSessionStatusAsync(request, null);
    }

    @Override
    public Future<GetSessionStatusResult> getSessionStatusAsync(GetSessionStatusRequest request, final AsyncHandler<GetSessionStatusRequest, GetSessionStatusResult> asyncHandler) {
        final GetSessionStatusRequest finalRequest = (GetSessionStatusRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSessionStatusResult>(){

            @Override
            public GetSessionStatusResult call() throws Exception {
                GetSessionStatusResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeGetSessionStatus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTableMetadataResult> getTableMetadataAsync(GetTableMetadataRequest request) {
        return this.getTableMetadataAsync(request, null);
    }

    @Override
    public Future<GetTableMetadataResult> getTableMetadataAsync(GetTableMetadataRequest request, final AsyncHandler<GetTableMetadataRequest, GetTableMetadataResult> asyncHandler) {
        final GetTableMetadataRequest finalRequest = (GetTableMetadataRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetTableMetadataResult>(){

            @Override
            public GetTableMetadataResult call() throws Exception {
                GetTableMetadataResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeGetTableMetadata(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetWorkGroupResult> getWorkGroupAsync(GetWorkGroupRequest request) {
        return this.getWorkGroupAsync(request, null);
    }

    @Override
    public Future<GetWorkGroupResult> getWorkGroupAsync(GetWorkGroupRequest request, final AsyncHandler<GetWorkGroupRequest, GetWorkGroupResult> asyncHandler) {
        final GetWorkGroupRequest finalRequest = (GetWorkGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetWorkGroupResult>(){

            @Override
            public GetWorkGroupResult call() throws Exception {
                GetWorkGroupResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeGetWorkGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ImportNotebookResult> importNotebookAsync(ImportNotebookRequest request) {
        return this.importNotebookAsync(request, null);
    }

    @Override
    public Future<ImportNotebookResult> importNotebookAsync(ImportNotebookRequest request, final AsyncHandler<ImportNotebookRequest, ImportNotebookResult> asyncHandler) {
        final ImportNotebookRequest finalRequest = (ImportNotebookRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ImportNotebookResult>(){

            @Override
            public ImportNotebookResult call() throws Exception {
                ImportNotebookResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeImportNotebook(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListApplicationDPUSizesResult> listApplicationDPUSizesAsync(ListApplicationDPUSizesRequest request) {
        return this.listApplicationDPUSizesAsync(request, null);
    }

    @Override
    public Future<ListApplicationDPUSizesResult> listApplicationDPUSizesAsync(ListApplicationDPUSizesRequest request, final AsyncHandler<ListApplicationDPUSizesRequest, ListApplicationDPUSizesResult> asyncHandler) {
        final ListApplicationDPUSizesRequest finalRequest = (ListApplicationDPUSizesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListApplicationDPUSizesResult>(){

            @Override
            public ListApplicationDPUSizesResult call() throws Exception {
                ListApplicationDPUSizesResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeListApplicationDPUSizes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListCalculationExecutionsResult> listCalculationExecutionsAsync(ListCalculationExecutionsRequest request) {
        return this.listCalculationExecutionsAsync(request, null);
    }

    @Override
    public Future<ListCalculationExecutionsResult> listCalculationExecutionsAsync(ListCalculationExecutionsRequest request, final AsyncHandler<ListCalculationExecutionsRequest, ListCalculationExecutionsResult> asyncHandler) {
        final ListCalculationExecutionsRequest finalRequest = (ListCalculationExecutionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListCalculationExecutionsResult>(){

            @Override
            public ListCalculationExecutionsResult call() throws Exception {
                ListCalculationExecutionsResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeListCalculationExecutions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListCapacityReservationsResult> listCapacityReservationsAsync(ListCapacityReservationsRequest request) {
        return this.listCapacityReservationsAsync(request, null);
    }

    @Override
    public Future<ListCapacityReservationsResult> listCapacityReservationsAsync(ListCapacityReservationsRequest request, final AsyncHandler<ListCapacityReservationsRequest, ListCapacityReservationsResult> asyncHandler) {
        final ListCapacityReservationsRequest finalRequest = (ListCapacityReservationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListCapacityReservationsResult>(){

            @Override
            public ListCapacityReservationsResult call() throws Exception {
                ListCapacityReservationsResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeListCapacityReservations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDataCatalogsResult> listDataCatalogsAsync(ListDataCatalogsRequest request) {
        return this.listDataCatalogsAsync(request, null);
    }

    @Override
    public Future<ListDataCatalogsResult> listDataCatalogsAsync(ListDataCatalogsRequest request, final AsyncHandler<ListDataCatalogsRequest, ListDataCatalogsResult> asyncHandler) {
        final ListDataCatalogsRequest finalRequest = (ListDataCatalogsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDataCatalogsResult>(){

            @Override
            public ListDataCatalogsResult call() throws Exception {
                ListDataCatalogsResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeListDataCatalogs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDatabasesResult> listDatabasesAsync(ListDatabasesRequest request) {
        return this.listDatabasesAsync(request, null);
    }

    @Override
    public Future<ListDatabasesResult> listDatabasesAsync(ListDatabasesRequest request, final AsyncHandler<ListDatabasesRequest, ListDatabasesResult> asyncHandler) {
        final ListDatabasesRequest finalRequest = (ListDatabasesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDatabasesResult>(){

            @Override
            public ListDatabasesResult call() throws Exception {
                ListDatabasesResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeListDatabases(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListEngineVersionsResult> listEngineVersionsAsync(ListEngineVersionsRequest request) {
        return this.listEngineVersionsAsync(request, null);
    }

    @Override
    public Future<ListEngineVersionsResult> listEngineVersionsAsync(ListEngineVersionsRequest request, final AsyncHandler<ListEngineVersionsRequest, ListEngineVersionsResult> asyncHandler) {
        final ListEngineVersionsRequest finalRequest = (ListEngineVersionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListEngineVersionsResult>(){

            @Override
            public ListEngineVersionsResult call() throws Exception {
                ListEngineVersionsResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeListEngineVersions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListExecutorsResult> listExecutorsAsync(ListExecutorsRequest request) {
        return this.listExecutorsAsync(request, null);
    }

    @Override
    public Future<ListExecutorsResult> listExecutorsAsync(ListExecutorsRequest request, final AsyncHandler<ListExecutorsRequest, ListExecutorsResult> asyncHandler) {
        final ListExecutorsRequest finalRequest = (ListExecutorsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListExecutorsResult>(){

            @Override
            public ListExecutorsResult call() throws Exception {
                ListExecutorsResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeListExecutors(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListNamedQueriesResult> listNamedQueriesAsync(ListNamedQueriesRequest request) {
        return this.listNamedQueriesAsync(request, null);
    }

    @Override
    public Future<ListNamedQueriesResult> listNamedQueriesAsync(ListNamedQueriesRequest request, final AsyncHandler<ListNamedQueriesRequest, ListNamedQueriesResult> asyncHandler) {
        final ListNamedQueriesRequest finalRequest = (ListNamedQueriesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListNamedQueriesResult>(){

            @Override
            public ListNamedQueriesResult call() throws Exception {
                ListNamedQueriesResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeListNamedQueries(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListNotebookMetadataResult> listNotebookMetadataAsync(ListNotebookMetadataRequest request) {
        return this.listNotebookMetadataAsync(request, null);
    }

    @Override
    public Future<ListNotebookMetadataResult> listNotebookMetadataAsync(ListNotebookMetadataRequest request, final AsyncHandler<ListNotebookMetadataRequest, ListNotebookMetadataResult> asyncHandler) {
        final ListNotebookMetadataRequest finalRequest = (ListNotebookMetadataRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListNotebookMetadataResult>(){

            @Override
            public ListNotebookMetadataResult call() throws Exception {
                ListNotebookMetadataResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeListNotebookMetadata(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListNotebookSessionsResult> listNotebookSessionsAsync(ListNotebookSessionsRequest request) {
        return this.listNotebookSessionsAsync(request, null);
    }

    @Override
    public Future<ListNotebookSessionsResult> listNotebookSessionsAsync(ListNotebookSessionsRequest request, final AsyncHandler<ListNotebookSessionsRequest, ListNotebookSessionsResult> asyncHandler) {
        final ListNotebookSessionsRequest finalRequest = (ListNotebookSessionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListNotebookSessionsResult>(){

            @Override
            public ListNotebookSessionsResult call() throws Exception {
                ListNotebookSessionsResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeListNotebookSessions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPreparedStatementsResult> listPreparedStatementsAsync(ListPreparedStatementsRequest request) {
        return this.listPreparedStatementsAsync(request, null);
    }

    @Override
    public Future<ListPreparedStatementsResult> listPreparedStatementsAsync(ListPreparedStatementsRequest request, final AsyncHandler<ListPreparedStatementsRequest, ListPreparedStatementsResult> asyncHandler) {
        final ListPreparedStatementsRequest finalRequest = (ListPreparedStatementsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPreparedStatementsResult>(){

            @Override
            public ListPreparedStatementsResult call() throws Exception {
                ListPreparedStatementsResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeListPreparedStatements(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListQueryExecutionsResult> listQueryExecutionsAsync(ListQueryExecutionsRequest request) {
        return this.listQueryExecutionsAsync(request, null);
    }

    @Override
    public Future<ListQueryExecutionsResult> listQueryExecutionsAsync(ListQueryExecutionsRequest request, final AsyncHandler<ListQueryExecutionsRequest, ListQueryExecutionsResult> asyncHandler) {
        final ListQueryExecutionsRequest finalRequest = (ListQueryExecutionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListQueryExecutionsResult>(){

            @Override
            public ListQueryExecutionsResult call() throws Exception {
                ListQueryExecutionsResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeListQueryExecutions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSessionsResult> listSessionsAsync(ListSessionsRequest request) {
        return this.listSessionsAsync(request, null);
    }

    @Override
    public Future<ListSessionsResult> listSessionsAsync(ListSessionsRequest request, final AsyncHandler<ListSessionsRequest, ListSessionsResult> asyncHandler) {
        final ListSessionsRequest finalRequest = (ListSessionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListSessionsResult>(){

            @Override
            public ListSessionsResult call() throws Exception {
                ListSessionsResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeListSessions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTableMetadataResult> listTableMetadataAsync(ListTableMetadataRequest request) {
        return this.listTableMetadataAsync(request, null);
    }

    @Override
    public Future<ListTableMetadataResult> listTableMetadataAsync(ListTableMetadataRequest request, final AsyncHandler<ListTableMetadataRequest, ListTableMetadataResult> asyncHandler) {
        final ListTableMetadataRequest finalRequest = (ListTableMetadataRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTableMetadataResult>(){

            @Override
            public ListTableMetadataResult call() throws Exception {
                ListTableMetadataResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeListTableMetadata(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListWorkGroupsResult> listWorkGroupsAsync(ListWorkGroupsRequest request) {
        return this.listWorkGroupsAsync(request, null);
    }

    @Override
    public Future<ListWorkGroupsResult> listWorkGroupsAsync(ListWorkGroupsRequest request, final AsyncHandler<ListWorkGroupsRequest, ListWorkGroupsResult> asyncHandler) {
        final ListWorkGroupsRequest finalRequest = (ListWorkGroupsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListWorkGroupsResult>(){

            @Override
            public ListWorkGroupsResult call() throws Exception {
                ListWorkGroupsResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeListWorkGroups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutCapacityAssignmentConfigurationResult> putCapacityAssignmentConfigurationAsync(PutCapacityAssignmentConfigurationRequest request) {
        return this.putCapacityAssignmentConfigurationAsync(request, null);
    }

    @Override
    public Future<PutCapacityAssignmentConfigurationResult> putCapacityAssignmentConfigurationAsync(PutCapacityAssignmentConfigurationRequest request, final AsyncHandler<PutCapacityAssignmentConfigurationRequest, PutCapacityAssignmentConfigurationResult> asyncHandler) {
        final PutCapacityAssignmentConfigurationRequest finalRequest = (PutCapacityAssignmentConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutCapacityAssignmentConfigurationResult>(){

            @Override
            public PutCapacityAssignmentConfigurationResult call() throws Exception {
                PutCapacityAssignmentConfigurationResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executePutCapacityAssignmentConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartCalculationExecutionResult> startCalculationExecutionAsync(StartCalculationExecutionRequest request) {
        return this.startCalculationExecutionAsync(request, null);
    }

    @Override
    public Future<StartCalculationExecutionResult> startCalculationExecutionAsync(StartCalculationExecutionRequest request, final AsyncHandler<StartCalculationExecutionRequest, StartCalculationExecutionResult> asyncHandler) {
        final StartCalculationExecutionRequest finalRequest = (StartCalculationExecutionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartCalculationExecutionResult>(){

            @Override
            public StartCalculationExecutionResult call() throws Exception {
                StartCalculationExecutionResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeStartCalculationExecution(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartQueryExecutionResult> startQueryExecutionAsync(StartQueryExecutionRequest request) {
        return this.startQueryExecutionAsync(request, null);
    }

    @Override
    public Future<StartQueryExecutionResult> startQueryExecutionAsync(StartQueryExecutionRequest request, final AsyncHandler<StartQueryExecutionRequest, StartQueryExecutionResult> asyncHandler) {
        final StartQueryExecutionRequest finalRequest = (StartQueryExecutionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartQueryExecutionResult>(){

            @Override
            public StartQueryExecutionResult call() throws Exception {
                StartQueryExecutionResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeStartQueryExecution(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartSessionResult> startSessionAsync(StartSessionRequest request) {
        return this.startSessionAsync(request, null);
    }

    @Override
    public Future<StartSessionResult> startSessionAsync(StartSessionRequest request, final AsyncHandler<StartSessionRequest, StartSessionResult> asyncHandler) {
        final StartSessionRequest finalRequest = (StartSessionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartSessionResult>(){

            @Override
            public StartSessionResult call() throws Exception {
                StartSessionResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeStartSession(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopCalculationExecutionResult> stopCalculationExecutionAsync(StopCalculationExecutionRequest request) {
        return this.stopCalculationExecutionAsync(request, null);
    }

    @Override
    public Future<StopCalculationExecutionResult> stopCalculationExecutionAsync(StopCalculationExecutionRequest request, final AsyncHandler<StopCalculationExecutionRequest, StopCalculationExecutionResult> asyncHandler) {
        final StopCalculationExecutionRequest finalRequest = (StopCalculationExecutionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopCalculationExecutionResult>(){

            @Override
            public StopCalculationExecutionResult call() throws Exception {
                StopCalculationExecutionResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeStopCalculationExecution(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopQueryExecutionResult> stopQueryExecutionAsync(StopQueryExecutionRequest request) {
        return this.stopQueryExecutionAsync(request, null);
    }

    @Override
    public Future<StopQueryExecutionResult> stopQueryExecutionAsync(StopQueryExecutionRequest request, final AsyncHandler<StopQueryExecutionRequest, StopQueryExecutionResult> asyncHandler) {
        final StopQueryExecutionRequest finalRequest = (StopQueryExecutionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopQueryExecutionResult>(){

            @Override
            public StopQueryExecutionResult call() throws Exception {
                StopQueryExecutionResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeStopQueryExecution(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TerminateSessionResult> terminateSessionAsync(TerminateSessionRequest request) {
        return this.terminateSessionAsync(request, null);
    }

    @Override
    public Future<TerminateSessionResult> terminateSessionAsync(TerminateSessionRequest request, final AsyncHandler<TerminateSessionRequest, TerminateSessionResult> asyncHandler) {
        final TerminateSessionRequest finalRequest = (TerminateSessionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TerminateSessionResult>(){

            @Override
            public TerminateSessionResult call() throws Exception {
                TerminateSessionResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeTerminateSession(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateCapacityReservationResult> updateCapacityReservationAsync(UpdateCapacityReservationRequest request) {
        return this.updateCapacityReservationAsync(request, null);
    }

    @Override
    public Future<UpdateCapacityReservationResult> updateCapacityReservationAsync(UpdateCapacityReservationRequest request, final AsyncHandler<UpdateCapacityReservationRequest, UpdateCapacityReservationResult> asyncHandler) {
        final UpdateCapacityReservationRequest finalRequest = (UpdateCapacityReservationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateCapacityReservationResult>(){

            @Override
            public UpdateCapacityReservationResult call() throws Exception {
                UpdateCapacityReservationResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeUpdateCapacityReservation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateDataCatalogResult> updateDataCatalogAsync(UpdateDataCatalogRequest request) {
        return this.updateDataCatalogAsync(request, null);
    }

    @Override
    public Future<UpdateDataCatalogResult> updateDataCatalogAsync(UpdateDataCatalogRequest request, final AsyncHandler<UpdateDataCatalogRequest, UpdateDataCatalogResult> asyncHandler) {
        final UpdateDataCatalogRequest finalRequest = (UpdateDataCatalogRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateDataCatalogResult>(){

            @Override
            public UpdateDataCatalogResult call() throws Exception {
                UpdateDataCatalogResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeUpdateDataCatalog(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateNamedQueryResult> updateNamedQueryAsync(UpdateNamedQueryRequest request) {
        return this.updateNamedQueryAsync(request, null);
    }

    @Override
    public Future<UpdateNamedQueryResult> updateNamedQueryAsync(UpdateNamedQueryRequest request, final AsyncHandler<UpdateNamedQueryRequest, UpdateNamedQueryResult> asyncHandler) {
        final UpdateNamedQueryRequest finalRequest = (UpdateNamedQueryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateNamedQueryResult>(){

            @Override
            public UpdateNamedQueryResult call() throws Exception {
                UpdateNamedQueryResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeUpdateNamedQuery(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateNotebookResult> updateNotebookAsync(UpdateNotebookRequest request) {
        return this.updateNotebookAsync(request, null);
    }

    @Override
    public Future<UpdateNotebookResult> updateNotebookAsync(UpdateNotebookRequest request, final AsyncHandler<UpdateNotebookRequest, UpdateNotebookResult> asyncHandler) {
        final UpdateNotebookRequest finalRequest = (UpdateNotebookRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateNotebookResult>(){

            @Override
            public UpdateNotebookResult call() throws Exception {
                UpdateNotebookResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeUpdateNotebook(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateNotebookMetadataResult> updateNotebookMetadataAsync(UpdateNotebookMetadataRequest request) {
        return this.updateNotebookMetadataAsync(request, null);
    }

    @Override
    public Future<UpdateNotebookMetadataResult> updateNotebookMetadataAsync(UpdateNotebookMetadataRequest request, final AsyncHandler<UpdateNotebookMetadataRequest, UpdateNotebookMetadataResult> asyncHandler) {
        final UpdateNotebookMetadataRequest finalRequest = (UpdateNotebookMetadataRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateNotebookMetadataResult>(){

            @Override
            public UpdateNotebookMetadataResult call() throws Exception {
                UpdateNotebookMetadataResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeUpdateNotebookMetadata(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdatePreparedStatementResult> updatePreparedStatementAsync(UpdatePreparedStatementRequest request) {
        return this.updatePreparedStatementAsync(request, null);
    }

    @Override
    public Future<UpdatePreparedStatementResult> updatePreparedStatementAsync(UpdatePreparedStatementRequest request, final AsyncHandler<UpdatePreparedStatementRequest, UpdatePreparedStatementResult> asyncHandler) {
        final UpdatePreparedStatementRequest finalRequest = (UpdatePreparedStatementRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdatePreparedStatementResult>(){

            @Override
            public UpdatePreparedStatementResult call() throws Exception {
                UpdatePreparedStatementResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeUpdatePreparedStatement(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateWorkGroupResult> updateWorkGroupAsync(UpdateWorkGroupRequest request) {
        return this.updateWorkGroupAsync(request, null);
    }

    @Override
    public Future<UpdateWorkGroupResult> updateWorkGroupAsync(UpdateWorkGroupRequest request, final AsyncHandler<UpdateWorkGroupRequest, UpdateWorkGroupResult> asyncHandler) {
        final UpdateWorkGroupRequest finalRequest = (UpdateWorkGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateWorkGroupResult>(){

            @Override
            public UpdateWorkGroupResult call() throws Exception {
                UpdateWorkGroupResult result = null;
                try {
                    result = AmazonAthenaAsyncClient.this.executeUpdateWorkGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

