/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.athena.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListNotebookMetadata" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListNotebookMetadataResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was
     * truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the
     * previous page call.
     * </p>
     */
    private String nextToken;
    /**
     * <p>
     * The list of notebook metadata for the specified workgroup.
     * </p>
     */
    private java.util.List<NotebookMetadata> notebookMetadataList;

    /**
     * <p>
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was
     * truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the
     * previous page call.
     * </p>
     * 
     * @param nextToken
     *        A token generated by the Athena service that specifies where to continue pagination if a previous request
     *        was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response
     *        object of the previous page call.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was
     * truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the
     * previous page call.
     * </p>
     * 
     * @return A token generated by the Athena service that specifies where to continue pagination if a previous request
     *         was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response
     *         object of the previous page call.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was
     * truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the
     * previous page call.
     * </p>
     * 
     * @param nextToken
     *        A token generated by the Athena service that specifies where to continue pagination if a previous request
     *        was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response
     *        object of the previous page call.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListNotebookMetadataResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * <p>
     * The list of notebook metadata for the specified workgroup.
     * </p>
     * 
     * @return The list of notebook metadata for the specified workgroup.
     */

    public java.util.List<NotebookMetadata> getNotebookMetadataList() {
        return notebookMetadataList;
    }

    /**
     * <p>
     * The list of notebook metadata for the specified workgroup.
     * </p>
     * 
     * @param notebookMetadataList
     *        The list of notebook metadata for the specified workgroup.
     */

    public void setNotebookMetadataList(java.util.Collection<NotebookMetadata> notebookMetadataList) {
        if (notebookMetadataList == null) {
            this.notebookMetadataList = null;
            return;
        }

        this.notebookMetadataList = new java.util.ArrayList<NotebookMetadata>(notebookMetadataList);
    }

    /**
     * <p>
     * The list of notebook metadata for the specified workgroup.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setNotebookMetadataList(java.util.Collection)} or {@link #withNotebookMetadataList(java.util.Collection)}
     * if you want to override the existing values.
     * </p>
     * 
     * @param notebookMetadataList
     *        The list of notebook metadata for the specified workgroup.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListNotebookMetadataResult withNotebookMetadataList(NotebookMetadata... notebookMetadataList) {
        if (this.notebookMetadataList == null) {
            setNotebookMetadataList(new java.util.ArrayList<NotebookMetadata>(notebookMetadataList.length));
        }
        for (NotebookMetadata ele : notebookMetadataList) {
            this.notebookMetadataList.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The list of notebook metadata for the specified workgroup.
     * </p>
     * 
     * @param notebookMetadataList
     *        The list of notebook metadata for the specified workgroup.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListNotebookMetadataResult withNotebookMetadataList(java.util.Collection<NotebookMetadata> notebookMetadataList) {
        setNotebookMetadataList(notebookMetadataList);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken()).append(",");
        if (getNotebookMetadataList() != null)
            sb.append("NotebookMetadataList: ").append(getNotebookMetadataList());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListNotebookMetadataResult == false)
            return false;
        ListNotebookMetadataResult other = (ListNotebookMetadataResult) obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        if (other.getNotebookMetadataList() == null ^ this.getNotebookMetadataList() == null)
            return false;
        if (other.getNotebookMetadataList() != null && other.getNotebookMetadataList().equals(this.getNotebookMetadataList()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        hashCode = prime * hashCode + ((getNotebookMetadataList() == null) ? 0 : getNotebookMetadataList().hashCode());
        return hashCode;
    }

    @Override
    public ListNotebookMetadataResult clone() {
        try {
            return (ListNotebookMetadataResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
