/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.athena.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListCapacityReservations" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListCapacityReservationsResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was
     * truncated. To obtain the next set of pages, pass in the NextToken from the response object of the previous page
     * call.
     * </p>
     */
    private String nextToken;
    /**
     * <p>
     * The capacity reservations for the current account.
     * </p>
     */
    private java.util.List<CapacityReservation> capacityReservations;

    /**
     * <p>
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was
     * truncated. To obtain the next set of pages, pass in the NextToken from the response object of the previous page
     * call.
     * </p>
     * 
     * @param nextToken
     *        A token generated by the Athena service that specifies where to continue pagination if a previous request
     *        was truncated. To obtain the next set of pages, pass in the NextToken from the response object of the
     *        previous page call.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was
     * truncated. To obtain the next set of pages, pass in the NextToken from the response object of the previous page
     * call.
     * </p>
     * 
     * @return A token generated by the Athena service that specifies where to continue pagination if a previous request
     *         was truncated. To obtain the next set of pages, pass in the NextToken from the response object of the
     *         previous page call.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was
     * truncated. To obtain the next set of pages, pass in the NextToken from the response object of the previous page
     * call.
     * </p>
     * 
     * @param nextToken
     *        A token generated by the Athena service that specifies where to continue pagination if a previous request
     *        was truncated. To obtain the next set of pages, pass in the NextToken from the response object of the
     *        previous page call.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListCapacityReservationsResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * <p>
     * The capacity reservations for the current account.
     * </p>
     * 
     * @return The capacity reservations for the current account.
     */

    public java.util.List<CapacityReservation> getCapacityReservations() {
        return capacityReservations;
    }

    /**
     * <p>
     * The capacity reservations for the current account.
     * </p>
     * 
     * @param capacityReservations
     *        The capacity reservations for the current account.
     */

    public void setCapacityReservations(java.util.Collection<CapacityReservation> capacityReservations) {
        if (capacityReservations == null) {
            this.capacityReservations = null;
            return;
        }

        this.capacityReservations = new java.util.ArrayList<CapacityReservation>(capacityReservations);
    }

    /**
     * <p>
     * The capacity reservations for the current account.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setCapacityReservations(java.util.Collection)} or {@link #withCapacityReservations(java.util.Collection)}
     * if you want to override the existing values.
     * </p>
     * 
     * @param capacityReservations
     *        The capacity reservations for the current account.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListCapacityReservationsResult withCapacityReservations(CapacityReservation... capacityReservations) {
        if (this.capacityReservations == null) {
            setCapacityReservations(new java.util.ArrayList<CapacityReservation>(capacityReservations.length));
        }
        for (CapacityReservation ele : capacityReservations) {
            this.capacityReservations.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The capacity reservations for the current account.
     * </p>
     * 
     * @param capacityReservations
     *        The capacity reservations for the current account.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListCapacityReservationsResult withCapacityReservations(java.util.Collection<CapacityReservation> capacityReservations) {
        setCapacityReservations(capacityReservations);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken()).append(",");
        if (getCapacityReservations() != null)
            sb.append("CapacityReservations: ").append(getCapacityReservations());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListCapacityReservationsResult == false)
            return false;
        ListCapacityReservationsResult other = (ListCapacityReservationsResult) obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        if (other.getCapacityReservations() == null ^ this.getCapacityReservations() == null)
            return false;
        if (other.getCapacityReservations() != null && other.getCapacityReservations().equals(this.getCapacityReservations()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        hashCode = prime * hashCode + ((getCapacityReservations() == null) ? 0 : getCapacityReservations().hashCode());
        return hashCode;
    }

    @Override
    public ListCapacityReservationsResult clone() {
        try {
            return (ListCapacityReservationsResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
