/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auditmanager.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.auditmanager.model.AssessmentControlSet;
import com.amazonaws.services.auditmanager.model.FrameworkMetadata;
import com.amazonaws.services.auditmanager.model.transform.AssessmentFrameworkMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AssessmentFramework
implements Serializable,
Cloneable,
StructuredPojo {
    private String id;
    private String arn;
    private FrameworkMetadata metadata;
    private List<AssessmentControlSet> controlSets;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public AssessmentFramework withId(String id) {
        this.setId(id);
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public AssessmentFramework withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setMetadata(FrameworkMetadata metadata) {
        this.metadata = metadata;
    }

    public FrameworkMetadata getMetadata() {
        return this.metadata;
    }

    public AssessmentFramework withMetadata(FrameworkMetadata metadata) {
        this.setMetadata(metadata);
        return this;
    }

    public List<AssessmentControlSet> getControlSets() {
        return this.controlSets;
    }

    public void setControlSets(Collection<AssessmentControlSet> controlSets) {
        if (controlSets == null) {
            this.controlSets = null;
            return;
        }
        this.controlSets = new ArrayList<AssessmentControlSet>(controlSets);
    }

    public AssessmentFramework withControlSets(AssessmentControlSet ... controlSets) {
        if (this.controlSets == null) {
            this.setControlSets(new ArrayList<AssessmentControlSet>(controlSets.length));
        }
        for (AssessmentControlSet ele : controlSets) {
            this.controlSets.add(ele);
        }
        return this;
    }

    public AssessmentFramework withControlSets(Collection<AssessmentControlSet> controlSets) {
        this.setControlSets(controlSets);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getMetadata() != null) {
            sb.append("Metadata: ").append(this.getMetadata()).append(",");
        }
        if (this.getControlSets() != null) {
            sb.append("ControlSets: ").append(this.getControlSets());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssessmentFramework)) {
            return false;
        }
        AssessmentFramework other = (AssessmentFramework)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getMetadata() == null ^ this.getMetadata() == null) {
            return false;
        }
        if (other.getMetadata() != null && !other.getMetadata().equals(this.getMetadata())) {
            return false;
        }
        if (other.getControlSets() == null ^ this.getControlSets() == null) {
            return false;
        }
        return other.getControlSets() == null || other.getControlSets().equals(this.getControlSets());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getMetadata() == null ? 0 : this.getMetadata().hashCode());
        hashCode = 31 * hashCode + (this.getControlSets() == null ? 0 : this.getControlSets().hashCode());
        return hashCode;
    }

    public AssessmentFramework clone() {
        try {
            return (AssessmentFramework)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AssessmentFrameworkMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

