/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.autoscaling.model.BatchDeleteScheduledActionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class BatchDeleteScheduledActionRequestMarshaller
implements Marshaller<Request<BatchDeleteScheduledActionRequest>, BatchDeleteScheduledActionRequest> {
    public Request<BatchDeleteScheduledActionRequest> marshall(BatchDeleteScheduledActionRequest batchDeleteScheduledActionRequest) {
        if (batchDeleteScheduledActionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)batchDeleteScheduledActionRequest, "AmazonAutoScaling");
        request.addParameter("Action", "BatchDeleteScheduledAction");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (batchDeleteScheduledActionRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)batchDeleteScheduledActionRequest.getAutoScalingGroupName()));
        }
        if (!batchDeleteScheduledActionRequest.getScheduledActionNames().isEmpty() || !((SdkInternalList)batchDeleteScheduledActionRequest.getScheduledActionNames()).isAutoConstruct()) {
            SdkInternalList scheduledActionNamesList = (SdkInternalList)batchDeleteScheduledActionRequest.getScheduledActionNames();
            int scheduledActionNamesListIndex = 1;
            for (String scheduledActionNamesListValue : scheduledActionNamesList) {
                if (scheduledActionNamesListValue != null) {
                    request.addParameter("ScheduledActionNames.member." + scheduledActionNamesListIndex, StringUtils.fromString((String)scheduledActionNamesListValue));
                }
                ++scheduledActionNamesListIndex;
            }
        }
        return request;
    }
}

