/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.autoscaling.model.ScaleInProtectedInstances;
import com.amazonaws.services.autoscaling.model.StandbyInstances;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class RefreshPreferences
implements Serializable,
Cloneable {
    private Integer minHealthyPercentage;
    private Integer instanceWarmup;
    private SdkInternalList<Integer> checkpointPercentages;
    private Integer checkpointDelay;
    private Boolean skipMatching;
    private Boolean autoRollback;
    private String scaleInProtectedInstances;
    private String standbyInstances;

    public void setMinHealthyPercentage(Integer minHealthyPercentage) {
        this.minHealthyPercentage = minHealthyPercentage;
    }

    public Integer getMinHealthyPercentage() {
        return this.minHealthyPercentage;
    }

    public RefreshPreferences withMinHealthyPercentage(Integer minHealthyPercentage) {
        this.setMinHealthyPercentage(minHealthyPercentage);
        return this;
    }

    public void setInstanceWarmup(Integer instanceWarmup) {
        this.instanceWarmup = instanceWarmup;
    }

    public Integer getInstanceWarmup() {
        return this.instanceWarmup;
    }

    public RefreshPreferences withInstanceWarmup(Integer instanceWarmup) {
        this.setInstanceWarmup(instanceWarmup);
        return this;
    }

    public List<Integer> getCheckpointPercentages() {
        if (this.checkpointPercentages == null) {
            this.checkpointPercentages = new SdkInternalList();
        }
        return this.checkpointPercentages;
    }

    public void setCheckpointPercentages(Collection<Integer> checkpointPercentages) {
        if (checkpointPercentages == null) {
            this.checkpointPercentages = null;
            return;
        }
        this.checkpointPercentages = new SdkInternalList(checkpointPercentages);
    }

    public RefreshPreferences withCheckpointPercentages(Integer ... checkpointPercentages) {
        if (this.checkpointPercentages == null) {
            this.setCheckpointPercentages((Collection<Integer>)new SdkInternalList(checkpointPercentages.length));
        }
        for (Integer ele : checkpointPercentages) {
            this.checkpointPercentages.add((Object)ele);
        }
        return this;
    }

    public RefreshPreferences withCheckpointPercentages(Collection<Integer> checkpointPercentages) {
        this.setCheckpointPercentages(checkpointPercentages);
        return this;
    }

    public void setCheckpointDelay(Integer checkpointDelay) {
        this.checkpointDelay = checkpointDelay;
    }

    public Integer getCheckpointDelay() {
        return this.checkpointDelay;
    }

    public RefreshPreferences withCheckpointDelay(Integer checkpointDelay) {
        this.setCheckpointDelay(checkpointDelay);
        return this;
    }

    public void setSkipMatching(Boolean skipMatching) {
        this.skipMatching = skipMatching;
    }

    public Boolean getSkipMatching() {
        return this.skipMatching;
    }

    public RefreshPreferences withSkipMatching(Boolean skipMatching) {
        this.setSkipMatching(skipMatching);
        return this;
    }

    public Boolean isSkipMatching() {
        return this.skipMatching;
    }

    public void setAutoRollback(Boolean autoRollback) {
        this.autoRollback = autoRollback;
    }

    public Boolean getAutoRollback() {
        return this.autoRollback;
    }

    public RefreshPreferences withAutoRollback(Boolean autoRollback) {
        this.setAutoRollback(autoRollback);
        return this;
    }

    public Boolean isAutoRollback() {
        return this.autoRollback;
    }

    public void setScaleInProtectedInstances(String scaleInProtectedInstances) {
        this.scaleInProtectedInstances = scaleInProtectedInstances;
    }

    public String getScaleInProtectedInstances() {
        return this.scaleInProtectedInstances;
    }

    public RefreshPreferences withScaleInProtectedInstances(String scaleInProtectedInstances) {
        this.setScaleInProtectedInstances(scaleInProtectedInstances);
        return this;
    }

    public RefreshPreferences withScaleInProtectedInstances(ScaleInProtectedInstances scaleInProtectedInstances) {
        this.scaleInProtectedInstances = scaleInProtectedInstances.toString();
        return this;
    }

    public void setStandbyInstances(String standbyInstances) {
        this.standbyInstances = standbyInstances;
    }

    public String getStandbyInstances() {
        return this.standbyInstances;
    }

    public RefreshPreferences withStandbyInstances(String standbyInstances) {
        this.setStandbyInstances(standbyInstances);
        return this;
    }

    public RefreshPreferences withStandbyInstances(StandbyInstances standbyInstances) {
        this.standbyInstances = standbyInstances.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMinHealthyPercentage() != null) {
            sb.append("MinHealthyPercentage: ").append(this.getMinHealthyPercentage()).append(",");
        }
        if (this.getInstanceWarmup() != null) {
            sb.append("InstanceWarmup: ").append(this.getInstanceWarmup()).append(",");
        }
        if (this.getCheckpointPercentages() != null) {
            sb.append("CheckpointPercentages: ").append(this.getCheckpointPercentages()).append(",");
        }
        if (this.getCheckpointDelay() != null) {
            sb.append("CheckpointDelay: ").append(this.getCheckpointDelay()).append(",");
        }
        if (this.getSkipMatching() != null) {
            sb.append("SkipMatching: ").append(this.getSkipMatching()).append(",");
        }
        if (this.getAutoRollback() != null) {
            sb.append("AutoRollback: ").append(this.getAutoRollback()).append(",");
        }
        if (this.getScaleInProtectedInstances() != null) {
            sb.append("ScaleInProtectedInstances: ").append(this.getScaleInProtectedInstances()).append(",");
        }
        if (this.getStandbyInstances() != null) {
            sb.append("StandbyInstances: ").append(this.getStandbyInstances());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RefreshPreferences)) {
            return false;
        }
        RefreshPreferences other = (RefreshPreferences)obj;
        if (other.getMinHealthyPercentage() == null ^ this.getMinHealthyPercentage() == null) {
            return false;
        }
        if (other.getMinHealthyPercentage() != null && !other.getMinHealthyPercentage().equals(this.getMinHealthyPercentage())) {
            return false;
        }
        if (other.getInstanceWarmup() == null ^ this.getInstanceWarmup() == null) {
            return false;
        }
        if (other.getInstanceWarmup() != null && !other.getInstanceWarmup().equals(this.getInstanceWarmup())) {
            return false;
        }
        if (other.getCheckpointPercentages() == null ^ this.getCheckpointPercentages() == null) {
            return false;
        }
        if (other.getCheckpointPercentages() != null && !other.getCheckpointPercentages().equals(this.getCheckpointPercentages())) {
            return false;
        }
        if (other.getCheckpointDelay() == null ^ this.getCheckpointDelay() == null) {
            return false;
        }
        if (other.getCheckpointDelay() != null && !other.getCheckpointDelay().equals(this.getCheckpointDelay())) {
            return false;
        }
        if (other.getSkipMatching() == null ^ this.getSkipMatching() == null) {
            return false;
        }
        if (other.getSkipMatching() != null && !other.getSkipMatching().equals(this.getSkipMatching())) {
            return false;
        }
        if (other.getAutoRollback() == null ^ this.getAutoRollback() == null) {
            return false;
        }
        if (other.getAutoRollback() != null && !other.getAutoRollback().equals(this.getAutoRollback())) {
            return false;
        }
        if (other.getScaleInProtectedInstances() == null ^ this.getScaleInProtectedInstances() == null) {
            return false;
        }
        if (other.getScaleInProtectedInstances() != null && !other.getScaleInProtectedInstances().equals(this.getScaleInProtectedInstances())) {
            return false;
        }
        if (other.getStandbyInstances() == null ^ this.getStandbyInstances() == null) {
            return false;
        }
        return other.getStandbyInstances() == null || other.getStandbyInstances().equals(this.getStandbyInstances());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMinHealthyPercentage() == null ? 0 : this.getMinHealthyPercentage().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceWarmup() == null ? 0 : this.getInstanceWarmup().hashCode());
        hashCode = 31 * hashCode + (this.getCheckpointPercentages() == null ? 0 : this.getCheckpointPercentages().hashCode());
        hashCode = 31 * hashCode + (this.getCheckpointDelay() == null ? 0 : this.getCheckpointDelay().hashCode());
        hashCode = 31 * hashCode + (this.getSkipMatching() == null ? 0 : this.getSkipMatching().hashCode());
        hashCode = 31 * hashCode + (this.getAutoRollback() == null ? 0 : this.getAutoRollback().hashCode());
        hashCode = 31 * hashCode + (this.getScaleInProtectedInstances() == null ? 0 : this.getScaleInProtectedInstances().hashCode());
        hashCode = 31 * hashCode + (this.getStandbyInstances() == null ? 0 : this.getStandbyInstances().hashCode());
        return hashCode;
    }

    public RefreshPreferences clone() {
        try {
            return (RefreshPreferences)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

