/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.autoscaling.model.DetachTrafficSourcesRequest;
import com.amazonaws.services.autoscaling.model.TrafficSourceIdentifier;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DetachTrafficSourcesRequestMarshaller
implements Marshaller<Request<DetachTrafficSourcesRequest>, DetachTrafficSourcesRequest> {
    public Request<DetachTrafficSourcesRequest> marshall(DetachTrafficSourcesRequest detachTrafficSourcesRequest) {
        if (detachTrafficSourcesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)detachTrafficSourcesRequest, "AmazonAutoScaling");
        request.addParameter("Action", "DetachTrafficSources");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (detachTrafficSourcesRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)detachTrafficSourcesRequest.getAutoScalingGroupName()));
        }
        if (!detachTrafficSourcesRequest.getTrafficSources().isEmpty() || !((SdkInternalList)detachTrafficSourcesRequest.getTrafficSources()).isAutoConstruct()) {
            SdkInternalList trafficSourcesList = (SdkInternalList)detachTrafficSourcesRequest.getTrafficSources();
            int trafficSourcesListIndex = 1;
            for (TrafficSourceIdentifier trafficSourcesListValue : trafficSourcesList) {
                if (trafficSourcesListValue != null && trafficSourcesListValue.getIdentifier() != null) {
                    request.addParameter("TrafficSources.member." + trafficSourcesListIndex + ".Identifier", StringUtils.fromString((String)trafficSourcesListValue.getIdentifier()));
                }
                ++trafficSourcesListIndex;
            }
        }
        return request;
    }
}

