/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.autoscaling.model.Instance;
import com.amazonaws.services.autoscaling.model.WarmPoolConfiguration;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeWarmPoolResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private WarmPoolConfiguration warmPoolConfiguration;
    private SdkInternalList<Instance> instances;
    private String nextToken;

    public void setWarmPoolConfiguration(WarmPoolConfiguration warmPoolConfiguration) {
        this.warmPoolConfiguration = warmPoolConfiguration;
    }

    public WarmPoolConfiguration getWarmPoolConfiguration() {
        return this.warmPoolConfiguration;
    }

    public DescribeWarmPoolResult withWarmPoolConfiguration(WarmPoolConfiguration warmPoolConfiguration) {
        this.setWarmPoolConfiguration(warmPoolConfiguration);
        return this;
    }

    public List<Instance> getInstances() {
        if (this.instances == null) {
            this.instances = new SdkInternalList();
        }
        return this.instances;
    }

    public void setInstances(Collection<Instance> instances) {
        if (instances == null) {
            this.instances = null;
            return;
        }
        this.instances = new SdkInternalList(instances);
    }

    public DescribeWarmPoolResult withInstances(Instance ... instances) {
        if (this.instances == null) {
            this.setInstances((Collection<Instance>)new SdkInternalList(instances.length));
        }
        for (Instance ele : instances) {
            this.instances.add((Object)ele);
        }
        return this;
    }

    public DescribeWarmPoolResult withInstances(Collection<Instance> instances) {
        this.setInstances(instances);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public DescribeWarmPoolResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getWarmPoolConfiguration() != null) {
            sb.append("WarmPoolConfiguration: ").append(this.getWarmPoolConfiguration()).append(",");
        }
        if (this.getInstances() != null) {
            sb.append("Instances: ").append(this.getInstances()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWarmPoolResult)) {
            return false;
        }
        DescribeWarmPoolResult other = (DescribeWarmPoolResult)obj;
        if (other.getWarmPoolConfiguration() == null ^ this.getWarmPoolConfiguration() == null) {
            return false;
        }
        if (other.getWarmPoolConfiguration() != null && !other.getWarmPoolConfiguration().equals(this.getWarmPoolConfiguration())) {
            return false;
        }
        if (other.getInstances() == null ^ this.getInstances() == null) {
            return false;
        }
        if (other.getInstances() != null && !other.getInstances().equals(this.getInstances())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getWarmPoolConfiguration() == null ? 0 : this.getWarmPoolConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getInstances() == null ? 0 : this.getInstances().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public DescribeWarmPoolResult clone() {
        try {
            return (DescribeWarmPoolResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

