/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.backupstorage.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.backupstorage.model.DataChecksumAlgorithm;
import com.amazonaws.services.backupstorage.model.transform.ChunkMarshaller;
import java.io.Serializable;

public class Chunk
implements Serializable,
Cloneable,
StructuredPojo {
    private Long index;
    private Long length;
    private String checksum;
    private String checksumAlgorithm;
    private String chunkToken;

    public void setIndex(Long index) {
        this.index = index;
    }

    public Long getIndex() {
        return this.index;
    }

    public Chunk withIndex(Long index) {
        this.setIndex(index);
        return this;
    }

    public void setLength(Long length) {
        this.length = length;
    }

    public Long getLength() {
        return this.length;
    }

    public Chunk withLength(Long length) {
        this.setLength(length);
        return this;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public Chunk withChecksum(String checksum) {
        this.setChecksum(checksum);
        return this;
    }

    public void setChecksumAlgorithm(String checksumAlgorithm) {
        this.checksumAlgorithm = checksumAlgorithm;
    }

    public String getChecksumAlgorithm() {
        return this.checksumAlgorithm;
    }

    public Chunk withChecksumAlgorithm(String checksumAlgorithm) {
        this.setChecksumAlgorithm(checksumAlgorithm);
        return this;
    }

    public Chunk withChecksumAlgorithm(DataChecksumAlgorithm checksumAlgorithm) {
        this.checksumAlgorithm = checksumAlgorithm.toString();
        return this;
    }

    public void setChunkToken(String chunkToken) {
        this.chunkToken = chunkToken;
    }

    public String getChunkToken() {
        return this.chunkToken;
    }

    public Chunk withChunkToken(String chunkToken) {
        this.setChunkToken(chunkToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIndex() != null) {
            sb.append("Index: ").append(this.getIndex()).append(",");
        }
        if (this.getLength() != null) {
            sb.append("Length: ").append(this.getLength()).append(",");
        }
        if (this.getChecksum() != null) {
            sb.append("Checksum: ").append(this.getChecksum()).append(",");
        }
        if (this.getChecksumAlgorithm() != null) {
            sb.append("ChecksumAlgorithm: ").append(this.getChecksumAlgorithm()).append(",");
        }
        if (this.getChunkToken() != null) {
            sb.append("ChunkToken: ").append(this.getChunkToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Chunk)) {
            return false;
        }
        Chunk other = (Chunk)obj;
        if (other.getIndex() == null ^ this.getIndex() == null) {
            return false;
        }
        if (other.getIndex() != null && !other.getIndex().equals(this.getIndex())) {
            return false;
        }
        if (other.getLength() == null ^ this.getLength() == null) {
            return false;
        }
        if (other.getLength() != null && !other.getLength().equals(this.getLength())) {
            return false;
        }
        if (other.getChecksum() == null ^ this.getChecksum() == null) {
            return false;
        }
        if (other.getChecksum() != null && !other.getChecksum().equals(this.getChecksum())) {
            return false;
        }
        if (other.getChecksumAlgorithm() == null ^ this.getChecksumAlgorithm() == null) {
            return false;
        }
        if (other.getChecksumAlgorithm() != null && !other.getChecksumAlgorithm().equals(this.getChecksumAlgorithm())) {
            return false;
        }
        if (other.getChunkToken() == null ^ this.getChunkToken() == null) {
            return false;
        }
        return other.getChunkToken() == null || other.getChunkToken().equals(this.getChunkToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIndex() == null ? 0 : this.getIndex().hashCode());
        hashCode = 31 * hashCode + (this.getLength() == null ? 0 : this.getLength().hashCode());
        hashCode = 31 * hashCode + (this.getChecksum() == null ? 0 : this.getChecksum().hashCode());
        hashCode = 31 * hashCode + (this.getChecksumAlgorithm() == null ? 0 : this.getChecksumAlgorithm().hashCode());
        hashCode = 31 * hashCode + (this.getChunkToken() == null ? 0 : this.getChunkToken().hashCode());
        return hashCode;
    }

    public Chunk clone() {
        try {
            return (Chunk)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ChunkMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

