/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.backupstorage;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.backupstorage.AWSBackupStorageAsync;
import com.amazonaws.services.backupstorage.AWSBackupStorageAsyncClientBuilder;
import com.amazonaws.services.backupstorage.AWSBackupStorageClient;
import com.amazonaws.services.backupstorage.model.DeleteObjectRequest;
import com.amazonaws.services.backupstorage.model.DeleteObjectResult;
import com.amazonaws.services.backupstorage.model.GetChunkRequest;
import com.amazonaws.services.backupstorage.model.GetChunkResult;
import com.amazonaws.services.backupstorage.model.GetObjectMetadataRequest;
import com.amazonaws.services.backupstorage.model.GetObjectMetadataResult;
import com.amazonaws.services.backupstorage.model.ListChunksRequest;
import com.amazonaws.services.backupstorage.model.ListChunksResult;
import com.amazonaws.services.backupstorage.model.ListObjectsRequest;
import com.amazonaws.services.backupstorage.model.ListObjectsResult;
import com.amazonaws.services.backupstorage.model.NotifyObjectCompleteRequest;
import com.amazonaws.services.backupstorage.model.NotifyObjectCompleteResult;
import com.amazonaws.services.backupstorage.model.PutChunkRequest;
import com.amazonaws.services.backupstorage.model.PutChunkResult;
import com.amazonaws.services.backupstorage.model.PutObjectRequest;
import com.amazonaws.services.backupstorage.model.PutObjectResult;
import com.amazonaws.services.backupstorage.model.StartObjectRequest;
import com.amazonaws.services.backupstorage.model.StartObjectResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSBackupStorageAsyncClient
extends AWSBackupStorageClient
implements AWSBackupStorageAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSBackupStorageAsyncClientBuilder asyncBuilder() {
        return AWSBackupStorageAsyncClientBuilder.standard();
    }

    AWSBackupStorageAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSBackupStorageAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<DeleteObjectResult> deleteObjectAsync(DeleteObjectRequest request) {
        return this.deleteObjectAsync(request, null);
    }

    @Override
    public Future<DeleteObjectResult> deleteObjectAsync(DeleteObjectRequest request, final AsyncHandler<DeleteObjectRequest, DeleteObjectResult> asyncHandler) {
        final DeleteObjectRequest finalRequest = (DeleteObjectRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteObjectResult>(){

            @Override
            public DeleteObjectResult call() throws Exception {
                DeleteObjectResult result = null;
                try {
                    result = AWSBackupStorageAsyncClient.this.executeDeleteObject(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetChunkResult> getChunkAsync(GetChunkRequest request) {
        return this.getChunkAsync(request, null);
    }

    @Override
    public Future<GetChunkResult> getChunkAsync(GetChunkRequest request, final AsyncHandler<GetChunkRequest, GetChunkResult> asyncHandler) {
        final GetChunkRequest finalRequest = (GetChunkRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetChunkResult>(){

            @Override
            public GetChunkResult call() throws Exception {
                GetChunkResult result = null;
                try {
                    result = AWSBackupStorageAsyncClient.this.executeGetChunk(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetObjectMetadataResult> getObjectMetadataAsync(GetObjectMetadataRequest request) {
        return this.getObjectMetadataAsync(request, null);
    }

    @Override
    public Future<GetObjectMetadataResult> getObjectMetadataAsync(GetObjectMetadataRequest request, final AsyncHandler<GetObjectMetadataRequest, GetObjectMetadataResult> asyncHandler) {
        final GetObjectMetadataRequest finalRequest = (GetObjectMetadataRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetObjectMetadataResult>(){

            @Override
            public GetObjectMetadataResult call() throws Exception {
                GetObjectMetadataResult result = null;
                try {
                    result = AWSBackupStorageAsyncClient.this.executeGetObjectMetadata(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListChunksResult> listChunksAsync(ListChunksRequest request) {
        return this.listChunksAsync(request, null);
    }

    @Override
    public Future<ListChunksResult> listChunksAsync(ListChunksRequest request, final AsyncHandler<ListChunksRequest, ListChunksResult> asyncHandler) {
        final ListChunksRequest finalRequest = (ListChunksRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListChunksResult>(){

            @Override
            public ListChunksResult call() throws Exception {
                ListChunksResult result = null;
                try {
                    result = AWSBackupStorageAsyncClient.this.executeListChunks(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListObjectsResult> listObjectsAsync(ListObjectsRequest request) {
        return this.listObjectsAsync(request, null);
    }

    @Override
    public Future<ListObjectsResult> listObjectsAsync(ListObjectsRequest request, final AsyncHandler<ListObjectsRequest, ListObjectsResult> asyncHandler) {
        final ListObjectsRequest finalRequest = (ListObjectsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListObjectsResult>(){

            @Override
            public ListObjectsResult call() throws Exception {
                ListObjectsResult result = null;
                try {
                    result = AWSBackupStorageAsyncClient.this.executeListObjects(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<NotifyObjectCompleteResult> notifyObjectCompleteAsync(NotifyObjectCompleteRequest request) {
        return this.notifyObjectCompleteAsync(request, null);
    }

    @Override
    public Future<NotifyObjectCompleteResult> notifyObjectCompleteAsync(NotifyObjectCompleteRequest request, final AsyncHandler<NotifyObjectCompleteRequest, NotifyObjectCompleteResult> asyncHandler) {
        final NotifyObjectCompleteRequest finalRequest = (NotifyObjectCompleteRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<NotifyObjectCompleteResult>(){

            @Override
            public NotifyObjectCompleteResult call() throws Exception {
                NotifyObjectCompleteResult result = null;
                try {
                    result = AWSBackupStorageAsyncClient.this.executeNotifyObjectComplete(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutChunkResult> putChunkAsync(PutChunkRequest request) {
        return this.putChunkAsync(request, null);
    }

    @Override
    public Future<PutChunkResult> putChunkAsync(PutChunkRequest request, final AsyncHandler<PutChunkRequest, PutChunkResult> asyncHandler) {
        final PutChunkRequest finalRequest = (PutChunkRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutChunkResult>(){

            @Override
            public PutChunkResult call() throws Exception {
                PutChunkResult result = null;
                try {
                    result = AWSBackupStorageAsyncClient.this.executePutChunk(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutObjectResult> putObjectAsync(PutObjectRequest request) {
        return this.putObjectAsync(request, null);
    }

    @Override
    public Future<PutObjectResult> putObjectAsync(PutObjectRequest request, final AsyncHandler<PutObjectRequest, PutObjectResult> asyncHandler) {
        final PutObjectRequest finalRequest = (PutObjectRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutObjectResult>(){

            @Override
            public PutObjectResult call() throws Exception {
                PutObjectResult result = null;
                try {
                    result = AWSBackupStorageAsyncClient.this.executePutObject(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartObjectResult> startObjectAsync(StartObjectRequest request) {
        return this.startObjectAsync(request, null);
    }

    @Override
    public Future<StartObjectResult> startObjectAsync(StartObjectRequest request, final AsyncHandler<StartObjectRequest, StartObjectResult> asyncHandler) {
        final StartObjectRequest finalRequest = (StartObjectRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartObjectResult>(){

            @Override
            public StartObjectResult call() throws Exception {
                StartObjectResult result = null;
                try {
                    result = AWSBackupStorageAsyncClient.this.executeStartObject(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

