/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.backupstorage;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.backupstorage.AWSBackupStorage;
import com.amazonaws.services.backupstorage.AWSBackupStorageClientBuilder;
import com.amazonaws.services.backupstorage.model.AWSBackupStorageException;
import com.amazonaws.services.backupstorage.model.DeleteObjectRequest;
import com.amazonaws.services.backupstorage.model.DeleteObjectResult;
import com.amazonaws.services.backupstorage.model.GetChunkRequest;
import com.amazonaws.services.backupstorage.model.GetChunkResult;
import com.amazonaws.services.backupstorage.model.GetObjectMetadataRequest;
import com.amazonaws.services.backupstorage.model.GetObjectMetadataResult;
import com.amazonaws.services.backupstorage.model.ListChunksRequest;
import com.amazonaws.services.backupstorage.model.ListChunksResult;
import com.amazonaws.services.backupstorage.model.ListObjectsRequest;
import com.amazonaws.services.backupstorage.model.ListObjectsResult;
import com.amazonaws.services.backupstorage.model.NotifyObjectCompleteRequest;
import com.amazonaws.services.backupstorage.model.NotifyObjectCompleteResult;
import com.amazonaws.services.backupstorage.model.PutChunkRequest;
import com.amazonaws.services.backupstorage.model.PutChunkResult;
import com.amazonaws.services.backupstorage.model.PutObjectRequest;
import com.amazonaws.services.backupstorage.model.PutObjectResult;
import com.amazonaws.services.backupstorage.model.StartObjectRequest;
import com.amazonaws.services.backupstorage.model.StartObjectResult;
import com.amazonaws.services.backupstorage.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.backupstorage.model.transform.DataAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.backupstorage.model.transform.DeleteObjectRequestProtocolMarshaller;
import com.amazonaws.services.backupstorage.model.transform.DeleteObjectResultJsonUnmarshaller;
import com.amazonaws.services.backupstorage.model.transform.GetChunkRequestProtocolMarshaller;
import com.amazonaws.services.backupstorage.model.transform.GetChunkResultJsonUnmarshaller;
import com.amazonaws.services.backupstorage.model.transform.GetObjectMetadataRequestProtocolMarshaller;
import com.amazonaws.services.backupstorage.model.transform.GetObjectMetadataResultJsonUnmarshaller;
import com.amazonaws.services.backupstorage.model.transform.IllegalArgumentExceptionUnmarshaller;
import com.amazonaws.services.backupstorage.model.transform.KMSInvalidKeyUsageExceptionUnmarshaller;
import com.amazonaws.services.backupstorage.model.transform.ListChunksRequestProtocolMarshaller;
import com.amazonaws.services.backupstorage.model.transform.ListChunksResultJsonUnmarshaller;
import com.amazonaws.services.backupstorage.model.transform.ListObjectsRequestProtocolMarshaller;
import com.amazonaws.services.backupstorage.model.transform.ListObjectsResultJsonUnmarshaller;
import com.amazonaws.services.backupstorage.model.transform.NotReadableInputStreamExceptionUnmarshaller;
import com.amazonaws.services.backupstorage.model.transform.NotifyObjectCompleteRequestProtocolMarshaller;
import com.amazonaws.services.backupstorage.model.transform.NotifyObjectCompleteResultJsonUnmarshaller;
import com.amazonaws.services.backupstorage.model.transform.PutChunkRequestProtocolMarshaller;
import com.amazonaws.services.backupstorage.model.transform.PutChunkResultJsonUnmarshaller;
import com.amazonaws.services.backupstorage.model.transform.PutObjectRequestProtocolMarshaller;
import com.amazonaws.services.backupstorage.model.transform.PutObjectResultJsonUnmarshaller;
import com.amazonaws.services.backupstorage.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.backupstorage.model.transform.RetryableExceptionUnmarshaller;
import com.amazonaws.services.backupstorage.model.transform.ServiceInternalExceptionUnmarshaller;
import com.amazonaws.services.backupstorage.model.transform.ServiceUnavailableExceptionUnmarshaller;
import com.amazonaws.services.backupstorage.model.transform.StartObjectRequestProtocolMarshaller;
import com.amazonaws.services.backupstorage.model.transform.StartObjectResultJsonUnmarshaller;
import com.amazonaws.services.backupstorage.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSBackupStorageClient
extends AmazonWebServiceClient
implements AWSBackupStorage {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSBackupStorage.class);
    private static final String DEFAULT_SIGNING_NAME = "backup-storage";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceUnavailableException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceUnavailableExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotReadableInputStreamException").withExceptionUnmarshaller((JsonErrorUnmarshaller)NotReadableInputStreamExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("KMSInvalidKeyUsageException").withExceptionUnmarshaller((JsonErrorUnmarshaller)KMSInvalidKeyUsageExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("IllegalArgumentException").withExceptionUnmarshaller((JsonErrorUnmarshaller)IllegalArgumentExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DataAlreadyExistsException").withExceptionUnmarshaller((JsonErrorUnmarshaller)DataAlreadyExistsExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceInternalException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceInternalExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RetryableException").withExceptionUnmarshaller((JsonErrorUnmarshaller)RetryableExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSBackupStorageException.class));

    public static AWSBackupStorageClientBuilder builder() {
        return AWSBackupStorageClientBuilder.standard();
    }

    AWSBackupStorageClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSBackupStorageClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix("backupstorage");
        this.setEndpoint("backupstorage.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/backupstorage/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/backupstorage/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public DeleteObjectResult deleteObject(DeleteObjectRequest request) {
        request = (DeleteObjectRequest)this.beforeClientExecution(request);
        return this.executeDeleteObject(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteObjectResult executeDeleteObject(DeleteObjectRequest deleteObjectRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteObjectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteObjectRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteObjectRequestProtocolMarshaller(protocolFactory).marshall((DeleteObjectRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteObjectRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"BackupStorage");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteObject");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteObjectResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteObjectResult deleteObjectResult = (DeleteObjectResult)response.getAwsResponse();
            return deleteObjectResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetChunkResult getChunk(GetChunkRequest request) {
        request = (GetChunkRequest)this.beforeClientExecution(request);
        return this.executeGetChunk(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetChunkResult executeGetChunk(GetChunkRequest getChunkRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getChunkRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetChunkRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetChunkRequestProtocolMarshaller(protocolFactory).marshall((GetChunkRequest)super.beforeMarshalling((AmazonWebServiceRequest)getChunkRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"BackupStorage");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetChunk");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(false).withHasStreamingSuccessResponse(true), (Unmarshaller)new GetChunkResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            request.addHandlerContext(HandlerContextKey.HAS_STREAMING_OUTPUT, (Object)Boolean.TRUE);
            GetChunkResult getChunkResult = (GetChunkResult)response.getAwsResponse();
            return getChunkResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetObjectMetadataResult getObjectMetadata(GetObjectMetadataRequest request) {
        request = (GetObjectMetadataRequest)this.beforeClientExecution(request);
        return this.executeGetObjectMetadata(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetObjectMetadataResult executeGetObjectMetadata(GetObjectMetadataRequest getObjectMetadataRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getObjectMetadataRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetObjectMetadataRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetObjectMetadataRequestProtocolMarshaller(protocolFactory).marshall((GetObjectMetadataRequest)super.beforeMarshalling((AmazonWebServiceRequest)getObjectMetadataRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"BackupStorage");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetObjectMetadata");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(false).withHasStreamingSuccessResponse(true), (Unmarshaller)new GetObjectMetadataResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            request.addHandlerContext(HandlerContextKey.HAS_STREAMING_OUTPUT, (Object)Boolean.TRUE);
            GetObjectMetadataResult getObjectMetadataResult = (GetObjectMetadataResult)response.getAwsResponse();
            return getObjectMetadataResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListChunksResult listChunks(ListChunksRequest request) {
        request = (ListChunksRequest)this.beforeClientExecution(request);
        return this.executeListChunks(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListChunksResult executeListChunks(ListChunksRequest listChunksRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listChunksRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListChunksRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListChunksRequestProtocolMarshaller(protocolFactory).marshall((ListChunksRequest)super.beforeMarshalling((AmazonWebServiceRequest)listChunksRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"BackupStorage");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListChunks");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListChunksResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListChunksResult listChunksResult = (ListChunksResult)response.getAwsResponse();
            return listChunksResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListObjectsResult listObjects(ListObjectsRequest request) {
        request = (ListObjectsRequest)this.beforeClientExecution(request);
        return this.executeListObjects(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListObjectsResult executeListObjects(ListObjectsRequest listObjectsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listObjectsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListObjectsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListObjectsRequestProtocolMarshaller(protocolFactory).marshall((ListObjectsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listObjectsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"BackupStorage");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListObjects");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListObjectsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListObjectsResult listObjectsResult = (ListObjectsResult)response.getAwsResponse();
            return listObjectsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public NotifyObjectCompleteResult notifyObjectComplete(NotifyObjectCompleteRequest request) {
        request = (NotifyObjectCompleteRequest)this.beforeClientExecution(request);
        return this.executeNotifyObjectComplete(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final NotifyObjectCompleteResult executeNotifyObjectComplete(NotifyObjectCompleteRequest notifyObjectCompleteRequest) {
        ExecutionContext executionContext = this.createExecutionContext(notifyObjectCompleteRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<NotifyObjectCompleteRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new NotifyObjectCompleteRequestProtocolMarshaller(protocolFactory).marshall((NotifyObjectCompleteRequest)super.beforeMarshalling((AmazonWebServiceRequest)notifyObjectCompleteRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"BackupStorage");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"NotifyObjectComplete");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
                request.addHandlerContext(HandlerContextKey.HAS_STREAMING_INPUT, (Object)Boolean.TRUE);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new NotifyObjectCompleteResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            NotifyObjectCompleteResult notifyObjectCompleteResult = (NotifyObjectCompleteResult)response.getAwsResponse();
            return notifyObjectCompleteResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutChunkResult putChunk(PutChunkRequest request) {
        request = (PutChunkRequest)this.beforeClientExecution(request);
        return this.executePutChunk(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutChunkResult executePutChunk(PutChunkRequest putChunkRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putChunkRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutChunkRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutChunkRequestProtocolMarshaller(protocolFactory).marshall((PutChunkRequest)super.beforeMarshalling((AmazonWebServiceRequest)putChunkRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"BackupStorage");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutChunk");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
                request.addHandlerContext(HandlerContextKey.HAS_STREAMING_INPUT, (Object)Boolean.TRUE);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutChunkResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutChunkResult putChunkResult = (PutChunkResult)response.getAwsResponse();
            return putChunkResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutObjectResult putObject(PutObjectRequest request) {
        request = (PutObjectRequest)this.beforeClientExecution(request);
        return this.executePutObject(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutObjectResult executePutObject(PutObjectRequest putObjectRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putObjectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutObjectRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutObjectRequestProtocolMarshaller(protocolFactory).marshall((PutObjectRequest)super.beforeMarshalling((AmazonWebServiceRequest)putObjectRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"BackupStorage");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutObject");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
                request.addHandlerContext(HandlerContextKey.HAS_STREAMING_INPUT, (Object)Boolean.TRUE);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutObjectResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutObjectResult putObjectResult = (PutObjectResult)response.getAwsResponse();
            return putObjectResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartObjectResult startObject(StartObjectRequest request) {
        request = (StartObjectRequest)this.beforeClientExecution(request);
        return this.executeStartObject(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartObjectResult executeStartObject(StartObjectRequest startObjectRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startObjectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartObjectRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartObjectRequestProtocolMarshaller(protocolFactory).marshall((StartObjectRequest)super.beforeMarshalling((AmazonWebServiceRequest)startObjectRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"BackupStorage");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartObject");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartObjectResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartObjectResult startObjectResult = (StartObjectResult)response.getAwsResponse();
            return startObjectResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

