/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.backupstorage.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.backupstorage.model.BackupObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListObjectsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<BackupObject> objectList;
    private String nextToken;

    public List<BackupObject> getObjectList() {
        return this.objectList;
    }

    public void setObjectList(Collection<BackupObject> objectList) {
        if (objectList == null) {
            this.objectList = null;
            return;
        }
        this.objectList = new ArrayList<BackupObject>(objectList);
    }

    public ListObjectsResult withObjectList(BackupObject ... objectList) {
        if (this.objectList == null) {
            this.setObjectList(new ArrayList<BackupObject>(objectList.length));
        }
        for (BackupObject ele : objectList) {
            this.objectList.add(ele);
        }
        return this;
    }

    public ListObjectsResult withObjectList(Collection<BackupObject> objectList) {
        this.setObjectList(objectList);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListObjectsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getObjectList() != null) {
            sb.append("ObjectList: ").append(this.getObjectList()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListObjectsResult)) {
            return false;
        }
        ListObjectsResult other = (ListObjectsResult)obj;
        if (other.getObjectList() == null ^ this.getObjectList() == null) {
            return false;
        }
        if (other.getObjectList() != null && !other.getObjectList().equals(this.getObjectList())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getObjectList() == null ? 0 : this.getObjectList().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListObjectsResult clone() {
        try {
            return (ListObjectsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

