/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.backupstorage.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.backupstorage.model.PutObjectRequest;
import java.io.InputStream;

@SdkInternalApi
public class PutObjectRequestMarshaller {
    private static final MarshallingInfo<String> BACKUPJOBID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("jobId").build();
    private static final MarshallingInfo<String> OBJECTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("objectName").build();
    private static final MarshallingInfo<String> METADATASTRING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("metadata-string").build();
    private static final MarshallingInfo<InputStream> INLINECHUNK_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STREAM).marshallLocation(MarshallLocation.PAYLOAD).isExplicitPayloadMember(true).isBinary(true).build();
    private static final MarshallingInfo<Long> INLINECHUNKLENGTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("length").build();
    private static final MarshallingInfo<String> INLINECHUNKCHECKSUM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("checksum").build();
    private static final MarshallingInfo<String> INLINECHUNKCHECKSUMALGORITHM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("checksum-algorithm").build();
    private static final MarshallingInfo<String> OBJECTCHECKSUM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("object-checksum").build();
    private static final MarshallingInfo<String> OBJECTCHECKSUMALGORITHM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("object-checksum-algorithm").build();
    private static final MarshallingInfo<Boolean> THROWONDUPLICATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("throwOnDuplicate").build();
    private static final PutObjectRequestMarshaller instance = new PutObjectRequestMarshaller();

    public static PutObjectRequestMarshaller getInstance() {
        return instance;
    }

    public void marshall(PutObjectRequest putObjectRequest, ProtocolMarshaller protocolMarshaller) {
        if (putObjectRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)putObjectRequest.getBackupJobId(), BACKUPJOBID_BINDING);
            protocolMarshaller.marshall((Object)putObjectRequest.getObjectName(), OBJECTNAME_BINDING);
            protocolMarshaller.marshall((Object)putObjectRequest.getMetadataString(), METADATASTRING_BINDING);
            protocolMarshaller.marshall((Object)putObjectRequest.getInlineChunk(), INLINECHUNK_BINDING);
            protocolMarshaller.marshall((Object)putObjectRequest.getInlineChunkLength(), INLINECHUNKLENGTH_BINDING);
            protocolMarshaller.marshall((Object)putObjectRequest.getInlineChunkChecksum(), INLINECHUNKCHECKSUM_BINDING);
            protocolMarshaller.marshall((Object)putObjectRequest.getInlineChunkChecksumAlgorithm(), INLINECHUNKCHECKSUMALGORITHM_BINDING);
            protocolMarshaller.marshall((Object)putObjectRequest.getObjectChecksum(), OBJECTCHECKSUM_BINDING);
            protocolMarshaller.marshall((Object)putObjectRequest.getObjectChecksumAlgorithm(), OBJECTCHECKSUMALGORITHM_BINDING);
            protocolMarshaller.marshall((Object)putObjectRequest.getThrowOnDuplicate(), THROWONDUPLICATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

