/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.backupstorage.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.backupstorage.model.Chunk;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListChunksResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Chunk> chunkList;
    private String nextToken;

    public List<Chunk> getChunkList() {
        return this.chunkList;
    }

    public void setChunkList(Collection<Chunk> chunkList) {
        if (chunkList == null) {
            this.chunkList = null;
            return;
        }
        this.chunkList = new ArrayList<Chunk>(chunkList);
    }

    public ListChunksResult withChunkList(Chunk ... chunkList) {
        if (this.chunkList == null) {
            this.setChunkList(new ArrayList<Chunk>(chunkList.length));
        }
        for (Chunk ele : chunkList) {
            this.chunkList.add(ele);
        }
        return this;
    }

    public ListChunksResult withChunkList(Collection<Chunk> chunkList) {
        this.setChunkList(chunkList);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListChunksResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getChunkList() != null) {
            sb.append("ChunkList: ").append(this.getChunkList()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChunksResult)) {
            return false;
        }
        ListChunksResult other = (ListChunksResult)obj;
        if (other.getChunkList() == null ^ this.getChunkList() == null) {
            return false;
        }
        if (other.getChunkList() != null && !other.getChunkList().equals(this.getChunkList())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getChunkList() == null ? 0 : this.getChunkList().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListChunksResult clone() {
        try {
            return (ListChunksResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

