/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.backupstorage.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.backupstorage.model.BackupObject;

@SdkInternalApi
public class BackupObjectMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<Long> CHUNKSCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ChunksCount").build();
    private static final MarshallingInfo<String> METADATASTRING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MetadataString").build();
    private static final MarshallingInfo<String> OBJECTCHECKSUM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ObjectChecksum").build();
    private static final MarshallingInfo<String> OBJECTCHECKSUMALGORITHM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ObjectChecksumAlgorithm").build();
    private static final MarshallingInfo<String> OBJECTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ObjectToken").build();
    private static final BackupObjectMarshaller instance = new BackupObjectMarshaller();

    public static BackupObjectMarshaller getInstance() {
        return instance;
    }

    public void marshall(BackupObject backupObject, ProtocolMarshaller protocolMarshaller) {
        if (backupObject == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)backupObject.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)backupObject.getChunksCount(), CHUNKSCOUNT_BINDING);
            protocolMarshaller.marshall((Object)backupObject.getMetadataString(), METADATASTRING_BINDING);
            protocolMarshaller.marshall((Object)backupObject.getObjectChecksum(), OBJECTCHECKSUM_BINDING);
            protocolMarshaller.marshall((Object)backupObject.getObjectChecksumAlgorithm(), OBJECTCHECKSUMALGORITHM_BINDING);
            protocolMarshaller.marshall((Object)backupObject.getObjectToken(), OBJECTTOKEN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

