/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.batch.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.batch.model.ContainerProperties;
import com.amazonaws.services.batch.model.JobDefinitionType;
import com.amazonaws.services.batch.model.RetryStrategy;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class RegisterJobDefinitionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String jobDefinitionName;
    private String type;
    private Map<String, String> parameters;
    private ContainerProperties containerProperties;
    private RetryStrategy retryStrategy;

    public void setJobDefinitionName(String jobDefinitionName) {
        this.jobDefinitionName = jobDefinitionName;
    }

    public String getJobDefinitionName() {
        return this.jobDefinitionName;
    }

    public RegisterJobDefinitionRequest withJobDefinitionName(String jobDefinitionName) {
        this.setJobDefinitionName(jobDefinitionName);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public RegisterJobDefinitionRequest withType(String type) {
        this.setType(type);
        return this;
    }

    public void setType(JobDefinitionType type) {
        this.withType(type);
    }

    public RegisterJobDefinitionRequest withType(JobDefinitionType type) {
        this.type = type.toString();
        return this;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public RegisterJobDefinitionRequest withParameters(Map<String, String> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public RegisterJobDefinitionRequest addParametersEntry(String key, String value) {
        if (null == this.parameters) {
            this.parameters = new HashMap<String, String>();
        }
        if (this.parameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.parameters.put(key, value);
        return this;
    }

    public RegisterJobDefinitionRequest clearParametersEntries() {
        this.parameters = null;
        return this;
    }

    public void setContainerProperties(ContainerProperties containerProperties) {
        this.containerProperties = containerProperties;
    }

    public ContainerProperties getContainerProperties() {
        return this.containerProperties;
    }

    public RegisterJobDefinitionRequest withContainerProperties(ContainerProperties containerProperties) {
        this.setContainerProperties(containerProperties);
        return this;
    }

    public void setRetryStrategy(RetryStrategy retryStrategy) {
        this.retryStrategy = retryStrategy;
    }

    public RetryStrategy getRetryStrategy() {
        return this.retryStrategy;
    }

    public RegisterJobDefinitionRequest withRetryStrategy(RetryStrategy retryStrategy) {
        this.setRetryStrategy(retryStrategy);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getJobDefinitionName() != null) {
            sb.append("JobDefinitionName: ").append(this.getJobDefinitionName()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters()).append(",");
        }
        if (this.getContainerProperties() != null) {
            sb.append("ContainerProperties: ").append(this.getContainerProperties()).append(",");
        }
        if (this.getRetryStrategy() != null) {
            sb.append("RetryStrategy: ").append(this.getRetryStrategy());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterJobDefinitionRequest)) {
            return false;
        }
        RegisterJobDefinitionRequest other = (RegisterJobDefinitionRequest)obj;
        if (other.getJobDefinitionName() == null ^ this.getJobDefinitionName() == null) {
            return false;
        }
        if (other.getJobDefinitionName() != null && !other.getJobDefinitionName().equals(this.getJobDefinitionName())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !other.getParameters().equals(this.getParameters())) {
            return false;
        }
        if (other.getContainerProperties() == null ^ this.getContainerProperties() == null) {
            return false;
        }
        if (other.getContainerProperties() != null && !other.getContainerProperties().equals(this.getContainerProperties())) {
            return false;
        }
        if (other.getRetryStrategy() == null ^ this.getRetryStrategy() == null) {
            return false;
        }
        return other.getRetryStrategy() == null || other.getRetryStrategy().equals(this.getRetryStrategy());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getJobDefinitionName() == null ? 0 : this.getJobDefinitionName().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        hashCode = 31 * hashCode + (this.getContainerProperties() == null ? 0 : this.getContainerProperties().hashCode());
        hashCode = 31 * hashCode + (this.getRetryStrategy() == null ? 0 : this.getRetryStrategy().hashCode());
        return hashCode;
    }

    public RegisterJobDefinitionRequest clone() {
        return (RegisterJobDefinitionRequest)super.clone();
    }
}

