/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.batch.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.batch.model.NodeProperties;
import java.util.List;

@SdkInternalApi
public class NodePropertiesMarshaller {
    private static final MarshallingInfo<Integer> NUMNODES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("numNodes").build();
    private static final MarshallingInfo<Integer> MAINNODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mainNode").build();
    private static final MarshallingInfo<List> NODERANGEPROPERTIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nodeRangeProperties").build();
    private static final NodePropertiesMarshaller instance = new NodePropertiesMarshaller();

    public static NodePropertiesMarshaller getInstance() {
        return instance;
    }

    public void marshall(NodeProperties nodeProperties, ProtocolMarshaller protocolMarshaller) {
        if (nodeProperties == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)nodeProperties.getNumNodes(), NUMNODES_BINDING);
            protocolMarshaller.marshall((Object)nodeProperties.getMainNode(), MAINNODE_BINDING);
            protocolMarshaller.marshall(nodeProperties.getNodeRangeProperties(), NODERANGEPROPERTIES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

