/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrockagentruntime.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.bedrockagentruntime.model.GeneratedResponsePart;
import com.amazonaws.services.bedrockagentruntime.model.RetrievedReference;
import com.amazonaws.services.bedrockagentruntime.model.transform.CitationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Citation
implements Serializable,
Cloneable,
StructuredPojo {
    private GeneratedResponsePart generatedResponsePart;
    private List<RetrievedReference> retrievedReferences;

    public void setGeneratedResponsePart(GeneratedResponsePart generatedResponsePart) {
        this.generatedResponsePart = generatedResponsePart;
    }

    public GeneratedResponsePart getGeneratedResponsePart() {
        return this.generatedResponsePart;
    }

    public Citation withGeneratedResponsePart(GeneratedResponsePart generatedResponsePart) {
        this.setGeneratedResponsePart(generatedResponsePart);
        return this;
    }

    public List<RetrievedReference> getRetrievedReferences() {
        return this.retrievedReferences;
    }

    public void setRetrievedReferences(Collection<RetrievedReference> retrievedReferences) {
        if (retrievedReferences == null) {
            this.retrievedReferences = null;
            return;
        }
        this.retrievedReferences = new ArrayList<RetrievedReference>(retrievedReferences);
    }

    public Citation withRetrievedReferences(RetrievedReference ... retrievedReferences) {
        if (this.retrievedReferences == null) {
            this.setRetrievedReferences(new ArrayList<RetrievedReference>(retrievedReferences.length));
        }
        for (RetrievedReference ele : retrievedReferences) {
            this.retrievedReferences.add(ele);
        }
        return this;
    }

    public Citation withRetrievedReferences(Collection<RetrievedReference> retrievedReferences) {
        this.setRetrievedReferences(retrievedReferences);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGeneratedResponsePart() != null) {
            sb.append("GeneratedResponsePart: ").append(this.getGeneratedResponsePart()).append(",");
        }
        if (this.getRetrievedReferences() != null) {
            sb.append("RetrievedReferences: ").append(this.getRetrievedReferences());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Citation)) {
            return false;
        }
        Citation other = (Citation)obj;
        if (other.getGeneratedResponsePart() == null ^ this.getGeneratedResponsePart() == null) {
            return false;
        }
        if (other.getGeneratedResponsePart() != null && !other.getGeneratedResponsePart().equals(this.getGeneratedResponsePart())) {
            return false;
        }
        if (other.getRetrievedReferences() == null ^ this.getRetrievedReferences() == null) {
            return false;
        }
        return other.getRetrievedReferences() == null || other.getRetrievedReferences().equals(this.getRetrievedReferences());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGeneratedResponsePart() == null ? 0 : this.getGeneratedResponsePart().hashCode());
        hashCode = 31 * hashCode + (this.getRetrievedReferences() == null ? 0 : this.getRetrievedReferences().hashCode());
        return hashCode;
    }

    public Citation clone() {
        try {
            return (Citation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CitationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

