/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.billingconductor.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.billingconductor.model.BillingGroupStatus;
import com.amazonaws.services.billingconductor.model.transform.ListBillingGroupsFilterMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListBillingGroupsFilter
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> arns;
    private String pricingPlan;
    private List<String> statuses;

    public List<String> getArns() {
        return this.arns;
    }

    public void setArns(Collection<String> arns) {
        if (arns == null) {
            this.arns = null;
            return;
        }
        this.arns = new ArrayList<String>(arns);
    }

    public ListBillingGroupsFilter withArns(String ... arns) {
        if (this.arns == null) {
            this.setArns(new ArrayList<String>(arns.length));
        }
        for (String ele : arns) {
            this.arns.add(ele);
        }
        return this;
    }

    public ListBillingGroupsFilter withArns(Collection<String> arns) {
        this.setArns(arns);
        return this;
    }

    public void setPricingPlan(String pricingPlan) {
        this.pricingPlan = pricingPlan;
    }

    public String getPricingPlan() {
        return this.pricingPlan;
    }

    public ListBillingGroupsFilter withPricingPlan(String pricingPlan) {
        this.setPricingPlan(pricingPlan);
        return this;
    }

    public List<String> getStatuses() {
        return this.statuses;
    }

    public void setStatuses(Collection<String> statuses) {
        if (statuses == null) {
            this.statuses = null;
            return;
        }
        this.statuses = new ArrayList<String>(statuses);
    }

    public ListBillingGroupsFilter withStatuses(String ... statuses) {
        if (this.statuses == null) {
            this.setStatuses(new ArrayList<String>(statuses.length));
        }
        for (String ele : statuses) {
            this.statuses.add(ele);
        }
        return this;
    }

    public ListBillingGroupsFilter withStatuses(Collection<String> statuses) {
        this.setStatuses(statuses);
        return this;
    }

    public ListBillingGroupsFilter withStatuses(BillingGroupStatus ... statuses) {
        ArrayList<String> statusesCopy = new ArrayList<String>(statuses.length);
        for (BillingGroupStatus value : statuses) {
            statusesCopy.add(value.toString());
        }
        if (this.getStatuses() == null) {
            this.setStatuses(statusesCopy);
        } else {
            this.getStatuses().addAll(statusesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArns() != null) {
            sb.append("Arns: ").append(this.getArns()).append(",");
        }
        if (this.getPricingPlan() != null) {
            sb.append("PricingPlan: ").append(this.getPricingPlan()).append(",");
        }
        if (this.getStatuses() != null) {
            sb.append("Statuses: ").append(this.getStatuses());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBillingGroupsFilter)) {
            return false;
        }
        ListBillingGroupsFilter other = (ListBillingGroupsFilter)obj;
        if (other.getArns() == null ^ this.getArns() == null) {
            return false;
        }
        if (other.getArns() != null && !other.getArns().equals(this.getArns())) {
            return false;
        }
        if (other.getPricingPlan() == null ^ this.getPricingPlan() == null) {
            return false;
        }
        if (other.getPricingPlan() != null && !other.getPricingPlan().equals(this.getPricingPlan())) {
            return false;
        }
        if (other.getStatuses() == null ^ this.getStatuses() == null) {
            return false;
        }
        return other.getStatuses() == null || other.getStatuses().equals(this.getStatuses());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArns() == null ? 0 : this.getArns().hashCode());
        hashCode = 31 * hashCode + (this.getPricingPlan() == null ? 0 : this.getPricingPlan().hashCode());
        hashCode = 31 * hashCode + (this.getStatuses() == null ? 0 : this.getStatuses().hashCode());
        return hashCode;
    }

    public ListBillingGroupsFilter clone() {
        try {
            return (ListBillingGroupsFilter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ListBillingGroupsFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

