/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.budgets.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.budgets.model.Spend;
import java.math.BigDecimal;

@SdkInternalApi
public class SpendMarshaller {
    private static final MarshallingInfo<BigDecimal> AMOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BIG_DECIMAL).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Amount").build();
    private static final MarshallingInfo<String> UNIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Unit").build();
    private static final SpendMarshaller instance = new SpendMarshaller();

    public static SpendMarshaller getInstance() {
        return instance;
    }

    public void marshall(Spend spend, ProtocolMarshaller protocolMarshaller) {
        if (spend == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)spend.getAmount(), AMOUNT_BINDING);
            protocolMarshaller.marshall((Object)spend.getUnit(), UNIT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

