/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.chime.model.AppInstanceSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListAppInstancesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<AppInstanceSummary> appInstances;
    private String nextToken;

    public List<AppInstanceSummary> getAppInstances() {
        return this.appInstances;
    }

    public void setAppInstances(Collection<AppInstanceSummary> appInstances) {
        if (appInstances == null) {
            this.appInstances = null;
            return;
        }
        this.appInstances = new ArrayList<AppInstanceSummary>(appInstances);
    }

    public ListAppInstancesResult withAppInstances(AppInstanceSummary ... appInstances) {
        if (this.appInstances == null) {
            this.setAppInstances(new ArrayList<AppInstanceSummary>(appInstances.length));
        }
        for (AppInstanceSummary ele : appInstances) {
            this.appInstances.add(ele);
        }
        return this;
    }

    public ListAppInstancesResult withAppInstances(Collection<AppInstanceSummary> appInstances) {
        this.setAppInstances(appInstances);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListAppInstancesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAppInstances() != null) {
            sb.append("AppInstances: ").append(this.getAppInstances()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAppInstancesResult)) {
            return false;
        }
        ListAppInstancesResult other = (ListAppInstancesResult)obj;
        if (other.getAppInstances() == null ^ this.getAppInstances() == null) {
            return false;
        }
        if (other.getAppInstances() != null && !other.getAppInstances().equals(this.getAppInstances())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAppInstances() == null ? 0 : this.getAppInstances().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListAppInstancesResult clone() {
        try {
            return (ListAppInstancesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

